/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = new JBColor(new Color(228, 250, 255), new Color(63, 71, 73));
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogFilterUi myFilterUi;
    @Nullable
    private String mySingleFilteredBranch;

    public CurrentBranchHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterUi filterUi) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "<init>"));
        }
        if (filterUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "<init>"));
        }
        this.myDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
        ((VcsLogClassicFilterUi)filterUi).getLogUi().addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$1", "onChange"));
                }
                VcsLogBranchFilter branchFilter = CurrentBranchHighlighter.this.myFilterUi.getFilters().getBranchFilter();
                CurrentBranchHighlighter.this.mySingleFilteredBranch = branchFilter == null ? null : VcsLogUtil.getSingleFilteredBranch(branchFilter, dataPack.getRefs());
            }
        });
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
        if (isSelected || !this.myUiProperties.isHighlighterEnabled("CURRENT_BRANCH")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsShortCommitDetails details = this.myDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (details != null && !(details instanceof LoadingDetails)) {
            Condition<Hash> condition;
            VcsLogProvider provider = this.myDataHolder.getLogProvider(details.getRoot());
            String currentBranch = provider.getCurrentBranch(details.getRoot());
            VcsLogBranchFilter branchFilter = this.myFilterUi.getFilters().getBranchFilter();
            if (currentBranch != null && (branchFilter == null || !currentBranch.equals(this.mySingleFilteredBranch)) && (condition = this.myDataHolder.getContainingBranchesGetter().getContainedInBranchCondition(currentBranch, details.getRoot())).value(details.getId())) {
                VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
                if (vcsCommitStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "getStyle"));
                }
                return vcsCommitStyle;
            }
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterUi filterUi) {
            if (logDataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            if (uiProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            if (filterUi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterUi", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            CurrentBranchHighlighter currentBranchHighlighter = new CurrentBranchHighlighter(logDataHolder, uiProperties, filterUi);
            if (currentBranchHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "createHighlighter"));
            }
            return currentBranchHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("Current Branch" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/CurrentBranchHighlighter$Factory", "getTitle"));
            }
            return "Current Branch";
        }
    }
}

