/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.TreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public abstract class XDebuggerTreeInplaceEditor
extends TreeInplaceEditor {
    private final XDebuggerTreeNode myNode;
    protected final XDebuggerExpressionComboBox myExpressionEditor;
    protected final XDebuggerTree myTree;

    public XDebuggerTreeInplaceEditor(XDebuggerTreeNode node, @NonNls String historyId) {
        this.myNode = node;
        this.myTree = this.myNode.getTree();
        this.myExpressionEditor = new XDebuggerExpressionComboBox(this.myTree.getProject(), this.myTree.getEditorsProvider(), historyId, this.myTree.getSourcePosition());
    }

    @Override
    protected void onHidden() {
        ComboPopup popup = this.myExpressionEditor.getComboBox().getPopup();
        if (popup != null && popup.isVisible()) {
            popup.hide();
        }
    }

    @Override
    protected JComponent getPreferredFocusedComponent() {
        return this.myExpressionEditor.getPreferredFocusedComponent();
    }

    public XDebuggerTreeNode getNode() {
        return this.myNode;
    }

    @Override
    public Editor getEditor() {
        return this.myExpressionEditor.getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myExpressionEditor.getEditorComponent();
    }

    @Override
    protected TreePath getNodePath() {
        return this.myNode.getPath();
    }

    @Override
    protected JTree getTree() {
        return this.myNode.getTree();
    }

    @Override
    protected Project getProject() {
        return this.myNode.getTree().getProject();
    }
}

