/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VariableNotUsedInsideIfInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("variable.not.used.inside.if.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean isIf = (Boolean)infos[0];
        if (isIf) {
            String string = InspectionGadgetsBundle.message("variable.not.used.inside.if.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("variable.not.used.inside.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/VariableNotUsedInsideIfInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VariableNotUsedInsideIfVisitor();
    }

    private static class VariableNotUsedInsideIfVisitor
    extends BaseInspectionVisitor {
        private VariableNotUsedInsideIfVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getCondition());
            if (!(condition instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiReferenceExpression referenceExpression = VariableNotUsedInsideIfVisitor.extractVariableReference(binaryExpression);
            if (referenceExpression == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQEQ) {
                if (this.checkVariableUsage(referenceExpression, (PsiElement)expression.getThenExpression(), (PsiElement)expression.getElseExpression())) {
                    this.registerError((PsiElement)referenceExpression, Boolean.FALSE);
                }
            } else if (tokenType == JavaTokenType.NE && this.checkVariableUsage(referenceExpression, (PsiElement)expression.getElseExpression(), (PsiElement)expression.getThenExpression())) {
                this.registerError((PsiElement)referenceExpression, Boolean.FALSE);
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition = ParenthesesUtils.stripParentheses(statement.getCondition());
            if (!(condition instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiReferenceExpression referenceExpression = VariableNotUsedInsideIfVisitor.extractVariableReference(binaryExpression);
            if (referenceExpression == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType == JavaTokenType.EQEQ) {
                if (this.checkVariableUsage(referenceExpression, (PsiElement)statement.getThenBranch(), (PsiElement)statement.getElseBranch())) {
                    this.registerError((PsiElement)referenceExpression, Boolean.TRUE);
                }
            } else if (tokenType == JavaTokenType.NE && this.checkVariableUsage(referenceExpression, (PsiElement)statement.getElseBranch(), (PsiElement)statement.getThenBranch())) {
                this.registerError((PsiElement)referenceExpression, Boolean.TRUE);
            }
        }

        private boolean checkVariableUsage(PsiReferenceExpression referenceExpression, PsiElement thenContext, PsiElement elseContext) {
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)target;
            if (thenContext != null && (VariableNotUsedInsideIfVisitor.contextExits(thenContext) || VariableAccessUtils.variableIsAssigned(variable, thenContext))) {
                return false;
            }
            return elseContext != null && !VariableAccessUtils.variableIsUsed(variable, elseContext);
        }

        private static PsiReferenceExpression extractVariableReference(PsiBinaryExpression expression) {
            PsiExpression lhs = ParenthesesUtils.stripParentheses(expression.getLOperand());
            if (lhs == null) {
                return null;
            }
            PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
            if (rhs == null) {
                return null;
            }
            if (PsiType.NULL.equals((Object)rhs.getType())) {
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return null;
                }
                return (PsiReferenceExpression)lhs;
            }
            if (PsiType.NULL.equals((Object)lhs.getType())) {
                if (!(rhs instanceof PsiReferenceExpression)) {
                    return null;
                }
                return (PsiReferenceExpression)rhs;
            }
            return null;
        }

        private static boolean contextExits(PsiElement context) {
            if (context instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)context;
                PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(blockStatement.getCodeBlock());
                return VariableNotUsedInsideIfVisitor.statementExits((PsiElement)lastStatement);
            }
            return VariableNotUsedInsideIfVisitor.statementExits(context);
        }

        private static boolean statementExits(PsiElement context) {
            return context instanceof PsiReturnStatement || context instanceof PsiThrowStatement || context instanceof PsiBreakStatement || context instanceof PsiContinueStatement;
        }
    }
}

