/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableSearchUtils {
    private VariableSearchUtils() {
    }

    public static boolean variableNameResolvesToTarget(@NotNull String variableName, @NotNull PsiVariable target, @NotNull PsiElement context) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/siyeh/ig/psiutils/VariableSearchUtils", "variableNameResolvesToTarget"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/siyeh/ig/psiutils/VariableSearchUtils", "variableNameResolvesToTarget"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/psiutils/VariableSearchUtils", "variableNameResolvesToTarget"));
        }
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
        PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(variableName, context);
        return target.equals(variable);
    }

    public static boolean containsConflictingDeclarations(PsiCodeBlock block, PsiCodeBlock parentBlock) {
        ArrayList<PsiCodeBlock> followingBlocks = new ArrayList<PsiCodeBlock>();
        VariableSearchUtils.collectFollowingBlocks(block.getParent().getNextSibling(), followingBlocks);
        PsiStatement[] statements = block.getStatements();
        Project project = block.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        for (PsiStatement statement : statements) {
            PsiElement[] variables;
            if (!(statement instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
            for (PsiElement variable : variables = declaration.getDeclaredElements()) {
                if (!(variable instanceof PsiLocalVariable)) continue;
                PsiLocalVariable localVariable = (PsiLocalVariable)variable;
                String variableName = localVariable.getName();
                PsiVariable target = resolveHelper.resolveAccessibleReferencedVariable(variableName, (PsiElement)parentBlock);
                if (target != null) {
                    return true;
                }
                for (PsiCodeBlock codeBlock : followingBlocks) {
                    PsiVariable target1 = resolveHelper.resolveAccessibleReferencedVariable(variableName, (PsiElement)codeBlock);
                    if (target1 == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void collectFollowingBlocks(PsiElement element, List<PsiCodeBlock> out) {
        while (element != null) {
            if (element instanceof PsiCodeBlock) {
                out.add((PsiCodeBlock)element);
            }
            VariableSearchUtils.collectFollowingBlocks(element.getFirstChild(), out);
            element = element.getNextSibling();
        }
    }

    public static PsiExpression findDefinition(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiVariable variable) {
        PsiCodeBlock block;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/VariableSearchUtils", "findDefinition"));
        }
        if (variable == null) {
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            variable = (PsiVariable)target;
        }
        if ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
            return null;
        }
        PsiElement[] defs = DefUseUtil.getDefs(block, variable, (PsiElement)referenceExpression);
        if (defs.length != 1) {
            return null;
        }
        PsiElement def = defs[0];
        if (def instanceof PsiVariable) {
            PsiVariable target = (PsiVariable)def;
            PsiExpression initializer = target.getInitializer();
            return ParenthesesUtils.stripParentheses(initializer);
        }
        if (def instanceof PsiReferenceExpression) {
            PsiElement parent = def.getParent();
            if (!(parent instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                return null;
            }
            return ParenthesesUtils.stripParentheses(assignmentExpression.getRExpression());
        }
        return null;
    }
}

