/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.impl.ImageFileEditorImpl;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "images";
    private final ImageFileTypeManager typeManager;

    ImageFileEditorProvider(ImageFileTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageFileEditorProvider", "accept"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/editor/impl/ImageFileEditorProvider", "accept"));
        }
        return this.typeManager.isImage(file2);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageFileEditorProvider", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/editor/impl/ImageFileEditorProvider", "createEditor"));
        }
        ImageFileEditorImpl imageFileEditorImpl = new ImageFileEditorImpl(project, file2);
        if (imageFileEditorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorProvider", "createEditor"));
        }
        return imageFileEditorImpl;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/images/editor/impl/ImageFileEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file2) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "org/intellij/images/editor/impl/ImageFileEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageFileEditorProvider", "readState"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/editor/impl/ImageFileEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/images/editor/impl/ImageFileEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/images/editor/impl/ImageFileEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "org/intellij/images/editor/impl/ImageFileEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (EDITOR_TYPE_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorProvider", "getEditorTypeId"));
        }
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/images/editor/impl/ImageFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

