/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.LogEntry;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u0003!5A\u0002A\r\u00021\u0003\t+\u0002\u0002\u0001\n\r!\tQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0001R\u0007\u0005A)!\n\u0007\t\u00075\t\u0001tA\r\u0004\u0011\u0011i\u0011\u0001'\u0003\u001a\t\u0011\t\u0001\"B\u0007\u00021\u0017)C\u0002C\u0002\u000e\u0003a\u001d\u0011d\u0001\u0005\u0007\u001b\u0005Aj!\u0007\u0003\u0005\u0003!)Q\"\u0001M\u0006S)!\u0011\t\u0003\u0005\u0002\u001b\u0011I!!C\u0001\u0019\u0005a\r\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/MessagingLogger;", "", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/debugger/LogEntry;", "(Ljava/util/concurrent/ConcurrentLinkedQueue;)V", "add", "", "outMessage", "Lio/netty/buffer/ByteBuf;", "marker", "", "inMessage", ""}, moduleName="script-debugger-backend")
public final class MessagingLogger {
    private final ConcurrentLinkedQueue<LogEntry> queue;

    public final void add(@NotNull CharSequence inMessage, @NotNull String marker) {
        Intrinsics.checkParameterIsNotNull((Object)inMessage, (String)"inMessage");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        this.queue.add(new LogEntry(inMessage, marker));
    }

    public static /* bridge */ /* synthetic */ void add$default(MessagingLogger messagingLogger, CharSequence charSequence, String string, int n) {
        if ((n & 2) != 0) {
            string = "IN";
        }
        messagingLogger.add(charSequence, string);
    }

    public final void add(@NotNull ByteBuf outMessage, @NotNull String marker) {
        Intrinsics.checkParameterIsNotNull((Object)outMessage, (String)"outMessage");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        ByteBuf byteBuf = outMessage.copy();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"outMessage.copy()");
        this.queue.add(new LogEntry(byteBuf, marker));
    }

    public static /* bridge */ /* synthetic */ void add$default(MessagingLogger messagingLogger, ByteBuf byteBuf, String string, int n) {
        if ((n & 2) != 0) {
            string = "OUT";
        }
        messagingLogger.add(byteBuf, string);
    }

    public MessagingLogger(@NotNull ConcurrentLinkedQueue<LogEntry> queue) {
        Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
        this.queue = queue;
    }
}

