/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.StringsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.LogEntry;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.io.JsonReaderEx;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0001\u001b;A\u0001!\u0004\u0002\r\u0002a\u0005\u0011\u0004\u0002C\u0001\u0011\u0005i\u0011\u0001g\u0001\u001a\u0007!\u0011Q\"\u0001M\u0003)\u000e\u0019\u0001"}, strings={"createDebugLogger", "Lorg/jetbrains/debugger/MessagingLogger;", "key", "", "vm", "Lorg/jetbrains/debugger/AttachStateManager;", "UtilKt"}, moduleName="script-debugger-backend")
public final class UtilKt {
    @Nullable
    public static final MessagingLogger createDebugLogger(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, @NotNull AttachStateManager vm) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        String debugFile = Registry.stringValue((String)key);
        if (StringsKt.isNullOrEmpty((CharSequence)debugFile)) {
            return null;
        }
        ConcurrentLinkedQueue<LogEntry> queue = new ConcurrentLinkedQueue<LogEntry>();
        MessagingLogger logger = new MessagingLogger(queue);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(debugFile, queue, vm){
            final /* synthetic */ String $debugFile;
            final /* synthetic */ ConcurrentLinkedQueue $queue;
            final /* synthetic */ AttachStateManager $vm;

            public final void run() {
                File file2 = new File(FileUtil.expandUserHome((String)this.$debugFile));
                FileOutputStream out = new FileOutputStream(file2);
                OutputStreamWriter writer = ByteStreamsKt.writer$default((OutputStream)out, null, (int)1);
                writer.write("[\n");
                writer.flush();
                FileChannel fileChannel = out.getChannel();
                SimpleDateFormat dateFormatter = new SimpleDateFormat("HH.mm.ss,SSS");
                while (true) {
                    LogEntry entry;
                    if ((entry = (LogEntry)this.$queue.poll()) != null) {
                        Object message;
                        writer.write("{" + "\"" + "timestamp" + "\"" + ": " + "\"" + dateFormatter.format(entry.getTime$script_debugger_backend()) + "\"" + ", ");
                        Object object = message = entry.getMessage();
                        if (object instanceof CharSequence) {
                            writer.write("\"" + entry.getMarker() + "\"" + ": ");
                            writer.flush();
                            if (message instanceof JsonReaderEx.CharSequenceBackedByChars) {
                                fileChannel.write(((JsonReaderEx.CharSequenceBackedByChars)((Object)message)).getByteBuffer());
                            } else {
                                fileChannel.write(CharsetToolkit.UTF8_CHARSET.encode(CharBuffer.wrap((CharSequence)message)));
                            }
                            writer.write("},\n");
                            writer.flush();
                            continue;
                        }
                        if (object instanceof ByteBuf) {
                            writer.write("\"" + entry.getMarker() + "\"" + ": ");
                            writer.flush();
                            ((ByteBuf)message).getBytes(((ByteBuf)message).readerIndex(), (OutputStream)out, ((ByteBuf)message).readableBytes());
                            ((ByteBuf)message).release();
                            writer.write("},\n");
                            writer.flush();
                            continue;
                        }
                        throw (Throwable)new RuntimeException("Unknown message type");
                    }
                    Thread.sleep(1000L);
                    if (!this.$vm.isAttached()) break;
                }
                writer.write("]");
                out.close();
            }
            {
                this.$debugFile = string;
                this.$queue = concurrentLinkedQueue;
                this.$vm = attachStateManager;
            }
        });
        return logger;
    }
}

