/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntProgression;
import kotlin.RangesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.ValueModifierUtilKt;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\u0002E\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015Z\u00012A\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!\n\f\t\n5!\u0011BA\u0005\u00021\u0017AR!G\u0002\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001'\u0001\u001a\u0007!=Q\"\u0001\r\t3\rA\t\"D\u0001\u0019\t\u0015r\u0001\"C\u0007\u00021\u0011Ib\u0001c\u0005\u000e\t%\u0011\u0011\"\u0001\r\u00051)I2\u0001#\u0006\u000e\u0003aYQ5\u0007E\f\u001b\u001fI1!\u0003\u0002\r\u0002a\u0005\u0001$B)\u0004\u0003\u0011a\u0011d\u0001\u0005\u0007\u001b\u0005Aj!G\u0002\t\u001a5\t\u0001\u0004B\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005\u001a\u0007!iQ\"\u0001M\u000e"}, strings={"Lorg/jetbrains/debugger/ValueModifierUtil;", "", "()V", "appendUnquotedName", "", "builder", "Ljava/lang/StringBuilder;", "name", "", "evaluateGet", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/values/Value;", "variable", "Lorg/jetbrains/debugger/Variable;", "host", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "selfName", "propertyNamesToString", "list", "", "quotedAware", "", "setValue", "Lorg/jetbrains/annotations/NotNull;", "newValue", "modifier", "Lorg/jetbrains/debugger/ValueModifier;"}, moduleName="script-debugger-backend")
public final class ValueModifierUtil {
    public static final ValueModifierUtil INSTANCE;
    public static final ValueModifierUtil INSTANCE$;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> setValue(@NotNull Variable variable, @NotNull String newValue, @NotNull EvaluateContext evaluateContext2, @NotNull ValueModifier modifier) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)newValue, (String)"newValue");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        Intrinsics.checkParameterIsNotNull((Object)modifier, (String)"modifier");
        Promise promise2 = EvaluateContext.DefaultImpls.evaluate$default(evaluateContext2, newValue, null, false, 6);
        return $receiver.then(new AsyncFunction<T, Object>(modifier, variable, evaluateContext2){
            final /* synthetic */ ValueModifier $modifier$inlined;
            final /* synthetic */ Variable $variable$inlined;
            final /* synthetic */ EvaluateContext $evaluateContext$inlined;

            public final Promise<Object> fun(T param) {
                EvaluateResult it = (EvaluateResult)param;
                Promise<?> promise2 = this.$modifier$inlined.setValue(this.$variable$inlined, it.getValue(), this.$evaluateContext$inlined);
                if (promise2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
                }
                return promise2;
            }
            {
                this.$modifier$inlined = valueModifier;
                this.$variable$inlined = variable;
                this.$evaluateContext$inlined = evaluateContext2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Value> evaluateGet(@NotNull Variable variable, @NotNull Object host, @NotNull EvaluateContext evaluateContext2, @NotNull String selfName) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        Intrinsics.checkParameterIsNotNull((Object)selfName, (String)"selfName");
        StringBuilder builder = new StringBuilder(selfName);
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        this.appendUnquotedName(builder, string);
        String string2 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        Promise<EvaluateResult> promise2 = evaluateContext2.evaluate(string2, Collections.singletonMap(selfName, host), false);
        return $receiver.then(new Function<T, SUB_RESULT>(variable){
            final /* synthetic */ Variable $variable$inlined;

            public final SUB_RESULT fun(T param) {
                EvaluateResult it = (EvaluateResult)param;
                this.$variable$inlined.setValue(it.getValue());
                return (SUB_RESULT)it.getValue();
            }
            {
                this.$variable$inlined = variable;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String propertyNamesToString(@NotNull List<? extends String> list, boolean quotedAware) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        StringBuilder builder = new StringBuilder();
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)list)));
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                void i;
                String name = list.get((int)i);
                ValueModifierUtilKt.access$doAppendName(builder, name, quotedAware && (name.charAt(0) == '\"' || name.charAt(0) == '\''));
                if (i == n2) break;
                i += n3;
            }
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public final void appendUnquotedName(@NotNull StringBuilder builder, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ValueModifierUtilKt.access$doAppendName(builder, name, false);
    }

    static {
        new ValueModifierUtil();
    }

    private ValueModifierUtil() {
        INSTANCE = this;
        INSTANCE$ = this;
    }
}

