/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgBranchesCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepoInfo;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryReader;
import org.zmlx.hg4idea.repo.HgRepositoryUpdater;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRepositoryImpl
extends RepositoryImpl
implements HgRepository {
    private static final Logger LOG = Logger.getInstance(HgRepositoryImpl.class);
    @NotNull
    private HgVcs myVcs;
    @NotNull
    private final HgRepositoryReader myReader;
    @NotNull
    private final VirtualFile myHgDir;
    @NotNull
    private volatile HgRepoInfo myInfo;
    @NotNull
    private Set<String> myOpenedBranches;
    @NotNull
    private volatile HgConfig myConfig;
    private boolean myIsFresh;

    private HgRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull HgVcs vcs, @NotNull Disposable parentDisposable) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "<init>"));
        }
        super(vcs.getProject(), rootDir, parentDisposable);
        this.myOpenedBranches = Collections.emptySet();
        this.myIsFresh = true;
        this.myVcs = vcs;
        this.myHgDir = rootDir.findChild(".hg");
        assert (this.myHgDir != null) : ".hg directory wasn't found under " + rootDir.getPresentableUrl();
        this.myReader = new HgRepositoryReader(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myHgDir));
        this.myConfig = HgConfig.getInstance(this.getProject(), rootDir);
        this.update();
    }

    @NotNull
    public static HgRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getInstance"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getInstance"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getInstance"));
        }
        HgVcs vcs = HgVcs.getInstance(project);
        if (vcs == null) {
            throw new IllegalArgumentException("Vcs not found for project " + project);
        }
        HgRepositoryImpl repository = new HgRepositoryImpl(root, vcs, parentDisposable);
        repository.setupUpdater();
        HgRepositoryImpl hgRepositoryImpl = repository;
        if (hgRepositoryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getInstance"));
        }
        return hgRepositoryImpl;
    }

    private void setupUpdater() {
        HgRepositoryUpdater updater = new HgRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    @NotNull
    public VirtualFile getHgDir() {
        VirtualFile virtualFile = this.myHgDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getHgDir"));
        }
        return virtualFile;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myInfo.getState();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getState"));
        }
        return state;
    }

    @Nullable
    public String getCurrentBranchName() {
        String branchOrBookMarkName = this.getCurrentBookmark();
        if (StringUtil.isEmptyOrSpaces((String)branchOrBookMarkName)) {
            branchOrBookMarkName = this.getCurrentBranch();
        }
        return branchOrBookMarkName;
    }

    @NotNull
    public AbstractVcs getVcs() {
        HgVcs hgVcs = this.myVcs;
        if (hgVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getVcs"));
        }
        return hgVcs;
    }

    @Override
    @NotNull
    public String getCurrentBranch() {
        String string = this.myInfo.getCurrentBranch();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getCurrentBranch"));
        }
        return string;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @Override
    @Nullable
    public String getTipRevision() {
        return this.myInfo.getTipRevision();
    }

    @Override
    @NotNull
    public Map<String, Set<Hash>> getBranches() {
        Map<String, Set<Hash>> map = this.myInfo.getBranches();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getBranches"));
        }
        return map;
    }

    @Override
    @NotNull
    public Set<String> getOpenedBranches() {
        Set<String> set = this.myOpenedBranches;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getOpenedBranches"));
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getBookmarks() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getBookmarks();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getBookmarks"));
        }
        return collection;
    }

    @Override
    @Nullable
    public String getCurrentBookmark() {
        return this.myInfo.getCurrentBookmark();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getTags() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getTags();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getTags"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getLocalTags() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getLocalTags();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getLocalTags"));
        }
        return collection;
    }

    @Override
    @NotNull
    public HgConfig getRepositoryConfig() {
        HgConfig hgConfig = this.myConfig;
        if (hgConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getRepositoryConfig"));
        }
        return hgConfig;
    }

    @Override
    public boolean hasSubrepos() {
        return this.myInfo.hasSubrepos();
    }

    @Override
    @NotNull
    public Collection<HgNameWithHashInfo> getSubrepos() {
        Collection<HgNameWithHashInfo> collection = this.myInfo.getSubrepos();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getSubrepos"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<HgNameWithHashInfo> getMQAppliedPatches() {
        List<HgNameWithHashInfo> list = this.myInfo.getMQApplied();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getMQAppliedPatches"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getAllPatchNames() {
        List<String> list = this.myInfo.getMqPatchNames();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getAllPatchNames"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getUnappliedPatchNames() {
        final List<String> appliedPatches = HgUtil.getNamesWithoutHashes(this.getMQAppliedPatches());
        List list = ContainerUtil.filter(this.getAllPatchNames(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return !appliedPatches.contains(s);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "getUnappliedPatchNames"));
        }
        return list;
    }

    public boolean isFresh() {
        return this.myIsFresh;
    }

    public void update() {
        HgRepoInfo currentInfo = this.readRepoInfo();
        final Project project = this.getProject();
        if (!project.isDisposed() && !currentInfo.equals(this.myInfo)) {
            this.myInfo = currentInfo;
            HgCommandResult branchCommandResult = new HgBranchesCommand(project, this.getRoot()).collectBranches();
            if (branchCommandResult == null || branchCommandResult.getExitValue() != 0) {
                LOG.warn("Could not collect hg opened branches.");
                this.myOpenedBranches = this.myInfo.getBranches().keySet();
            } else {
                this.myOpenedBranches = HgBranchesCommand.collectNames(branchCommandResult);
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        ((HgUpdater)project.getMessageBus().syncPublisher(HgVcs.STATUS_TOPIC)).update(project, HgRepositoryImpl.this.getRoot());
                    }
                }
            });
        }
    }

    @NotNull
    public String toLogString() {
        String string = "HgRepository " + this.getRoot() + " : " + this.myInfo;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "toLogString"));
        }
        return string;
    }

    @NotNull
    private HgRepoInfo readRepoInfo() {
        this.myIsFresh = this.myIsFresh && this.myReader.isFresh();
        HgRepoInfo hgRepoInfo = new HgRepoInfo(this.myReader.readCurrentBranch(), this.myReader.readCurrentRevision(), this.myReader.readCurrentTipRevision(), this.myReader.readState(), this.myReader.readBranches(), this.myReader.readBookmarks(), this.myReader.readCurrentBookmark(), this.myReader.readTags(), this.myReader.readLocalTags(), this.myReader.readSubrepos(), this.myReader.readMQAppliedPatches(), this.myReader.readMqPatchNames());
        if (hgRepoInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryImpl", "readRepoInfo"));
        }
        return hgRepoInfo;
    }

    @Override
    public void updateConfig() {
        this.myConfig = HgConfig.getInstance(this.getProject(), this.getRoot());
    }
}

