/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import gnu.trove.THashMap;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ast.DelegatedMethod;

public class DelegatedMethodsContributor
extends AstTransformContributor {
    private static final Set<String> OBJECT_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"equals", "hashCode", "getClass", "clone", "toString", "notify", "notifyAll", "wait", "finalize"});
    private static final Set<String> GROOVY_OBJECT_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"invokeMethod", "getProperty", "setProperty", "getMetaClass", "setMetaClass"});

    @Override
    public void collectMethods(@NotNull GrTypeDefinition clazz, @NotNull Collection<PsiMethod> collector) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/resolve/ast/DelegatedMethodsContributor", "collectMethods"));
        }
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/plugins/groovy/lang/resolve/ast/DelegatedMethodsContributor", "collectMethods"));
        }
        HashSet processed = new HashSet();
        if (!DelegatedMethodsContributor.checkForDelegate(clazz)) {
            return;
        }
        THashMap signatures = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        DelegatedMethodsContributor.initializeSignatures(clazz, PsiSubstitutor.EMPTY, (Map<MethodSignature, PsiMethod>)signatures, (Set<PsiClass>)processed);
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
        DelegatedMethodsContributor.process(clazz, PsiSubstitutor.EMPTY, true, (Set<PsiClass>)new HashSet(), (Set<PsiClass>)processed, methods, clazz, false);
        LinkedHashSet<PsiMethod> result = new LinkedHashSet<PsiMethod>();
        for (PsiMethod method : methods) {
            DelegatedMethodsContributor.addMethodChecked((Map<MethodSignature, PsiMethod>)signatures, method, PsiSubstitutor.EMPTY, result);
        }
        collector.addAll(result);
    }

    private static boolean checkForDelegate(GrTypeDefinition clazz) {
        for (GrField field : clazz.getFields()) {
            if (PsiImplUtil.getAnnotation((PsiModifierListOwner)field, "groovy.lang.Delegate") == null) continue;
            return true;
        }
        return false;
    }

    private static void addMethodChecked(Map<MethodSignature, PsiMethod> signatures, PsiMethod method, PsiSubstitutor substitutor, @Nullable Set<PsiMethod> resultSet) {
        if (method.isConstructor()) {
            return;
        }
        if (method.hasModifierProperty("static")) {
            return;
        }
        MethodSignature signature = method.getSignature(substitutor);
        PsiMethod old = signatures.get(signature);
        if (old != null) {
            if (!old.hasModifierProperty("abstract")) {
                return;
            }
            if (resultSet != null) {
                resultSet.remove(old);
            }
        }
        signatures.put(signature, method);
        if (resultSet != null) {
            resultSet.add(method);
        }
    }

    private static void initializeSignatures(PsiClass clazz, PsiSubstitutor substitutor, Map<MethodSignature, PsiMethod> signatures, Set<PsiClass> classes) {
        if (clazz.isInterface()) {
            return;
        }
        if (classes.add(clazz)) {
            List<Object> methods;
            if (clazz instanceof GrTypeDefinition) {
                methods = new ArrayList();
                GrClassImplUtil.collectMethodsFromBody((GrTypeDefinition)clazz, methods);
            } else {
                methods = Arrays.asList(clazz.getMethods());
            }
            for (PsiMethod psiMethod : methods) {
                DelegatedMethodsContributor.addMethodChecked(signatures, psiMethod, substitutor, null);
            }
            for (PsiClassType psiClassType : DelegatedMethodsContributor.getSuperTypes(clazz)) {
                PsiClassType.ClassResolveResult result = psiClassType.resolveGenerics();
                PsiClass superClass = result.getElement();
                if (superClass == null) continue;
                PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)clazz, (PsiSubstitutor)substitutor);
                DelegatedMethodsContributor.initializeSignatures(superClass, superClassSubstitutor, signatures, classes);
            }
        }
    }

    private static void process(PsiClass clazz, PsiSubstitutor superClassSubstitutor, boolean shouldProcessDeprecated, Set<PsiClass> processedWithoutDeprecated, Set<PsiClass> processedAll, List<PsiMethod> collector, GrTypeDefinition classToDelegateTo, boolean keepParameterAnnotations) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiClassType superType : DelegatedMethodsContributor.getSuperTypes(clazz)) {
            DelegatedMethodsContributor.processClassInner(superType, superClassSubstitutor, shouldProcessDeprecated, result, classToDelegateTo, processedWithoutDeprecated, processedAll, keepParameterAnnotations);
        }
        if (clazz instanceof GrTypeDefinition) {
            for (GrField field : ((GrTypeDefinition)clazz).getFields()) {
                PsiType type;
                PsiAnnotation delegate = PsiImplUtil.getAnnotation((PsiModifierListOwner)field, "groovy.lang.Delegate");
                if (delegate == null || !((type = field.getDeclaredType()) instanceof PsiClassType)) continue;
                DelegatedMethodsContributor.processClassInner((PsiClassType)type, superClassSubstitutor, DelegatedMethodsContributor.shouldDelegateDeprecated(delegate), result, classToDelegateTo, processedWithoutDeprecated, processedAll, DelegatedMethodsContributor.shouldKeepParameterAnnotations(delegate));
            }
        }
        collector.addAll(result);
    }

    private static List<PsiClassType> getSuperTypes(PsiClass clazz) {
        if (clazz instanceof GrTypeDefinition) {
            GrExtendsClause elist = ((GrTypeDefinition)clazz).getExtendsClause();
            GrImplementsClause ilist = ((GrTypeDefinition)clazz).getImplementsClause();
            if (elist == null && ilist == null) {
                return ContainerUtil.emptyList();
            }
            ArrayList<PsiClassType> types = new ArrayList<PsiClassType>();
            if (elist != null) {
                ContainerUtil.addAll(types, (Object[])elist.getReferencedTypes());
            }
            if (ilist != null) {
                ContainerUtil.addAll(types, (Object[])ilist.getReferencedTypes());
            }
            return types;
        }
        PsiReferenceList elist = clazz.getExtendsList();
        PsiReferenceList ilist = clazz.getImplementsList();
        if (elist == null && ilist == null) {
            return ContainerUtil.emptyList();
        }
        ArrayList<PsiClassType> types = new ArrayList<PsiClassType>();
        if (elist != null) {
            ContainerUtil.addAll(types, (Object[])elist.getReferencedTypes());
        }
        if (ilist != null) {
            ContainerUtil.addAll(types, (Object[])ilist.getReferencedTypes());
        }
        return types;
    }

    private static void processClassInner(PsiClassType type, PsiSubstitutor superClassSubstitutor, boolean shouldProcessDeprecated, List<PsiMethod> result, GrTypeDefinition classToDelegateTo, Set<PsiClass> processedWithoutDeprecated, Set<PsiClass> processedAll, boolean keepParameterAnnotationsNew) {
        PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null) {
            return;
        }
        String qname = psiClass.getQualifiedName();
        if ("java.lang.Object".equals(qname)) {
            return;
        }
        if ("groovy.lang.GroovyObject".equals(qname)) {
            return;
        }
        if ("groovy.lang.GroovyObjectSupport".equals(qname)) {
            return;
        }
        PsiSubstitutor substitutor = TypesUtil.composeSubstitutors(resolveResult.getSubstitutor(), superClassSubstitutor);
        if (processedAll.contains(psiClass)) {
            return;
        }
        if (!shouldProcessDeprecated && processedWithoutDeprecated.contains(psiClass)) {
            return;
        }
        if (shouldProcessDeprecated) {
            processedAll.add(psiClass);
        } else {
            processedWithoutDeprecated.add(psiClass);
        }
        DelegatedMethodsContributor.collectMethods(psiClass, substitutor, shouldProcessDeprecated, classToDelegateTo, result, keepParameterAnnotationsNew);
        DelegatedMethodsContributor.process(psiClass, substitutor, shouldProcessDeprecated, processedWithoutDeprecated, processedAll, result, classToDelegateTo, keepParameterAnnotationsNew);
    }

    private static void collectMethods(PsiClass currentClass, PsiSubstitutor currentClassSubstitutor, boolean shouldProcessDeprecated, GrTypeDefinition classToDelegateTo, Collection<PsiMethod> collector, boolean keepParameterAnnotations) {
        List<Object> methods;
        if (currentClass instanceof GrTypeDefinition) {
            methods = new ArrayList();
            GrClassImplUtil.collectMethodsFromBody((GrTypeDefinition)currentClass, methods);
        } else {
            methods = Arrays.asList(currentClass.getMethods());
        }
        for (PsiMethod psiMethod : methods) {
            if (psiMethod.isConstructor() || psiMethod.hasModifierProperty("static") || DelegatedMethodsContributor.overridesObjectOrGroovyObject(psiMethod) || !shouldProcessDeprecated && PsiImplUtil.getAnnotation((PsiModifierListOwner)psiMethod, "java.lang.Deprecated") != null) continue;
            collector.add(DelegatedMethodsContributor.generateDelegateMethod(psiMethod, classToDelegateTo, currentClassSubstitutor, keepParameterAnnotations));
        }
    }

    private static boolean overridesObjectOrGroovyObject(PsiMethod method) {
        String name = method.getName();
        if (!OBJECT_METHODS.contains(name) && !GROOVY_OBJECT_METHODS.contains(name)) {
            return false;
        }
        PsiMethod superMethod = PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)method);
        if (superMethod == null) {
            return false;
        }
        PsiClass superClass = superMethod.getContainingClass();
        if (superClass == null) {
            return false;
        }
        String qname = superClass.getQualifiedName();
        return "java.lang.Object".equals(qname) || "groovy.lang.GroovyObject".equals(qname);
    }

    private static boolean shouldDelegateDeprecated(PsiAnnotation delegate) {
        Boolean result = GrAnnotationUtil.inferBooleanAttribute(delegate, "deprecated");
        return result != null && result != false;
    }

    private static boolean shouldKeepParameterAnnotations(PsiAnnotation delegate) {
        Boolean keepParameterAnnotations = GrAnnotationUtil.inferBooleanAttribute(delegate, "parameterAnnotations");
        return keepParameterAnnotations != null && keepParameterAnnotations != false;
    }

    private static PsiMethod generateDelegateMethod(PsiMethod method, PsiClass superClass, PsiSubstitutor substitutor, boolean keepParameterAnnotations) {
        boolean isRaw;
        LightMethodBuilder builder = new LightMethodBuilder(superClass.getManager(), (Language)GroovyLanguage.INSTANCE, method.getName());
        builder.setContainingClass(superClass);
        builder.setMethodReturnType(substitutor.substitute(method.getReturnType()));
        builder.setNavigationElement((PsiElement)method);
        builder.addModifier("public");
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        PsiClass containingClass = method.getContainingClass();
        boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor);
        if (isRaw) {
            substitutor = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createRawSubstitutor(substitutor, typeParameters);
        }
        if (!isRaw) {
            for (PsiTypeParameter typeParameter : typeParameters) {
                builder.addTypeParameter(typeParameter);
            }
        }
        PsiParameter[] originalParameters = method.getParameterList().getParameters();
        for (int i = 0; i < originalParameters.length; ++i) {
            PsiParameter originalParameter = originalParameters[i];
            PsiType type = isRaw ? TypeConversionUtil.erasure((PsiType)substitutor.substitute(originalParameter.getType())) : substitutor.substitute(originalParameter.getType());
            if (type == null) {
                type = TypesUtil.getJavaLangObject((PsiElement)superClass);
            }
            LightParameter lightParameter = new LightParameter(StringUtil.notNullize((String)originalParameter.getName(), (String)("p" + i)), type, (PsiElement)builder, (Language)JavaLanguage.INSTANCE);
            if (keepParameterAnnotations) {
                PsiCompositeModifierList delegatingModifierList = new PsiCompositeModifierList(method.getManager(), Collections.singletonList(originalParameter.getModifierList()));
                lightParameter.setModifierList((LightModifierList)delegatingModifierList);
            }
            builder.addParameter((PsiParameter)lightParameter);
        }
        builder.setBaseIcon(JetgroovyIcons.Groovy.Method);
        return new DelegatedMethod((PsiMethod)builder, method);
    }

    @Override
    public void collectImplementsTypes(GrTypeDefinition grType, Collection<PsiClassType> result) {
        GrField[] fields;
        for (GrField field : fields = grType.getCodeFields()) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            PsiType type;
            boolean shouldImplement;
            PsiAnnotation delegate = PsiImplUtil.getAnnotation((PsiModifierListOwner)field, "groovy.lang.Delegate");
            if (delegate == null || !(shouldImplement = DelegatedMethodsContributor.shouldImplementDelegatedInterfaces(delegate)) || !((type = field.getDeclaredType()) instanceof PsiClassType) || (psiClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) == null) continue;
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiClassType implementsType : psiClass.getImplementsListTypes()) {
                PsiType substituted = substitutor.substitute((PsiType)implementsType);
                if (!(substituted instanceof PsiClassType)) continue;
                result.add((PsiClassType)substituted);
            }
        }
    }

    private static boolean shouldImplementDelegatedInterfaces(PsiAnnotation delegate) {
        Boolean result = GrAnnotationUtil.inferBooleanAttribute(delegate, "interfaces");
        return result == null || result != false;
    }
}

