/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    static void renderDeviceName(IDevice d, ColoredTextContainer component) {
        DeviceRenderer.renderDeviceName(d, component, null);
    }

    static void renderDeviceName(IDevice d, ColoredTextContainer component, AvdManager avdManager) {
        String name;
        component.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
        if (d.isEmulator()) {
            AvdInfo info;
            String avdName = d.getAvdName();
            if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
                avdName = (String)info.getProperties().get("avd.ini.displayname");
            }
            if (avdName == null) {
                avdName = "unknown";
            }
            name = String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
        } else {
            name = String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
        }
        component.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState != IDevice.DeviceState.DISCONNECTED && deviceState != IDevice.DeviceState.OFFLINE) {
            component.append(DevicePropertyUtil.getBuild(d), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private static void renderCloudDeviceName(IDevice device, ColoredTextContainer component, @NotNull CloudConfigurationProvider cloudConfigurationProvider) {
        if (cloudConfigurationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cloudConfigurationProvider", "com/android/tools/idea/ddms/DeviceRenderer", "renderCloudDeviceName"));
        }
        component.setIcon(cloudConfigurationProvider.getCloudDeviceIcon());
        String cloudDeviceConfiguration = cloudConfigurationProvider.getCloudDeviceConfiguration(device);
        if (device.getState() == IDevice.DeviceState.OFFLINE) {
            component.append("Launching " + cloudDeviceConfiguration, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else {
            component.append(cloudDeviceConfiguration, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private static final CloudConfigurationProvider CLOUD_CONFIGURATION_PROVIDER = CloudConfigurationProvider.getCloudConfigurationProvider();
        private final AvdManager myAvdManager;

        public DeviceNameRenderer(@Nullable AvdManager avdManager) {
            this.myAvdManager = avdManager;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value instanceof IDevice) {
                IDevice device = (IDevice)value;
                if (CLOUD_CONFIGURATION_PROVIDER != null && CLOUD_CONFIGURATION_PROVIDER.getCloudDeviceConfiguration(device) != null) {
                    DeviceRenderer.renderCloudDeviceName(device, (ColoredTextContainer)this, DeviceNameRenderer.CLOUD_CONFIGURATION_PROVIDER);
                } else {
                    DeviceRenderer.renderDeviceName(device, (ColoredTextContainer)this, this.myAvdManager);
                }
            }
        }
    }

    public static class DeviceComboBoxRenderer
    extends ColoredListCellRenderer {
        @NotNull
        private String myEmptyText;

        public DeviceComboBoxRenderer(@NotNull String emptyText) {
            if (emptyText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/android/tools/idea/ddms/DeviceRenderer$DeviceComboBoxRenderer", "<init>"));
            }
            this.myEmptyText = emptyText;
        }

        public DeviceComboBoxRenderer() {
            this("[none]");
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else if (value instanceof IDevice) {
                DeviceRenderer.renderDeviceName((IDevice)value, (ColoredTextContainer)this);
            } else if (value == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }
    }
}

