/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.editors.systeminfo.SystemInfoCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpSysAction {
    private static final String TITLE = "Dump System Information";
    private final Project myProject;
    private final IDevice myDevice;
    private final String myService;
    private final Client myClient;

    public DumpSysAction(@NotNull Project p, @NotNull IDevice device, @NotNull String service, @Nullable Client client) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/idea/ddms/DumpSysAction", "<init>"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/ddms/DumpSysAction", "<init>"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/android/tools/idea/ddms/DumpSysAction", "<init>"));
        }
        this.myProject = p;
        this.myDevice = device;
        this.myService = service;
        this.myClient = client;
    }

    public void performAction() {
        final CountDownLatch completionLatch = new CountDownLatch(1);
        final CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        String description = this.myClient == null ? null : this.myClient.getClientData().getClientDescription();
        String pkgName = description != null ? description : "";
        final String command = String.format(Locale.US, "dumpsys %1$s %2$s", this.myService, pkgName).trim();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DumpSysAction.this.myDevice.executeShellCommand(command, (IShellOutputReceiver)receiver, 0L, null);
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        CaptureService service = CaptureService.getInstance(DumpSysAction.this.myProject);
                                        Capture capture = service.createCapture(SystemInfoCaptureType.class, receiver.getOutput().getBytes());
                                        capture.getFile().refresh(true, false);
                                        service.notifyCaptureReady(capture);
                                    }
                                    catch (IOException e) {
                                        DumpSysAction.showError(DumpSysAction.this.myProject, "Unexpected error while saving system information", e);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            DumpSysAction.showError(DumpSysAction.this.myProject, "Unexpected error while obtaining system information", e);
                        }
                        finally {
                            completionLatch.countDown();
                        }
                    }
                });
                new ShellTask(DumpSysAction.this.myProject, completionLatch, receiver).queue();
            }
        }, ModalityState.defaultModalityState());
    }

    private static void showError(final @Nullable Project project, final @NotNull String message, final @Nullable Throwable throwable) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/ddms/DumpSysAction", "showError"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String msg = message;
                if (throwable != null) {
                    msg = msg + (throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
                }
                Messages.showErrorDialog((Project)project, (String)msg, (String)DumpSysAction.TITLE);
            }
        });
    }

    private static class ShellTask
    extends Task.Modal {
        private final CountDownLatch myCompletionLatch;
        private final CollectingOutputReceiver myReceiver;

        public ShellTask(@NotNull Project project, @NotNull CountDownLatch completionLatch, @NotNull CollectingOutputReceiver receiver) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/DumpSysAction$ShellTask", "<init>"));
            }
            if (completionLatch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionLatch", "com/android/tools/idea/ddms/DumpSysAction$ShellTask", "<init>"));
            }
            if (receiver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "com/android/tools/idea/ddms/DumpSysAction$ShellTask", "<init>"));
            }
            super(project, DumpSysAction.TITLE, true);
            this.myCompletionLatch = completionLatch;
            this.myReceiver = receiver;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/ddms/DumpSysAction$ShellTask", "run"));
            }
            indicator.setIndeterminate(true);
            block2: while (true) {
                try {
                    while (!this.myCompletionLatch.await(1L, TimeUnit.SECONDS)) {
                        if (!indicator.isCanceled()) continue;
                        this.myReceiver.cancel();
                        break block2;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

