/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.hprof;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.chartlib.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientAction;
import com.android.tools.idea.editors.hprof.HprofCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class DumpHprofAction
extends AbstractClientAction {
    @NotNull
    private final Project myProject;
    @NotNull
    private EventData myEvents;

    public DumpHprofAction(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull EventData events) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/hprof/DumpHprofAction", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/ddms/hprof/DumpHprofAction", "<init>"));
        }
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/ddms/hprof/DumpHprofAction", "<init>"));
        }
        super(deviceContext, AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]), AndroidBundle.message("android.ddms.actions.dump.hprof.description", new Object[0]), AndroidIcons.Ddms.DumpHprof);
        this.myProject = project;
        this.myEvents = events;
    }

    @Override
    protected void performAction(@NotNull Client c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/ddms/hprof/DumpHprofAction", "performAction"));
        }
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new HprofRequest(c, this.myEvents));
    }

    class HprofRequest
    implements Runnable,
    AndroidDebugBridge.IClientChangeListener {
        private final Client myClient;
        private CountDownLatch myResponse;
        private final EventData myEvents;
        private EventData.Event myEvent;

        public HprofRequest(Client client, EventData events) {
            this.myClient = client;
            this.myEvents = events;
            this.myResponse = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            this.myClient.dumpHprof();
            EventData eventData = this.myEvents;
            synchronized (eventData) {
                this.myEvent = this.myEvents.start(System.currentTimeMillis(), 1);
            }
            try {
                this.myResponse.await(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            eventData = this.myEvents;
            synchronized (eventData) {
                if (this.myEvent != null) {
                    this.myEvent.stop(System.currentTimeMillis());
                }
            }
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        }

        public void clientChanged(Client client, int changeMask) {
            if (changeMask == 4096 && client == this.myClient) {
                assert (!ApplicationManager.getApplication().isDispatchThread());
                final ClientData.HprofData data = client.getClientData().getHprofData();
                if (data != null) {
                    switch (data.type) {
                        case FILE: {
                            Messages.showErrorDialog((String)AndroidBundle.message("android.ddms.actions.dump.hprof.error.unsupported", new Object[0]), (String)AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]));
                            break;
                        }
                        case DATA: {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        CaptureService service = CaptureService.getInstance(DumpHprofAction.this.myProject);
                                        Capture capture = service.createCapture(HprofCaptureType.class, data.data);
                                        service.notifyCaptureReady(capture);
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            });
                        }
                    }
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((String)"Error obtaining Hprof data", (String)AndroidBundle.message("android.ddms.actions.dump.hprof", new Object[0]));
                        }
                    });
                }
                this.myResponse.countDown();
            }
        }
    }
}

