/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitmapEvaluator {
    private static final Logger LOG = Logger.getInstance(BitmapEvaluator.class);
    private static final int MAX_DIMENSION = 1024;
    private static final Map<String, BitmapExtractor> SUPPORTED_FORMATS = ImmutableMap.of((Object)"\"ARGB_8888\"", (Object)new ARGB8888_BitmapExtractor(), (Object)"\"RGB_565\"", (Object)new RGB565_BitmapExtractor());

    @Nullable
    public static BufferedImage getBitmap(EvaluationContextImpl evaluationContext, Value bitmap) throws EvaluateException {
        List<Value> pixelValues;
        Field bufferField;
        String fqcn = bitmap.type().name();
        if ("android.graphics.drawable.BitmapDrawable".equals(fqcn) && (bitmap = BitmapEvaluator.getBitmapFromDrawable(evaluationContext, (ObjectReference)bitmap)) == null) {
            throw new RuntimeException("Unable to obtain bitmap from drawable");
        }
        String config = BitmapEvaluator.getBitmapConfigName((ObjectReference)bitmap, evaluationContext);
        if (config == null) {
            throw new RuntimeException("Unable to determine bitmap configuration");
        }
        BitmapExtractor bitmapExtractor = SUPPORTED_FORMATS.get(config);
        if (bitmapExtractor == null) {
            throw new RuntimeException("Unsupported bitmap configuration: " + config);
        }
        Dimension size = BitmapEvaluator.getDimension(evaluationContext, bitmap);
        if (size == null) {
            throw new RuntimeException("Unable to determine image dimensions.");
        }
        if (size.width > 1024 || size.height > 1024) {
            LOG.debug("Scaling down bitmap");
            bitmap = BitmapEvaluator.createScaledBitmap(evaluationContext, (ObjectReference)bitmap, size);
            if (bitmap == null) {
                throw new RuntimeException("Unable to create scaled bitmap");
            }
            size = BitmapEvaluator.getDimension(evaluationContext, bitmap);
            if (size == null) {
                throw new RuntimeException("Unable to obtained scaled bitmap's dimensions");
            }
        }
        if ((bufferField = ((ObjectReference)bitmap).referenceType().fieldByName("mBuffer")) != null) {
            Value bufferValue = ((ObjectReference)bitmap).getValue(bufferField);
            if (!(bufferValue instanceof ArrayReference)) {
                throw new RuntimeException("Image Buffer is not an array");
            }
            pixelValues = ((ArrayReference)bufferValue).getValues();
        } else {
            pixelValues = BitmapEvaluator.copyToBuffer(evaluationContext, (ObjectReference)bitmap, size);
            if (pixelValues == null) {
                throw new RuntimeException("Unable to extract image data: Bitmap has no buffer field.");
            }
        }
        byte[] argb = new byte[pixelValues.size()];
        for (int i = 0; i < pixelValues.size(); ++i) {
            Value pixelValue = pixelValues.get(i);
            if (!(pixelValue instanceof ByteValue)) continue;
            argb[i] = ((ByteValue)pixelValue).byteValue();
        }
        return bitmapExtractor.getImage(size.width, size.height, argb);
    }

    @Nullable
    private static String getBitmapConfigName(ObjectReference bitmap, EvaluationContextImpl evaluationContext) throws EvaluateException {
        Value config = BitmapEvaluator.getBitmapConfig(evaluationContext, bitmap);
        if (!(config instanceof ObjectReference)) {
            return null;
        }
        Field f = ((ObjectReference)config).referenceType().fieldByName("name");
        if (f == null) {
            return null;
        }
        return ((ObjectReference)config).getValue(f).toString();
    }

    @Nullable
    private static List<Value> copyToBuffer(EvaluationContextImpl evaluationContext, ObjectReference bitmap, Dimension size) throws EvaluateException {
        DebugProcessImpl debugProcess = evaluationContext.getDebugProcess();
        VirtualMachineProxyImpl virtualMachineProxy = debugProcess.getVirtualMachineProxy();
        List classes = virtualMachineProxy.classesByName("byte[]");
        if (classes.size() != 1 || !(classes.get(0) instanceof ArrayType)) {
            return null;
        }
        ArrayType byteArrayType = (ArrayType)classes.get(0);
        classes = virtualMachineProxy.classesByName("java.nio.ByteBuffer");
        if (classes.size() != 1 || !(classes.get(0) instanceof ClassType)) {
            return null;
        }
        ClassType byteBufferType = (ClassType)classes.get(0);
        Method wrapMethod = DebuggerUtils.findMethod((ReferenceType)byteBufferType, (String)"wrap", (String)"([B)Ljava/nio/ByteBuffer;");
        if (wrapMethod == null) {
            return null;
        }
        ArrayReference byteArray = byteArrayType.newInstance(size.width * size.height * 4);
        Value byteBufferRef = debugProcess.invokeMethod((EvaluationContext)evaluationContext, byteBufferType, wrapMethod, (List)ImmutableList.of((Object)byteArray));
        Method copyToBufferMethod = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"copyPixelsToBuffer", (String)"(Ljava/nio/Buffer;)V");
        if (copyToBufferMethod == null) {
            return null;
        }
        debugProcess.invokeMethod((EvaluationContext)evaluationContext, bitmap, copyToBufferMethod, (List)ImmutableList.of((Object)byteBufferRef));
        return byteArray.getValues();
    }

    @Nullable
    private static Dimension getDimension(@NotNull EvaluationContextImpl context, @NotNull Value bitmap) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/debug/BitmapEvaluator", "getDimension"));
        }
        if (bitmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmap", "com/android/tools/idea/debug/BitmapEvaluator", "getDimension"));
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Integer w = BitmapEvaluator.getImageDimension(context, (ObjectReference)bitmap, debugProcess, "getWidth");
        Integer h = BitmapEvaluator.getImageDimension(context, (ObjectReference)bitmap, debugProcess, "getHeight");
        return w != null & h != null ? new Dimension(w, h) : null;
    }

    @Nullable
    private static Value getBitmapConfig(EvaluationContextImpl context, ObjectReference bitmap) throws EvaluateException {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Method getConfig = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"getConfig", (String)"()Landroid/graphics/Bitmap$Config;");
        if (getConfig == null) {
            return null;
        }
        return debugProcess.invokeMethod((EvaluationContext)context, bitmap, getConfig, Collections.emptyList());
    }

    @Nullable
    private static Value getBitmapFromDrawable(@NotNull EvaluationContextImpl context, @NotNull ObjectReference bitmap) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/debug/BitmapEvaluator", "getBitmapFromDrawable"));
        }
        if (bitmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmap", "com/android/tools/idea/debug/BitmapEvaluator", "getBitmapFromDrawable"));
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Method getBitmapMethod = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"getBitmap", (String)"()Landroid/graphics/Bitmap;");
        if (getBitmapMethod == null) {
            return null;
        }
        return debugProcess.invokeMethod((EvaluationContext)context, bitmap, getBitmapMethod, Collections.emptyList());
    }

    @Nullable
    private static Value createScaledBitmap(@NotNull EvaluationContextImpl context, @NotNull ObjectReference bitmap, @NotNull Dimension currentDimensions) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/debug/BitmapEvaluator", "createScaledBitmap"));
        }
        if (bitmap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bitmap", "com/android/tools/idea/debug/BitmapEvaluator", "createScaledBitmap"));
        }
        if (currentDimensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDimensions", "com/android/tools/idea/debug/BitmapEvaluator", "createScaledBitmap"));
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        Method createScaledBitmapMethod = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)"createScaledBitmap", (String)"(Landroid/graphics/Bitmap;IIZ)Landroid/graphics/Bitmap;");
        if (createScaledBitmapMethod == null) {
            return null;
        }
        double s = Math.max(currentDimensions.getHeight(), currentDimensions.getWidth()) / 1024.0;
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        Value dstWidth = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getWidth() / s)));
        Value dstHeight = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"int", (long)((int)(currentDimensions.getHeight() / s)));
        Value filter = DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vm, (String)"boolean", (boolean)Boolean.FALSE);
        return debugProcess.invokeMethod((EvaluationContext)context, bitmap, createScaledBitmapMethod, Arrays.asList(bitmap, dstWidth, dstHeight, filter));
    }

    @Nullable
    private static Integer getImageDimension(EvaluationContextImpl context, ObjectReference bitmap, DebugProcessImpl debugProcess, String methodName) throws EvaluateException {
        Value widthValue;
        Method method = DebuggerUtils.findMethod((ReferenceType)bitmap.referenceType(), (String)methodName, (String)"()I");
        if (method != null && (widthValue = debugProcess.invokeMethod((EvaluationContext)context, bitmap, method, Collections.emptyList())) instanceof IntegerValue) {
            return ((IntegerValue)widthValue).value();
        }
        return null;
    }

    private static class RGB565_BitmapExtractor
    implements BitmapExtractor {
        private RGB565_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            int bytesPerPixel = 2;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int index = (x + y * width) * bytesPerPixel;
                    int value = rgb[index] & 0xFF | rgb[index + 1] << 8 & 0xFF00;
                    int r = (value >>> 11 & 0x1F) * 255 / 31;
                    int g = (value >>> 5 & 0x3F) * 255 / 63;
                    int b = (value & 0x1F) * 255 / 31;
                    int a = 255;
                    int rgba = a << 24 | r << 16 | g << 8 | b;
                    bufferedImage.setRGB(x, y, rgba);
                }
            }
            return bufferedImage;
        }
    }

    private static class ARGB8888_BitmapExtractor
    implements BitmapExtractor {
        private ARGB8888_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgba) {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int i = (y * width + x) * 4;
                    long rgb = 0L;
                    rgb |= ((long)rgba[i + 0] & 0xFFL) << 16;
                    rgb |= ((long)rgba[i + 1] & 0xFFL) << 8;
                    rgb |= ((long)rgba[i + 2] & 0xFFL) << 0;
                    bufferedImage.setRGB(x, y, (int)((rgb |= ((long)rgba[i + 3] & 0xFFL) << 24) & 0xFFFFFFFFFFFFFFFFL));
                }
            }
            return bufferedImage;
        }
    }

    private static interface BitmapExtractor {
        public BufferedImage getImage(int var1, int var2, byte[] var3);
    }
}

