/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.MainController;
import com.android.tools.idea.editors.gfxtrace.service.Factory;
import com.android.tools.idea.editors.gfxtrace.service.Schema;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientCache;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientRPC;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomMetadata;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.SchemaClass;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceEditor
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    public static final String SELECT_CAPTURE = "Select a capture";
    @NotNull
    public static final String SELECT_ATOM = "Select an atom";
    @NotNull
    private static final String OVERRIDE_PATH_GAPIS = "override.path.gapis";
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    @NotNull
    private static final String SERVER_HOST = "localhost";
    @NotNull
    private static final String SERVER_EXECUTABLE_NAME = "gapis";
    @NotNull
    private static final String SERVER_RELATIVE_PATH = "bin";
    private static final int SERVER_PORT = 6700;
    private static final int SERVER_LAUNCH_TIMEOUT_MS = 2000;
    private static final int SERVER_LAUNCH_SLEEP_INCREMENT_MS = 10;
    @NotNull
    private final Project myProject;
    @NotNull
    private LoadingDecorator myLoadingDecorator;
    @NotNull
    private JBPanel myView;
    @NotNull
    private final ListeningExecutorService myExecutor;
    private Process myServerProcess;
    private Socket myServerSocket;
    private ServiceClient myClient;
    @NotNull
    private List<PathListener> myPathListeners;

    public GfxTraceEditor(@NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "<init>"));
        }
        this.myView = new JBPanel((LayoutManager)new BorderLayout());
        this.myExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.myPathListeners = new ArrayList<PathListener>();
        this.myProject = project;
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myView, (Disposable)this, 0);
        this.myLoadingDecorator.setLoadingText("Initializing GFX Trace System");
        this.myLoadingDecorator.startLoading(false);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!GfxTraceEditor.this.connectToServer()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to connect to server");
                    return;
                }
                try {
                    ServiceClientRPC rpcClient = new ServiceClientRPC(GfxTraceEditor.this.myExecutor, GfxTraceEditor.this.myServerSocket.getInputStream(), GfxTraceEditor.this.myServerSocket.getOutputStream(), 1024);
                    GfxTraceEditor.this.myClient = new ServiceClientCache(rpcClient);
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to talk to server");
                    return;
                }
                ListenableFuture<Schema> schemaF = GfxTraceEditor.this.myClient.getSchema();
                Futures.addCallback(schemaF, (FutureCallback)new LoadingCallback<Schema>(LOG){

                    public void onSuccess(@Nullable Schema schema) {
                        LOG.info("Schema with " + schema.getClasses().length + " classes, " + schema.getConstants().length + " constant sets");
                        int atoms = 0;
                        for (SchemaClass schemaClass : schema.getClasses()) {
                            if (AtomMetadata.find(schemaClass) != null) {
                                ++atoms;
                            }
                            Dynamic.register((SchemaClass)schemaClass);
                        }
                        LOG.info("Schema with " + atoms + " atoms");
                        for (SchemaClass schemaClass : schema.getConstants()) {
                            ConstantSet.register((ConstantSet)schemaClass);
                        }
                    }
                });
                try {
                    byte[] data = file.contentsToByteArray();
                    LOG.info("Upload " + data.length + " bytes of gfxtrace as " + file.getPresentableName());
                    ListenableFuture<CapturePath> captureF = GfxTraceEditor.this.myClient.importCapture(file.getPresentableName(), data);
                    Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{schemaF, captureF}), (FutureCallback)new LoadingCallback<List<BinaryObject>>(LOG){

                        public void onSuccess(@Nullable List<BinaryObject> all) {
                            CapturePath path = (CapturePath)all.get(1);
                            LOG.info("Capture uploaded");
                            if (path != null) {
                                GfxTraceEditor.this.activatePath(path);
                            } else {
                                LOG.error("Invalid capture file " + file.getPresentableName());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Error reading gfxtrace file");
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GfxTraceEditor.this.myView.add((Component)MainController.createUI(GfxTraceEditor.this), (Object)"Center");
                        GfxTraceEditor.this.myLoadingDecorator.stopLoading();
                    }
                });
            }
        });
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getProject"));
        }
        return project;
    }

    @NotNull
    public JComponent getComponent() {
        JBPanel jBPanel = this.myView;
        if (jBPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getComponent"));
        }
        return jBPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("GfxTraceView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getName"));
        }
        return "GfxTraceView";
    }

    public void activatePath(final @NotNull Path path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "activatePath"));
        }
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                LOG.warn("Activate path " + path);
                for (PathListener listener : GfxTraceEditor.this.myPathListeners) {
                    listener.notifyPath(path);
                }
            }
        });
    }

    public void addPathListener(@NotNull PathListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPathListener"));
        }
        this.myPathListeners.add(listener);
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @NotNull
    public ServiceClient getClient() {
        ServiceClient serviceClient = this.myClient;
        if (serviceClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getClient"));
        }
        return serviceClient;
    }

    @NotNull
    public ListeningExecutorService getExecutor() {
        ListeningExecutorService listeningExecutorService = this.myExecutor;
        if (listeningExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "getExecutor"));
        }
        return listeningExecutorService;
    }

    public void dispose() {
        this.shutdown();
    }

    private boolean connectToServer() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Factory.register();
        this.myServerSocket = null;
        try {
            this.myServerSocket = new Socket(SERVER_HOST, 6700);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.myServerSocket != null) {
            return true;
        }
        try {
            File androidPluginDirectory = PluginPathManager.getPluginHome((String)"android");
            String pathOverride = System.getProperty(OVERRIDE_PATH_GAPIS, "");
            if (pathOverride.length() > 0) {
                androidPluginDirectory = new File(pathOverride);
            }
            File serverDirectory = new File(androidPluginDirectory, SERVER_RELATIVE_PATH);
            File serverExecutable = new File(serverDirectory, SERVER_EXECUTABLE_NAME);
            LOG.info("launch gapis: \"" + serverExecutable.getAbsolutePath() + "\"");
            ProcessBuilder pb = new ProcessBuilder(serverExecutable.getAbsolutePath());
            Map<String, String> env = pb.environment();
            String path = env.get("PATH");
            path = serverDirectory.getAbsolutePath() + File.pathSeparator + path;
            env.put("PATH", path);
            pb.directory(androidPluginDirectory);
            this.myServerProcess = pb.start();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
        for (int waitTime = 0; waitTime < 2000; waitTime += 10) {
            try {
                this.myServerSocket = new Socket(SERVER_HOST, 6700);
                return true;
            }
            catch (IOException e1) {
                this.myServerSocket = null;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    this.shutdown();
                    return false;
                }
            }
        }
        this.shutdown();
        return false;
    }

    private void setLoadingErrorTextOnEdt(final @NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/editors/gfxtrace/GfxTraceEditor", "setLoadingErrorTextOnEdt"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GfxTraceEditor.this.myLoadingDecorator.setLoadingText(error);
            }
        });
    }

    private void shutdown() {
        if (this.myServerSocket != null) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myServerProcess != null) {
            this.myServerProcess.destroy();
        }
        this.myExecutor.shutdown();
    }
}

