/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.Device;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextController
extends Controller {
    @NotNull
    public static final String TOOLBAR_NAME = "GfxTraceViewPanelToolbar";
    @NotNull
    private static final String NO_DEVICE_AVAILABLE = "No Device Available";
    @NotNull
    private static final String NO_DEVICE_SELECTED = "No Device Selected";
    @NotNull
    private static final String RETRIEVING_DEVICES = "Retrieving Devices";
    @NotNull
    private static final Logger LOG = Logger.getInstance(ContextController.class);
    @Nullable
    private DeviceEntry[] myDevices;
    @NotNull
    private final JComponent myToolBar;
    private final PathStore<DevicePath> mySelectedDevice;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new ContextController((GfxTraceEditor)editor).myToolBar;
    }

    private ContextController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "<init>"));
        }
        super(editor);
        this.mySelectedDevice = new PathStore();
        DefaultActionGroup group = new DefaultActionGroup(new AnAction[]{this.getContextAction()});
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true);
        this.myToolBar = toolbar.getComponent();
        this.myToolBar.setName(TOOLBAR_NAME);
        Futures.addCallback(this.myEditor.getClient().getDevices(), (FutureCallback)new LoadingCallback<DevicePath[]>(LOG){

            public void onSuccess(final @Nullable DevicePath[] paths) {
                if (paths == null || paths.length == 0) {
                    ContextController.access$002(ContextController.this, new DeviceEntry[0]);
                    return;
                }
                ArrayList<ListenableFuture<Device>> futures = new ArrayList<ListenableFuture<Device>>(paths.length);
                for (DevicePath path : paths) {
                    futures.add(ContextController.this.myEditor.getClient().get(path));
                }
                Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new LoadingCallback<List<Device>>(LOG){

                    public void onSuccess(final @Nullable List<Device> devices) {
                        if (devices == null || devices.size() == 0) {
                            return;
                        }
                        EdtExecutor.INSTANCE.execute(new Runnable(){

                            @Override
                            public void run() {
                                ContextController.access$002(ContextController.this, new DeviceEntry[paths.length]);
                                for (int i = 0; i < paths.length; ++i) {
                                    ((ContextController)ContextController.this).myDevices[i] = new DeviceEntry(paths[i], (Device)devices.get(i));
                                }
                                if (paths.length > 0 && ContextController.this.mySelectedDevice.update(paths[0]) && ContextController.this.mySelectedDevice.getPath() != null) {
                                    ContextController.this.myEditor.activatePath((Path)ContextController.this.mySelectedDevice.getPath());
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @NotNull
    private AnAction getContextAction() {
        ComboBoxAction comboBoxAction = new ComboBoxAction(){

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                DefaultActionGroup group = new DefaultActionGroup();
                if (ContextController.this.myDevices != null && ContextController.this.myDevices.length > 0) {
                    for (final DeviceEntry device : ContextController.this.myDevices) {
                        group.add(new AnAction(device.toString()){

                            public void actionPerformed(AnActionEvent e) {
                                if (ContextController.this.mySelectedDevice.update(device.myPath) && ContextController.this.mySelectedDevice.getPath() != null) {
                                    ContextController.this.myEditor.activatePath((Path)ContextController.this.mySelectedDevice.getPath());
                                }
                            }
                        });
                    }
                }
                DefaultActionGroup defaultActionGroup = group;
                if (defaultActionGroup == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController$2", "createPopupActionGroup"));
                }
                return defaultActionGroup;
            }

            public void update(AnActionEvent e) {
                super.update(e);
                if (ContextController.this.mySelectedDevice.getPath() != null && ContextController.this.myDevices != null) {
                    for (DeviceEntry device : ContextController.this.myDevices) {
                        if (!ContextController.this.mySelectedDevice.is(device.myPath)) continue;
                        this.getTemplatePresentation().setText(device.toString());
                        e.getPresentation().setText(device.toString());
                        break;
                    }
                    this.getTemplatePresentation().setEnabled(true);
                    e.getPresentation().setEnabled(true);
                } else if (ContextController.this.myDevices == null) {
                    this.getTemplatePresentation().setText(ContextController.RETRIEVING_DEVICES);
                    this.getTemplatePresentation().setEnabled(false);
                    e.getPresentation().setText(ContextController.RETRIEVING_DEVICES);
                    e.getPresentation().setEnabled(false);
                } else if (ContextController.this.myDevices.length == 0) {
                    this.getTemplatePresentation().setText(ContextController.NO_DEVICE_AVAILABLE);
                    this.getTemplatePresentation().setEnabled(false);
                    e.getPresentation().setText(ContextController.NO_DEVICE_AVAILABLE);
                    e.getPresentation().setEnabled(false);
                } else {
                    this.getTemplatePresentation().setText(ContextController.NO_DEVICE_SELECTED);
                    this.getTemplatePresentation().setEnabled(true);
                    e.getPresentation().setText(ContextController.NO_DEVICE_SELECTED);
                    e.getPresentation().setEnabled(true);
                }
            }
        };
        if (comboBoxAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/ContextController", "getContextAction"));
        }
        return comboBoxAction;
    }

    @Override
    public void notifyPath(Path path) {
        if (path instanceof DevicePath && this.mySelectedDevice.update((DevicePath)path) && this.myDevices != null) {
            for (DeviceEntry myDevice : this.myDevices) {
                if (!this.mySelectedDevice.is(myDevice.myPath)) continue;
                return;
            }
            this.mySelectedDevice.update(null);
        }
    }

    static /* synthetic */ DeviceEntry[] access$002(ContextController x0, DeviceEntry[] x1) {
        x0.myDevices = x1;
        return x1;
    }

    private static class DeviceEntry {
        public DevicePath myPath;
        public Device myDevice;

        public DeviceEntry(DevicePath path, Device device) {
            this.myPath = path;
            this.myDevice = device;
        }

        public String toString() {
            return this.myDevice.getName() + " (" + this.myDevice.getModel() + ", " + this.myDevice.getOS() + ")";
        }
    }
}

