/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.HashSet;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentationController
extends Controller {
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final JBScrollPane myScrollPane;
    @NotNull
    private final JTextPane myTextPane;
    @NotNull
    private Map<String, String> myDocumentationCache;
    @NotNull
    private Set<String> myRequestInProgress;
    private String myTargetUrl;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new DocumentationController((GfxTraceEditor)editor).myPanel;
    }

    private DocumentationController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/DocumentationController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel();
        this.myScrollPane = new JBScrollPane();
        this.myTextPane = new JTextPane();
        this.myDocumentationCache = new HashMap<String, String>();
        this.myRequestInProgress = new HashSet();
        this.myScrollPane.setViewportView((Component)this.myTextPane);
        this.myPanel.add((Component)this.myScrollPane, "Center");
        this.myTextPane.setBorder(BorderFactory.createLineBorder(JBColor.border()));
    }

    public void setDocumentation(final @Nullable String url) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTextPane.setText(null);
        if (url == null || url.isEmpty()) {
            return;
        }
        this.myTargetUrl = url;
        final String cachedCopy = this.myDocumentationCache.get(url);
        if (cachedCopy == null) {
            if (this.myRequestInProgress.contains(url)) {
                return;
            }
            this.myRequestInProgress.add(url);
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                boolean problemEncountered = false;
                String validCopy = cachedCopy;
                if (validCopy == null) {
                    try {
                        URLConnection connection = new URL(url).openConnection();
                        InputStream response = connection.getInputStream();
                        Scanner s = new Scanner(response).useDelimiter("\\A");
                        validCopy = s.hasNext() ? s.next() : "";
                    }
                    catch (MalformedURLException e) {
                        problemEncountered = true;
                    }
                    catch (IOException e) {
                        problemEncountered = true;
                    }
                }
                final String documentation = validCopy;
                final boolean error = problemEncountered;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (error) {
                            DocumentationController.this.myRequestInProgress.remove(url);
                        } else if (url.equals(DocumentationController.this.myTargetUrl)) {
                            DocumentationController.this.myTextPane.setText(documentation);
                        }
                        DocumentationController.this.myDocumentationCache.put(url, documentation);
                    }
                });
            }
        });
    }

    @Override
    public void notifyPath(Path path) {
    }
}

