/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferTypeAction;
import com.android.tools.idea.editors.gfxtrace.actions.FramebufferWireframeAction;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.WireframeMode;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameBufferController
extends Controller {
    private static final int MAX_SIZE = 65535;
    @NotNull
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final PathStore<DevicePath> myRenderDevice;
    @NotNull
    private final PathStore<AtomPath> myAtomPath;
    @NotNull
    private final JBScrollPane myScrollPane;
    @NotNull
    private final ImagePanel myImagePanel;
    @NotNull
    private final RenderSettings mySettings;
    @NotNull
    private JBLoadingPanel myLoading;
    @NotNull
    private BufferType myBufferType;
    private final AtomicInteger imageLoadCount;
    private ListenableFuture<?> request;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new FrameBufferController((GfxTraceEditor)editor).myPanel;
    }

    public synchronized int newImageRequest(ListenableFuture<?> request) {
        this.request.cancel(true);
        this.request = request;
        return this.imageLoadCount.incrementAndGet();
    }

    public boolean isCurrentImageRequest(int request) {
        return this.imageLoadCount.get() == request;
    }

    private FrameBufferController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "<init>"));
        }
        super(editor);
        this.myPanel = new JPanel(new BorderLayout());
        this.myRenderDevice = new PathStore();
        this.myAtomPath = new PathStore();
        this.myScrollPane = new JBScrollPane();
        this.myImagePanel = new ImagePanel();
        this.mySettings = new RenderSettings();
        this.myBufferType = BufferType.Color;
        this.imageLoadCount = new AtomicInteger();
        this.request = Futures.immediateFuture((Object)0);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.myScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.myScrollPane.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        this.myScrollPane.setViewport((JViewport)this.myImagePanel.getViewport());
        this.myLoading = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.myEditor.getProject());
        this.myLoading.add((Component)this.myScrollPane, (Object)"Center");
        this.mySettings.setMaxHeight(65535);
        this.mySettings.setMaxWidth(65535);
        this.mySettings.setWireframeMode(WireframeMode.noWireframe());
        this.myPanel.add((Component)this.myLoading, "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.getToolbarActions(), false);
        this.myPanel.add((Component)toolbar.getComponent(), "West");
    }

    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Color, "Color", "Display the color framebuffer", AllIcons.Gutter.Colors));
        group.add((AnAction)new FramebufferTypeAction(this, BufferType.Depth, "Depth", "Display the depth framebuffer", AllIcons.Gutter.OverridenMethod));
        group.add((AnAction)new Separator());
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.noWireframe(), "None", "Display the frambuffer without wireframing", AllIcons.Ide.Macro.Recording_1));
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.wireframeOverlay(), "Overlay", "Wireframe the last draw call only", AllIcons.Gutter.Unique));
        group.add((AnAction)new FramebufferWireframeAction(this, WireframeMode.allWireframe(), "All", "Draw the framebuffer with full wireframing", AllIcons.Graph.Grid));
        return group;
    }

    @NotNull
    public BufferType getBufferType() {
        BufferType bufferType = this.myBufferType;
        if (bufferType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "getBufferType"));
        }
        return bufferType;
    }

    public void setBufferType(@NotNull BufferType bufferType) {
        if (bufferType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bufferType", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "setBufferType"));
        }
        if (!this.myBufferType.equals((Object)bufferType)) {
            this.myBufferType = bufferType;
            this.updateBuffer();
        }
    }

    @NotNull
    public WireframeMode getWireframeMode() {
        WireframeMode wireframeMode = this.mySettings.getWireframeMode();
        if (wireframeMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "getWireframeMode"));
        }
        return wireframeMode;
    }

    public void setWireframeMode(@NotNull WireframeMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/editors/gfxtrace/controllers/FrameBufferController", "setWireframeMode"));
        }
        if (!this.mySettings.getWireframeMode().equals(mode)) {
            this.mySettings.setWireframeMode(mode);
            this.updateBuffer();
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateTabs = false;
        if (path instanceof DevicePath) {
            updateTabs |= this.myRenderDevice.update((DevicePath)path);
        }
        if (path instanceof AtomPath) {
            updateTabs |= this.myAtomPath.update((AtomPath)path);
        }
        if (updateTabs && this.myRenderDevice.getPath() != null && this.myAtomPath.getPath() != null) {
            this.updateBuffer();
        }
    }

    public void updateBuffer() {
        ListenableFuture<FetchedImage> imageFuture = this.loadImage();
        final int imageRequest = this.newImageRequest(imageFuture);
        this.myLoading.startLoading();
        Futures.addCallback(imageFuture, (FutureCallback)new FutureCallback<FetchedImage>(){

            public void onSuccess(@Nullable FetchedImage result) {
                FrameBufferController.this.updateBuffer(imageRequest, result);
            }

            public void onFailure(Throwable t) {
                if (!(t instanceof CancellationException)) {
                    LOG.error(t);
                }
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (FrameBufferController.this.isCurrentImageRequest(imageRequest)) {
                            FrameBufferController.this.myLoading.stopLoading();
                        }
                    }
                });
            }
        });
    }

    private ListenableFuture<FetchedImage> loadImage() {
        return Futures.transform(this.getImageInfoPath(), (AsyncFunction)new AsyncFunction<ImageInfoPath, FetchedImage>(){

            public ListenableFuture<FetchedImage> apply(ImageInfoPath imageInfoPath) throws Exception {
                return FetchedImage.load(FrameBufferController.this.myEditor.getClient(), imageInfoPath);
            }
        });
    }

    private ListenableFuture<ImageInfoPath> getImageInfoPath() {
        switch (this.myBufferType) {
            case Color: {
                return this.myEditor.getClient().getFramebufferColor(this.myRenderDevice.getPath(), this.myAtomPath.getPath(), this.mySettings);
            }
            case Depth: {
                return this.myEditor.getClient().getFramebufferDepth(this.myRenderDevice.getPath(), this.myAtomPath.getPath());
            }
        }
        return null;
    }

    private void updateBuffer(final int imageRequest, FetchedImage fetchedImage) {
        final Image image = fetchedImage.icon.getImage();
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                if (FrameBufferController.this.isCurrentImageRequest(imageRequest)) {
                    FrameBufferController.this.myLoading.stopLoading();
                    FrameBufferController.this.myImagePanel.setImage(image);
                }
            }
        });
    }

    private static class ImagePanel
    extends JPanel {
        private static final double ZOOM_FIT = Double.POSITIVE_INFINITY;
        private static final double MAX_ZOOM = 8.0;
        private static final double MIN_ZOOM_WIDTH = 100.0;
        private static final int ZOOM_AMOUNT = 5;
        private static final int SCROLL_AMOUNT = 15;
        private final JBViewport parent = new JBViewport();
        private Image image = null;
        private double zoom = Double.POSITIVE_INFINITY;

        private ImagePanel() {
            this.parent.setView((Component)this);
            MouseAdapter mouseHandler = new MouseAdapter(){
                private int lastX;
                private int lastY;

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    ImagePanel.this.zoom(Math.max(-5, Math.min(5, e.getWheelRotation())), e.getPoint());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    if (this.isPanningButton(e)) {
                        ImagePanel.this.setCursor(new Cursor(13));
                    } else {
                        ImagePanel.this.zoomToFit();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ImagePanel.this.setCursor(null);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int dx = this.lastX - e.getX();
                    int dy = this.lastY - e.getY();
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    if (this.isPanningButton(e)) {
                        ImagePanel.this.scrollBy(dx, dy);
                    }
                }

                private boolean isPanningButton(MouseEvent e) {
                    return (e.getModifiersEx() & 0xC00) != 0;
                }
            };
            this.parent.addMouseListener((MouseListener)mouseHandler);
            this.parent.addMouseWheelListener((MouseWheelListener)mouseHandler);
            this.parent.addMouseMotionListener((MouseMotionListener)mouseHandler);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 38: 
                        case 75: {
                            ImagePanel.this.scrollBy(0, -15);
                            break;
                        }
                        case 40: 
                        case 74: {
                            ImagePanel.this.scrollBy(0, 15);
                            break;
                        }
                        case 37: 
                        case 72: {
                            ImagePanel.this.scrollBy(-15, 0);
                            break;
                        }
                        case 39: 
                        case 76: {
                            ImagePanel.this.scrollBy(15, 0);
                            break;
                        }
                        case 107: 
                        case 521: {
                            ImagePanel.this.zoom(-5, new Point(ImagePanel.this.parent.getWidth() / 2, ImagePanel.this.parent.getHeight() / 2));
                            break;
                        }
                        case 45: 
                        case 109: {
                            ImagePanel.this.zoom(5, new Point(ImagePanel.this.parent.getWidth() / 2, ImagePanel.this.parent.getHeight() / 2));
                            break;
                        }
                        case 61: {
                            if ((e.getModifiersEx() & 0x40) != 0) {
                                ImagePanel.this.zoom(-5, new Point(ImagePanel.this.parent.getWidth() / 2, ImagePanel.this.parent.getHeight() / 2));
                                break;
                            }
                            ImagePanel.this.zoomToFit();
                        }
                    }
                }
            });
            this.setFocusable(true);
        }

        public JBViewport getViewport() {
            return this.parent;
        }

        public void setImage(Image image) {
            this.image = image;
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.zoom == Double.POSITIVE_INFINITY ? new Dimension(this.parent.getWidth(), this.parent.getHeight()) : new Dimension((int)(this.zoom * (double)this.image.getWidth(this)), (int)(this.zoom * (double)this.image.getHeight(this)));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image != null) {
                double scale = this.zoom == Double.POSITIVE_INFINITY ? this.getFitRatio() : this.zoom;
                int w = (int)((double)this.image.getWidth(this) * scale);
                int h = (int)((double)this.image.getHeight(this) * scale);
                g.drawImage(this.image, (this.getWidth() - w) / 2, (this.getHeight() - h) / 2, w, h, this);
            }
        }

        private void scrollBy(int dx, int dy) {
            if (dx == 0 && dy == 0) {
                this.revalidate();
                this.repaint();
            } else {
                this.parent.scrollRectToVisible(new Rectangle(new Point(dx, dy), this.parent.getExtentSize()));
            }
        }

        private void zoom(int amount, Point cursor) {
            Dimension oldSize = this.getPreferredSize();
            oldSize.setSize(Math.max(this.parent.getWidth(), oldSize.width), Math.max(this.parent.getHeight(), oldSize.height));
            if (this.zoom == Double.POSITIVE_INFINITY) {
                this.zoom = this.getFitRatio();
            }
            int delta = Math.min(Math.max(amount, -5), 5);
            this.zoom = Math.min(8.0, Math.max(this.getMinZoom(), this.zoom * (1.0 - 0.05 * (double)delta)));
            this.invalidate();
            Dimension newSize = this.getPreferredSize();
            newSize.setSize(Math.max(this.parent.getWidth(), newSize.width), Math.max(this.parent.getHeight(), newSize.height));
            Point pos = this.parent.getViewPosition();
            pos.translate(cursor.x, cursor.y);
            this.scrollBy(pos.x * newSize.width / oldSize.width - pos.x, pos.y * newSize.height / oldSize.height - pos.y);
        }

        private void zoomToFit() {
            this.zoom = Double.POSITIVE_INFINITY;
            this.revalidate();
            this.repaint();
        }

        private double getFitRatio() {
            return Math.min((double)this.getWidth() / (double)this.image.getWidth(this), (double)this.getHeight() / (double)this.image.getHeight(this));
        }

        private double getMinZoom() {
            return Math.min(this.getFitRatio(), Math.min(100.0 / (double)this.image.getWidth(this), 100.0 / (double)this.image.getHeight(this)));
        }
    }

    public static enum BufferType {
        Color,
        Depth;

    }
}

