/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.CellController;
import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.WireframeMode;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrubberController
extends CellController<Data> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ScrubberController.class);
    @NotNull
    private final PathStore<DevicePath> myRenderDevice;
    @NotNull
    private final PathStore<AtomsPath> myAtomsPath;
    @NotNull
    private final RenderSettings myRenderSettings;
    private boolean mDisableActivation;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new ScrubberController((GfxTraceEditor)editor).myPanel;
    }

    private ScrubberController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "<init>"));
        }
        super(editor);
        this.myRenderDevice = new PathStore();
        this.myAtomsPath = new PathStore();
        this.myRenderSettings = new RenderSettings();
        this.mDisableActivation = false;
        this.myRenderSettings.setMaxWidth(CellRenderer.MAX_WIDTH);
        this.myRenderSettings.setMaxHeight(CellRenderer.MAX_HEIGHT);
        this.myRenderSettings.setWireframeMode(WireframeMode.noWireframe());
    }

    @Override
    public boolean loadCell(final Data cell) {
        DevicePath devicePath = this.myRenderDevice.getPath();
        if (devicePath == null) {
            return false;
        }
        final ServiceClient client = this.myEditor.getClient();
        ListenableFuture<ImageInfoPath> imagePathF = client.getFramebufferColor(devicePath, cell.atomPath, this.myRenderSettings);
        Futures.addCallback(imagePathF, (FutureCallback)new LoadingCallback<ImageInfoPath>(LOG, (LoadingCallback.LoadingDone)cell){

            public void onSuccess(@Nullable ImageInfoPath imagePath) {
                ScrubberController.this.loadCellImage(cell, client, imagePath);
            }
        });
        return true;
    }

    @Override
    void selected(@NotNull Data cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "selected"));
        }
        if (this.mDisableActivation || this.myAtomsPath.getPath() == null) {
            return;
        }
        AtomPath atomPath = this.myAtomsPath.getPath().index(cell.range.getLast());
        this.myEditor.activatePath(atomPath);
    }

    @Nullable
    public List<Data> prepareData(@NotNull AtomsPath path, @NotNull AtomList atoms) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "prepareData"));
        }
        if (atoms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atoms", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController", "prepareData"));
        }
        ArrayList<Data> generatedList = new ArrayList<Data>();
        int frameCount = 0;
        Range range = new Range();
        range.setStart(0L);
        for (int index = 0; index < atoms.getAtoms().length; ++index) {
            Atom atom = atoms.get(index);
            if (!atom.getIsEndOfFrame()) continue;
            range.setEnd(index + 1);
            Data frameData = new Data(path.index(index), range, Integer.toString(frameCount++), this.myRenderer.getDefaultIcon());
            generatedList.add(frameData);
            range = new Range();
            range.setStart(index + 1);
        }
        return generatedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFrame(long atomIndex) {
        if (this.myData == null) {
            return;
        }
        for (int i = 0; i < this.myData.size(); ++i) {
            if (!((Data)this.myData.get((int)i)).range.contains(atomIndex)) continue;
            try {
                this.mDisableActivation = true;
                this.selectItem(i);
                continue;
            }
            finally {
                this.mDisableActivation = false;
            }
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateIcons = false;
        if (path instanceof DevicePath) {
            updateIcons |= this.myRenderDevice.update((DevicePath)path);
        }
        if (path instanceof CapturePath) {
            updateIcons |= this.myAtomsPath.update(((CapturePath)path).atoms());
        }
        if (path instanceof AtomPath) {
            this.selectFrame(((AtomPath)path).getIndex());
        }
        if (updateIcons && this.myAtomsPath.getPath() != null) {
            Futures.addCallback(this.myEditor.getClient().get(this.myAtomsPath.getPath()), (FutureCallback)new LoadingCallback<AtomList>(LOG){

                public void onSuccess(@Nullable AtomList atoms) {
                    final List<Data> cells = ScrubberController.this.prepareData((AtomsPath)ScrubberController.this.myAtomsPath.getPath(), atoms);
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            ScrubberController.this.populateUi(cells);
                        }
                    });
                }
            });
        }
    }

    public static class Data
    extends CellController.Data {
        @NotNull
        public final AtomPath atomPath;
        @NotNull
        public final Range range;

        public Data(AtomPath atomPath, @NotNull Range range, @NotNull String label, @NotNull ImageIcon icon) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController$Data", "<init>"));
            }
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController$Data", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/editors/gfxtrace/controllers/ScrubberController$Data", "<init>"));
            }
            super(label, icon);
            this.atomPath = atomPath;
            this.range = range;
        }
    }
}

