/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Type;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateController
extends TreeController {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StateController.class);
    private final PathStore<StatePath> myStatePath;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new StateController((GfxTraceEditor)editor).myPanel;
    }

    private StateController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "<init>"));
        }
        super(editor, "Select an atom");
        this.myStatePath = new PathStore();
    }

    @Nullable
    private static DefaultMutableTreeNode createNode(@Nullable Object key, @Nullable Type type, @Nullable Object value) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode();
        StateController.fillNode(child, key, value);
        if (child.getChildCount() != 0) {
            child.setUserObject(new Node(key, null));
        } else if (type != null && value != null) {
            child.setUserObject(new Node(key, new Typed(type, value)));
        } else {
            child.setUserObject(new Node(key, value));
        }
        return child;
    }

    private static void fillNode(@NotNull DefaultMutableTreeNode parent, @Nullable Object key, @Nullable Object value) {
        block6: {
            Field field;
            block5: {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/editors/gfxtrace/controllers/StateController", "fillNode"));
                }
                if (!(value instanceof Dynamic)) break block5;
                Dynamic dynamic = (Dynamic)value;
                for (int index = 0; index < dynamic.getFieldCount(); ++index) {
                    Field field2 = dynamic.getFieldInfo(index);
                    if (field2.getDeclared().length() == 0) {
                        StateController.fillNode(parent, field2, dynamic.getFieldValue(index));
                        continue;
                    }
                    parent.add(StateController.createNode(field2, field2.getType(), dynamic.getFieldValue(index)));
                }
                break block6;
            }
            if (!(key instanceof Field) || !((field = (Field)key).getType() instanceof Map)) break block6;
            assert (value instanceof java.util.Map);
            Map map = (Map)field.getType();
            for (Map.Entry entry : ((java.util.Map)value).entrySet()) {
                parent.add(StateController.createNode(new Typed(map.getKeyType(), entry.getKey()), map.getValueType(), entry.getValue()));
            }
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateState = false;
        if (path instanceof AtomPath) {
            updateState |= this.myStatePath.update(((AtomPath)path).stateAfter());
        }
        if (updateState && this.myStatePath.getPath() != null) {
            Futures.addCallback(this.myEditor.getClient().get(this.myStatePath.getPath()), (FutureCallback)new LoadingCallback<Object>(LOG, this.myLoadingPanel){

                public void onSuccess(@Nullable Object state) {
                    final DefaultMutableTreeNode stateNode = StateController.createNode("state", null, state);
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            StateController.this.setRoot(stateNode);
                        }
                    });
                }
            });
        }
    }

    public static class Node {
        @Nullable
        public final Object key;
        @Nullable
        public final Object value;

        public Node(@Nullable Object key, @Nullable Object value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class Typed {
        @NotNull
        public final Type type;
        @NotNull
        public final Object value;

        public Typed(@NotNull Type type, @NotNull Object value) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/editors/gfxtrace/controllers/StateController$Typed", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/gfxtrace/controllers/StateController$Typed", "<init>"));
            }
            this.type = type;
            this.value = value;
        }
    }
}

