/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.CellController;
import com.android.tools.idea.editors.gfxtrace.service.ResourceInfo;
import com.android.tools.idea.editors.gfxtrace.service.Resources;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcesPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ThumbnailPath;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TexturesController
extends CellController<Data> {
    @NotNull
    private static final Logger LOG = Logger.getInstance(TexturesController.class);
    @NotNull
    private final PathStore<ResourcesPath> myResourcesPath;
    @NotNull
    private final PathStore<AtomPath> myAtomPath;
    @NotNull
    private Resources myResources;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new TexturesController((GfxTraceEditor)editor).myPanel;
    }

    private TexturesController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController", "<init>"));
        }
        super(editor);
        this.myResourcesPath = new PathStore();
        this.myAtomPath = new PathStore();
        this.myList.setLayoutOrientation(0);
    }

    @Override
    void selected(@NotNull Data cell) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController", "selected"));
        }
    }

    @Override
    public boolean loadCell(Data cell) {
        ServiceClient client = this.myEditor.getClient();
        ThumbnailPath path = cell.path.thumbnail(this.myRenderer.getCellDimensions());
        this.loadCellImage(cell, client, path);
        return true;
    }

    void update() {
        if (this.myAtomPath.getPath() != null && this.myResources != null) {
            final AtomPath atomPath = this.myAtomPath.getPath();
            final Resources resources = this.myResources;
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<Data> cells = new ArrayList<Data>();
                    for (ResourceInfo info : resources.getTextures()) {
                        cells.add(new Data(info, atomPath.resourceAfter(info.getID()), TexturesController.this.myRenderer.getDefaultIcon()));
                    }
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            TexturesController.this.populateUi(cells);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateIcons = false;
        if (path instanceof CapturePath && this.myResourcesPath.update(((CapturePath)path).resources())) {
            Futures.addCallback(this.myEditor.getClient().get(this.myResourcesPath.getPath()), (FutureCallback)new LoadingCallback<Resources>(LOG){

                public void onSuccess(final @Nullable Resources resources) {
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            TexturesController.this.myResources = resources;
                            TexturesController.this.update();
                        }
                    });
                }
            });
        }
        if (path instanceof AtomPath && this.myAtomPath.update((AtomPath)path)) {
            this.update();
        }
    }

    public static class Data
    extends CellController.Data {
        @NotNull
        public final ResourceInfo info;
        @NotNull
        public final ResourcePath path;

        public Data(@NotNull ResourceInfo info, @NotNull ResourcePath path, @NotNull ImageIcon icon) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$Data", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$Data", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$Data", "<init>"));
            }
            super(info.getName(), icon);
            this.info = info;
            this.path = path;
        }
    }
}

