/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.controllers.CellController;
import com.intellij.icons.AllIcons;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CellLabel
extends JBLabel {
    private static final long CYCLE_LENGTH = 800L;
    private static final int CORNER_RADIUS = 3;
    private static final Icon[] LOADING_ICONS = new Icon[]{AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8, AllIcons.Process.Big.Step_9, AllIcons.Process.Big.Step_10, AllIcons.Process.Big.Step_11, AllIcons.Process.Big.Step_12};
    @Nullable
    private CellController.Data myData;

    @Nullable
    public CellController.Data getUserData() {
        return this.myData;
    }

    public void setUserData(@NotNull CellController.Data data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/gfxtrace/renderers/CellLabel", "setUserData"));
        }
        this.myData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        if (this.ui != null) {
            Graphics pushedContext = g == null ? null : g.create();
            try {
                assert (this.myData != null);
                this.setBackground(UIUtil.getListBackground((boolean)this.myData.isSelected));
                if (pushedContext != null) {
                    ImageIcon previewImage = this.myData.icon;
                    int previewImageWidth = previewImage.getIconWidth();
                    int previewImageHeight = previewImage.getIconHeight();
                    int backgroundOffsetX = (this.getWidth() - previewImageWidth) / 2;
                    int backgroundOffsetY = (this.getHeight() - previewImageHeight) / 2;
                    if (this.myData.isLoading) {
                        this.setOpaque(true);
                        pushedContext.setColor(this.myData.isSelected ? this.getBackground() : UIUtil.getLabelDisabledForeground());
                        pushedContext.fillRoundRect(backgroundOffsetX, backgroundOffsetY, previewImageWidth - 1, previewImageHeight - 1, 3, 3);
                        Icon targetIcon = LOADING_ICONS[(int)((System.currentTimeMillis() - this.myData.loadstartTime) % 800L * 12L / 800L)];
                        targetIcon.paintIcon((Component)((Object)this), g, backgroundOffsetX + (previewImageWidth - targetIcon.getIconWidth()) / 2, backgroundOffsetY + (previewImageHeight - targetIcon.getIconHeight()) / 2);
                    } else {
                        this.setIcon(previewImage);
                        this.setOpaque(false);
                        pushedContext.setColor(this.getBackground());
                        pushedContext.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 3, 3);
                    }
                }
                if (!this.myData.isLoading) {
                    this.ui.update(pushedContext, (JComponent)((Object)this));
                }
                if (pushedContext != null) {
                    this.paintFrameOverlay(g);
                }
            }
            finally {
                if (pushedContext != null) {
                    pushedContext.dispose();
                }
            }
        }
    }

    protected void paintFrameOverlay(Graphics g) {
        int OFFSET = 7;
        boolean PADDING = true;
        assert (this.myData != null);
        FontMetrics metrics = g.getFontMetrics();
        int fontHeight = metrics.getHeight();
        String frameString = this.myData.label;
        int frameStringWidth = metrics.stringWidth(frameString);
        g.setColor(new Color(255, 255, 255, 192));
        g.fillRoundRect(7, 7, frameStringWidth + 2 + 1, fontHeight + 2 + 1, 3, 3);
        g.setColor(this.getForeground());
        g.drawString(frameString, 9, 6 + fontHeight);
    }
}

