/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service;

import com.android.tools.idea.editors.gfxtrace.service.CallFollow;
import com.android.tools.idea.editors.gfxtrace.service.CallGet;
import com.android.tools.idea.editors.gfxtrace.service.CallGetCaptures;
import com.android.tools.idea.editors.gfxtrace.service.CallGetDevices;
import com.android.tools.idea.editors.gfxtrace.service.CallGetFramebufferColor;
import com.android.tools.idea.editors.gfxtrace.service.CallGetFramebufferDepth;
import com.android.tools.idea.editors.gfxtrace.service.CallGetSchema;
import com.android.tools.idea.editors.gfxtrace.service.CallGetTimingInfo;
import com.android.tools.idea.editors.gfxtrace.service.CallImportCapture;
import com.android.tools.idea.editors.gfxtrace.service.CallSet;
import com.android.tools.idea.editors.gfxtrace.service.RenderSettings;
import com.android.tools.idea.editors.gfxtrace.service.ResultFollow;
import com.android.tools.idea.editors.gfxtrace.service.ResultGet;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetCaptures;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetDevices;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetFramebufferColor;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetFramebufferDepth;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetSchema;
import com.android.tools.idea.editors.gfxtrace.service.ResultGetTimingInfo;
import com.android.tools.idea.editors.gfxtrace.service.ResultImportCapture;
import com.android.tools.idea.editors.gfxtrace.service.ResultSet;
import com.android.tools.idea.editors.gfxtrace.service.Schema;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.TimingFlags;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.DevicePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ImageInfoPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.TimingInfoPath;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.rpccore.Broadcaster;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public final class ServiceClientRPC
extends ServiceClient {
    private final Broadcaster myBroadcaster;
    private final ListeningExecutorService myExecutorService;

    public ServiceClientRPC(ListeningExecutorService executorService, InputStream in, OutputStream out, int mtu) {
        this.myExecutorService = executorService;
        this.myBroadcaster = new Broadcaster(in, out, mtu, (ExecutorService)this.myExecutorService);
    }

    @Override
    public ListenableFuture<Path> follow(Path p) {
        return this.myExecutorService.submit((Callable)new FollowCallable(p));
    }

    @Override
    public ListenableFuture<Object> get(Path p) {
        return this.myExecutorService.submit((Callable)new GetCallable(p));
    }

    @Override
    public ListenableFuture<CapturePath[]> getCaptures() {
        return this.myExecutorService.submit((Callable)new GetCapturesCallable());
    }

    @Override
    public ListenableFuture<DevicePath[]> getDevices() {
        return this.myExecutorService.submit((Callable)new GetDevicesCallable());
    }

    @Override
    public ListenableFuture<ImageInfoPath> getFramebufferColor(DevicePath device, AtomPath after, RenderSettings settings) {
        return this.myExecutorService.submit((Callable)new GetFramebufferColorCallable(device, after, settings));
    }

    @Override
    public ListenableFuture<ImageInfoPath> getFramebufferDepth(DevicePath device, AtomPath after) {
        return this.myExecutorService.submit((Callable)new GetFramebufferDepthCallable(device, after));
    }

    @Override
    public ListenableFuture<Schema> getSchema() {
        return this.myExecutorService.submit((Callable)new GetSchemaCallable());
    }

    @Override
    public ListenableFuture<TimingInfoPath> getTimingInfo(DevicePath device, CapturePath capture, TimingFlags flags) {
        return this.myExecutorService.submit((Callable)new GetTimingInfoCallable(device, capture, flags));
    }

    @Override
    public ListenableFuture<CapturePath> importCapture(String name, byte[] Data2) {
        return this.myExecutorService.submit((Callable)new ImportCaptureCallable(name, Data2));
    }

    @Override
    public ListenableFuture<Path> set(Path p, Object v) {
        return this.myExecutorService.submit((Callable)new SetCallable(p, v));
    }

    private class SetCallable
    implements Callable<Path> {
        private final CallSet myCall = new CallSet();

        private SetCallable(Path p, Object v) {
            this.myCall.setP(p);
            this.myCall.setV(v);
        }

        @Override
        public Path call() throws Exception {
            ResultSet result = (ResultSet)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class ImportCaptureCallable
    implements Callable<CapturePath> {
        private final CallImportCapture myCall = new CallImportCapture();

        private ImportCaptureCallable(String name, byte[] Data2) {
            this.myCall.setName(name);
            this.myCall.setData(Data2);
        }

        @Override
        public CapturePath call() throws Exception {
            ResultImportCapture result = (ResultImportCapture)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetTimingInfoCallable
    implements Callable<TimingInfoPath> {
        private final CallGetTimingInfo myCall = new CallGetTimingInfo();

        private GetTimingInfoCallable(DevicePath device, CapturePath capture, TimingFlags flags) {
            this.myCall.setDevice(device);
            this.myCall.setCapture(capture);
            this.myCall.setFlags(flags);
        }

        @Override
        public TimingInfoPath call() throws Exception {
            ResultGetTimingInfo result = (ResultGetTimingInfo)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetSchemaCallable
    implements Callable<Schema> {
        private final CallGetSchema myCall = new CallGetSchema();

        private GetSchemaCallable() {
        }

        @Override
        public Schema call() throws Exception {
            ResultGetSchema result = (ResultGetSchema)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetFramebufferDepthCallable
    implements Callable<ImageInfoPath> {
        private final CallGetFramebufferDepth myCall = new CallGetFramebufferDepth();

        private GetFramebufferDepthCallable(DevicePath device, AtomPath after) {
            this.myCall.setDevice(device);
            this.myCall.setAfter(after);
        }

        @Override
        public ImageInfoPath call() throws Exception {
            ResultGetFramebufferDepth result = (ResultGetFramebufferDepth)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetFramebufferColorCallable
    implements Callable<ImageInfoPath> {
        private final CallGetFramebufferColor myCall = new CallGetFramebufferColor();

        private GetFramebufferColorCallable(DevicePath device, AtomPath after, RenderSettings settings) {
            this.myCall.setDevice(device);
            this.myCall.setAfter(after);
            this.myCall.setSettings(settings);
        }

        @Override
        public ImageInfoPath call() throws Exception {
            ResultGetFramebufferColor result = (ResultGetFramebufferColor)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetDevicesCallable
    implements Callable<DevicePath[]> {
        private final CallGetDevices myCall = new CallGetDevices();

        private GetDevicesCallable() {
        }

        @Override
        public DevicePath[] call() throws Exception {
            ResultGetDevices result = (ResultGetDevices)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetCapturesCallable
    implements Callable<CapturePath[]> {
        private final CallGetCaptures myCall = new CallGetCaptures();

        private GetCapturesCallable() {
        }

        @Override
        public CapturePath[] call() throws Exception {
            ResultGetCaptures result = (ResultGetCaptures)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class GetCallable
    implements Callable<Object> {
        private final CallGet myCall = new CallGet();

        private GetCallable(Path p) {
            this.myCall.setP(p);
        }

        @Override
        public Object call() throws Exception {
            ResultGet result = (ResultGet)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }

    private class FollowCallable
    implements Callable<Path> {
        private final CallFollow myCall = new CallFollow();

        private FollowCallable(Path p) {
            this.myCall.setP(p);
        }

        @Override
        public Path call() throws Exception {
            ResultFollow result = (ResultFollow)ServiceClientRPC.this.myBroadcaster.Send((BinaryObject)this.myCall);
            return result.getValue();
        }
    }
}

