/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.service.atom.Observations;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryID;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.SchemaClass;
import com.android.tools.rpclib.schema.Struct;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class AtomMetadata
implements BinaryObject {
    boolean myIsPrepared = false;
    int myResultIndex = -1;
    int myObservationsIndex = -1;
    @NotNull
    private static final Logger LOG = Logger.getInstance(AtomMetadata.class);
    private BinaryID myAPI;
    private String myDisplayName;
    private boolean myEndOfFrame;
    private boolean myDrawCall;
    private String myDocumentationUrl;
    private static final byte[] IDBytes = new byte[]{19, -11, -108, -61, 18, 72, -29, -11, 72, -17, 32, 58, 46, -66, 72, 29, 74, -98, 45, 3};
    public static final BinaryID ID = new BinaryID(IDBytes);

    public static AtomMetadata find(SchemaClass c) {
        for (BinaryObject o : c.getMetadata()) {
            if (!(o instanceof AtomMetadata)) continue;
            AtomMetadata meta = (AtomMetadata)o;
            meta.prepare(c);
            return meta;
        }
        return null;
    }

    private void prepare(SchemaClass c) {
        if (this.myIsPrepared) {
            return;
        }
        this.myIsPrepared = true;
        for (int index = 0; index < c.getFields().length; ++index) {
            BinaryID id;
            Field field = c.getFields()[index];
            if (field.getDeclared().equals("Result")) {
                this.myResultIndex = index;
            }
            if (!(field.getType() instanceof Struct) || !(id = ((Struct)field.getType()).getID()).equals((Object)Observations.ID)) continue;
            this.myObservationsIndex = index;
        }
    }

    public BinaryID getAPI() {
        return this.myAPI;
    }

    public AtomMetadata setAPI(BinaryID v) {
        this.myAPI = v;
        return this;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public AtomMetadata setDisplayName(String v) {
        this.myDisplayName = v;
        return this;
    }

    public boolean getEndOfFrame() {
        return this.myEndOfFrame;
    }

    public AtomMetadata setEndOfFrame(boolean v) {
        this.myEndOfFrame = v;
        return this;
    }

    public boolean getDrawCall() {
        return this.myDrawCall;
    }

    public AtomMetadata setDrawCall(boolean v) {
        this.myDrawCall = v;
        return this;
    }

    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    public AtomMetadata setDocumentationUrl(String v) {
        this.myDocumentationUrl = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        Namespace.register((BinaryID)ID, (BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public BinaryID id() {
            BinaryID binaryID = ID;
            if (binaryID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "id"));
            }
            return binaryID;
        }

        @NotNull
        public BinaryObject create() {
            AtomMetadata atomMetadata = new AtomMetadata();
            if (atomMetadata == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "create"));
            }
            return atomMetadata;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "encode"));
            }
            AtomMetadata o = (AtomMetadata)obj;
            e.id(o.myAPI);
            e.string(o.myDisplayName);
            e.bool(o.myEndOfFrame);
            e.bool(o.myDrawCall);
            e.string(o.myDocumentationUrl);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomMetadata$Klass", "decode"));
            }
            AtomMetadata o = (AtomMetadata)obj;
            o.myAPI = d.id();
            o.myDisplayName = d.string();
            o.myEndOfFrame = d.bool();
            o.myDrawCall = d.bool();
            o.myDocumentationUrl = d.string();
        }
    }
}

