/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.AccentSuggestionsUtils;
import com.android.tools.idea.editors.theme.MaterialColors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialColorUtils {
    private static final ImmutableMap<Color, Color> PRIMARY_DARK_COLORS_MAP = ImmutableMap.builder().put((Object)MaterialColors.RED_500, (Object)MaterialColors.RED_700).put((Object)MaterialColors.PINK_500, (Object)MaterialColors.PINK_700).put((Object)MaterialColors.PURPLE_500, (Object)MaterialColors.PURPLE_700).put((Object)MaterialColors.DEEP_PURPLE_500, (Object)MaterialColors.DEEP_PURPLE_700).put((Object)MaterialColors.INDIGO_500, (Object)MaterialColors.INDIGO_700).put((Object)MaterialColors.BLUE_500, (Object)MaterialColors.BLUE_700).put((Object)MaterialColors.LIGHT_BLUE_500, (Object)MaterialColors.LIGHT_BLUE_700).put((Object)MaterialColors.CYAN_500, (Object)MaterialColors.CYAN_700).put((Object)MaterialColors.TEAL_500, (Object)MaterialColors.TEAL_700).put((Object)MaterialColors.GREEN_500, (Object)MaterialColors.GREEN_700).put((Object)MaterialColors.LIGHT_GREEN_500, (Object)MaterialColors.LIGHT_GREEN_700).put((Object)MaterialColors.LIME_500, (Object)MaterialColors.LIME_700).put((Object)MaterialColors.YELLOW_500, (Object)MaterialColors.YELLOW_700).put((Object)MaterialColors.AMBER_500, (Object)MaterialColors.AMBER_700).put((Object)MaterialColors.ORANGE_500, (Object)MaterialColors.ORANGE_700).put((Object)MaterialColors.DEEP_ORANGE_500, (Object)MaterialColors.DEEP_ORANGE_700).put((Object)MaterialColors.BROWN_500, (Object)MaterialColors.BROWN_700).put((Object)MaterialColors.GREY_500, (Object)MaterialColors.GREY_700).put((Object)MaterialColors.BLUE_GREY_500, (Object)MaterialColors.BLUE_GREY_700).build();
    private static final ImmutableMap<Color, String> MATERIAL_NAMES_MAP = ImmutableMap.builder().put((Object)MaterialColors.RED_500, (Object)"Material Red 500").put((Object)MaterialColors.PINK_500, (Object)"Material Pink 500").put((Object)MaterialColors.PURPLE_500, (Object)"Material Purple 500").put((Object)MaterialColors.DEEP_PURPLE_500, (Object)"Material Deep Purple 500").put((Object)MaterialColors.INDIGO_500, (Object)"Material Indigo 500").put((Object)MaterialColors.BLUE_500, (Object)"Material Blue 500").put((Object)MaterialColors.LIGHT_BLUE_500, (Object)"Material Light Blue 500").put((Object)MaterialColors.CYAN_500, (Object)"Material Cyan 500").put((Object)MaterialColors.TEAL_500, (Object)"Material Teal 500").put((Object)MaterialColors.GREEN_500, (Object)"Material Green 500").put((Object)MaterialColors.LIGHT_GREEN_500, (Object)"Material Light Green 500").put((Object)MaterialColors.LIME_500, (Object)"Material Lime 500").put((Object)MaterialColors.YELLOW_500, (Object)"Material Yellow 500").put((Object)MaterialColors.AMBER_500, (Object)"Material Amber 500").put((Object)MaterialColors.ORANGE_500, (Object)"Material Orange 500").put((Object)MaterialColors.DEEP_ORANGE_500, (Object)"Material Deep Orange 500").put((Object)MaterialColors.BROWN_500, (Object)"Material Brown 500").put((Object)MaterialColors.GREY_500, (Object)"Material Grey 500").put((Object)MaterialColors.BLUE_GREY_500, (Object)"Material Blue Grey 500").put((Object)MaterialColors.RED_700, (Object)"Material Red 700").put((Object)MaterialColors.PINK_700, (Object)"Material Pink 700").put((Object)MaterialColors.PURPLE_700, (Object)"Material Purple 700").put((Object)MaterialColors.DEEP_PURPLE_700, (Object)"Material Deep Purple 700").put((Object)MaterialColors.INDIGO_700, (Object)"Material Indigo 700").put((Object)MaterialColors.BLUE_700, (Object)"Material Blue 700").put((Object)MaterialColors.LIGHT_BLUE_700, (Object)"Material Light Blue 700").put((Object)MaterialColors.CYAN_700, (Object)"Material Cyan 700").put((Object)MaterialColors.TEAL_700, (Object)"Material Teal 700").put((Object)MaterialColors.GREEN_700, (Object)"Material Green 700").put((Object)MaterialColors.LIGHT_GREEN_700, (Object)"Material Light Green 700").put((Object)MaterialColors.LIME_700, (Object)"Material Lime 700").put((Object)MaterialColors.YELLOW_700, (Object)"Material Yellow 700").put((Object)MaterialColors.AMBER_700, (Object)"Material Amber 700").put((Object)MaterialColors.ORANGE_700, (Object)"Material Orange 700").put((Object)MaterialColors.DEEP_ORANGE_700, (Object)"Material Deep Orange 700").put((Object)MaterialColors.BROWN_700, (Object)"Material Brown 700").put((Object)MaterialColors.GREY_700, (Object)"Material Grey 700").put((Object)MaterialColors.BLUE_GREY_700, (Object)"Material Blue Grey 700").put((Object)MaterialColors.RED_ACCENT_100, (Object)"Red accent 100").put((Object)MaterialColors.RED_ACCENT_200, (Object)"Red accent 200").put((Object)MaterialColors.RED_ACCENT_400, (Object)"Red accent 400").put((Object)MaterialColors.RED_ACCENT_700, (Object)"Red accent 700").put((Object)MaterialColors.PINK_ACCENT_100, (Object)"Pink accent 100").put((Object)MaterialColors.PINK_ACCENT_200, (Object)"Pink accent 200").put((Object)MaterialColors.PINK_ACCENT_400, (Object)"Pink accent 400").put((Object)MaterialColors.PINK_ACCENT_700, (Object)"Pink accent 700").put((Object)MaterialColors.PURPLE_ACCENT_100, (Object)"Purple accent 100").put((Object)MaterialColors.PURPLE_ACCENT_200, (Object)"Purple accent 200").put((Object)MaterialColors.PURPLE_ACCENT_400, (Object)"Purple accent 400").put((Object)MaterialColors.PURPLE_ACCENT_700, (Object)"Purple accent 700").put((Object)MaterialColors.INDIGO_ACCENT_100, (Object)"Indigo accent 100").put((Object)MaterialColors.INDIGO_ACCENT_200, (Object)"Indigo accent 200").put((Object)MaterialColors.INDIGO_ACCENT_400, (Object)"Indigo accent 400").put((Object)MaterialColors.INDIGO_ACCENT_700, (Object)"Indigo accent 700").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_100, (Object)"Deep purple accent 100").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_200, (Object)"Deep purple accent 200").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_400, (Object)"Deep purple accent 400").put((Object)MaterialColors.DEEP_PURPLE_ACCENT_700, (Object)"Deep purple accent 700").put((Object)MaterialColors.BLUE_ACCENT_100, (Object)"Blue accent 100").put((Object)MaterialColors.BLUE_ACCENT_200, (Object)"Blue accent 200").put((Object)MaterialColors.BLUE_ACCENT_400, (Object)"Blue accent 400").put((Object)MaterialColors.BLUE_ACCENT_700, (Object)"Blue accent 700").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_100, (Object)"Light blue accent 100").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_200, (Object)"Light blue accent 200").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_400, (Object)"Light blue accent 400").put((Object)MaterialColors.LIGHT_BLUE_ACCENT_700, (Object)"Light blue accent 700").put((Object)MaterialColors.CYAN_ACCENT_100, (Object)"Cyan accent 100").put((Object)MaterialColors.CYAN_ACCENT_200, (Object)"Cyan accent 200").put((Object)MaterialColors.CYAN_ACCENT_400, (Object)"Cyan accent 400").put((Object)MaterialColors.CYAN_ACCENT_700, (Object)"Cyan accent 700").put((Object)MaterialColors.TEAL_ACCENT_100, (Object)"Teal accent 100").put((Object)MaterialColors.TEAL_ACCENT_200, (Object)"Teal accent 200").put((Object)MaterialColors.TEAL_ACCENT_400, (Object)"Teal accent 400").put((Object)MaterialColors.TEAL_ACCENT_700, (Object)"Teal accent 700").put((Object)MaterialColors.GREEN_ACCENT_100, (Object)"Green accent 100").put((Object)MaterialColors.GREEN_ACCENT_200, (Object)"Green accent 200").put((Object)MaterialColors.GREEN_ACCENT_400, (Object)"Green accent 400").put((Object)MaterialColors.GREEN_ACCENT_700, (Object)"Green accent 700").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_100, (Object)"Light green accent 100").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_200, (Object)"Light green accent 200").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_400, (Object)"Light green accent 400").put((Object)MaterialColors.LIGHT_GREEN_ACCENT_700, (Object)"Light green accent 700").put((Object)MaterialColors.LIME_ACCENT_100, (Object)"Lime accent 100").put((Object)MaterialColors.LIME_ACCENT_200, (Object)"Lime accent 200").put((Object)MaterialColors.LIME_ACCENT_400, (Object)"Lime accent 400").put((Object)MaterialColors.LIME_ACCENT_700, (Object)"Lime accent 700").put((Object)MaterialColors.YELLOW_ACCENT_100, (Object)"Yellow accent 100").put((Object)MaterialColors.YELLOW_ACCENT_200, (Object)"Yellow accent 200").put((Object)MaterialColors.YELLOW_ACCENT_400, (Object)"Yellow accent 400").put((Object)MaterialColors.YELLOW_ACCENT_700, (Object)"Yellow accent 700").put((Object)MaterialColors.AMBER_ACCENT_100, (Object)"Amber accent 100").put((Object)MaterialColors.AMBER_ACCENT_200, (Object)"Amber accent 200").put((Object)MaterialColors.AMBER_ACCENT_400, (Object)"Amber accent 400").put((Object)MaterialColors.AMBER_ACCENT_700, (Object)"Amber accent 700").put((Object)MaterialColors.ORANGE_ACCENT_100, (Object)"Orange accent 100").put((Object)MaterialColors.ORANGE_ACCENT_200, (Object)"Orange accent 200").put((Object)MaterialColors.ORANGE_ACCENT_400, (Object)"Orange accent 400").put((Object)MaterialColors.ORANGE_ACCENT_700, (Object)"Orange accent 700").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_100, (Object)"Deep orange accent 100").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_200, (Object)"Deep orange accent 200").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_400, (Object)"Deep orange accent 400").put((Object)MaterialColors.DEEP_ORANGE_ACCENT_700, (Object)"Deep orange accent 700").build();
    private static final ImmutableList<Color> PRIMARY_COLORS_LIST = ImmutableList.copyOf((Collection)PRIMARY_DARK_COLORS_MAP.keySet());

    @NotNull
    public static List<Color> suggestPrimaryColors() {
        ImmutableList<Color> immutableList = PRIMARY_COLORS_LIST;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/MaterialColorUtils", "suggestPrimaryColors"));
        }
        return immutableList;
    }

    @NotNull
    public static List<Color> suggestAccentColors(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/MaterialColorUtils", "suggestAccentColors"));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (AccentSuggestionsUtils.isMaterialPrimary(primaryColor)) {
            builder.addAll(AccentSuggestionsUtils.getMonochromaticAccents(primaryColor));
            builder.addAll(AccentSuggestionsUtils.getAssociatedAccents(primaryColor));
            builder.addAll(AccentSuggestionsUtils.getComplementaryAccents(primaryColor));
            builder.addAll(AccentSuggestionsUtils.getTriadAccents(primaryColor));
        } else {
            float[] hsv = Color.RGBtoHSB(primaryColor.getRed(), primaryColor.getGreen(), primaryColor.getBlue(), null);
            hsv[2] = Math.max(0.6f, hsv[2]);
            builder.add((Object)Color.getHSBColor(hsv[0], 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(hsv[0], 1.0f, hsv[2]));
            float associatedHue1 = (hsv[0] + 0.125f) % 1.0f;
            builder.add((Object)Color.getHSBColor(associatedHue1, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(associatedHue1, 1.0f, hsv[2]));
            float associatedHue2 = (hsv[0] + 0.875f) % 1.0f;
            builder.add((Object)Color.getHSBColor(associatedHue2, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(associatedHue2, 1.0f, hsv[2]));
            float complementaryHue = (hsv[0] + 0.5f) % 1.0f;
            builder.add((Object)Color.getHSBColor(complementaryHue, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(complementaryHue, 1.0f, hsv[2]));
            float triadHue1 = (hsv[0] + 0.625f) % 1.0f;
            builder.add((Object)Color.getHSBColor(triadHue1, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(triadHue1, 1.0f, hsv[2]));
            float triadHue2 = (hsv[0] + 0.375f) % 1.0f;
            builder.add((Object)Color.getHSBColor(triadHue2, 0.75f, 1.0f));
            builder.add((Object)Color.getHSBColor(triadHue2, 1.0f, hsv[2]));
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/MaterialColorUtils", "suggestAccentColors"));
        }
        return immutableList;
    }

    @NotNull
    public static List<Color> suggestPrimaryDarkColors(@NotNull Color primaryColor) {
        if (primaryColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryColor", "com/android/tools/idea/editors/theme/MaterialColorUtils", "suggestPrimaryDarkColors"));
        }
        Color suggestedColor = (Color)PRIMARY_DARK_COLORS_MAP.get((Object)primaryColor);
        if (suggestedColor == null) {
            suggestedColor = primaryColor.darker();
        }
        ImmutableList immutableList = ImmutableList.of((Object)suggestedColor);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/MaterialColorUtils", "suggestPrimaryDarkColors"));
        }
        return immutableList;
    }

    @Nullable(value="if the color is not material")
    public static String getMaterialName(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/editors/theme/MaterialColorUtils", "getMaterialName"));
        }
        return (String)MATERIAL_NAMES_MAP.get((Object)color);
    }
}

