/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedStyleName"));
        }
        String string = (style.isFramework() ? "@android:style/" : "@style/") + style.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedStyleName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedItemName(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedItemName"));
        }
        String string = (item.isFrameworkAttr() ? "android:" : "") + item.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedItemName"));
        }
        return string;
    }

    @NotNull
    public static String getQualifiedValue(@NotNull ItemResourceValue item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedValue"));
        }
        ResourceUrl url = ResourceUrl.parse((String)item.getRawXmlValue(), (boolean)item.isFramework());
        String string = url == null ? item.getRawXmlValue() : url.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ResolutionUtils", "getQualifiedValue"));
        }
        return string;
    }

    @Nullable
    private static StyleResourceValue getStyleResourceValue(@NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName) {
        boolean isFrameworkStyle;
        String styleName;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceValue"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyleResourceValue"));
        }
        if (qualifiedStyleName.startsWith("@android:style/")) {
            styleName = qualifiedStyleName.substring("@android:style/".length());
            isFrameworkStyle = true;
        } else {
            styleName = qualifiedStyleName;
            if (styleName.startsWith("@style/")) {
                styleName = styleName.substring("@style/".length());
            }
            isFrameworkStyle = false;
        }
        return resolver.getStyle(styleName, isFrameworkStyle);
    }

    @Nullable
    public static ThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull ResourceResolver resolver, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        StyleResourceValue style = ResolutionUtils.getStyleResourceValue(resolver, qualifiedStyleName);
        return style == null ? null : new ThemeEditorStyle(configuration, style, module);
    }

    @Nullable
    public static ThemeEditorStyle getStyle(@NotNull Configuration configuration, @NotNull String qualifiedStyleName, @Nullable Module module) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        if (qualifiedStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedStyleName", "com/android/tools/idea/editors/theme/ResolutionUtils", "getStyle"));
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getStyle(configuration, configuration.getResourceResolver(), qualifiedStyleName, module);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull ItemResourceValue itemResValue) {
        AttributeDefinitions definitions;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        if (itemResValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemResValue", "com/android/tools/idea/editors/theme/ResolutionUtils", "getAttributeDefinition"));
        }
        Module module = configuration.getModule();
        if (itemResValue.isFrameworkAttr()) {
            IAndroidTarget target = configuration.getTarget();
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module.getProject());
        } else {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : String.format("Module %s is not an Android module", module.getName());
            definitions = facet.getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(itemResValue.getName());
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        boolean isAttribute;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ResolutionUtils", "getOriginalApiLevel"));
        }
        if (name == null) {
            return -1;
        }
        if (name.startsWith("android:")) {
            isAttribute = true;
        } else if (name.startsWith("@android:")) {
            isAttribute = false;
        } else {
            return -1;
        }
        ApiLookup apiLookup = IntellijLintClient.getApiLookup(project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        if (isAttribute) {
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        String[] namePieces = name.substring("@android:".length()).split("/");
        if (namePieces.length == 2) {
            return apiLookup.getFieldVersion("android/R$" + namePieces[0], AndroidResourceUtil.getFieldNameByResourceName(namePieces[1]));
        }
        return -1;
    }
}

