/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.swing.ui.SwatchComponent;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.color.ColorSelector;
import org.jetbrains.android.dom.drawable.DrawableSelector;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateListPicker
extends JPanel {
    private static final String LABEL_TEMPLATE = "<html><nobr><b><font color=\"#%1$s\">%2$s</font></b>";
    private static final String API_ERROR_TEXT = "This resource requires at least an API level of %d";
    private static final ResourceType[] DIMENSIONS_ONLY = new ResourceType[]{ResourceType.DIMEN};
    private static final Icon QUESTION_ICON = AllIcons.Actions.Help;
    private static final SwatchComponent.SwatchIcon WARNING_ICON = new SwatchComponent.SwatchIcon(){

        @Override
        public void paint(@Nullable Component c, @NotNull Graphics g, int x, int y, int w, int h) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/editors/theme/StateListPicker$1", "paint"));
            }
            int horizontalMargin = (w + JBUI.scale((int)1) - QUESTION_ICON.getIconWidth()) / 2;
            int verticalMargin = (h + JBUI.scale((int)3) - QUESTION_ICON.getIconHeight()) / 2;
            QUESTION_ICON.paintIcon(c, g, x + horizontalMargin, y + verticalMargin);
        }
    };
    private static final ImmutableList<SwatchComponent.SwatchIcon> WARNING_ICON_LIST = ImmutableList.of((Object)WARNING_ICON);
    private final Module myModule;
    private final Configuration myConfiguration;
    private final ResourceHelper.StateList myStateList;
    private final List<StateComponent> myStateComponents;
    @Nullable
    private final RenderTask myRenderTask;

    public StateListPicker(@NotNull ResourceHelper.StateList stateList, @NotNull Module module, @NotNull Configuration configuration) {
        if (stateList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateList", "com/android/tools/idea/editors/theme/StateListPicker", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/StateListPicker", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/StateListPicker", "<init>"));
        }
        this.myStateList = stateList;
        this.myModule = module;
        this.myConfiguration = configuration;
        this.myStateComponents = Lists.newArrayListWithCapacity((int)stateList.getStates().size());
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(module, configuration);
        this.setLayout(new BoxLayout(this, 1));
        for (ResourceHelper.StateListState state : this.myStateList.getStates()) {
            StateComponent stateComponent = this.createStateComponent(state);
            stateComponent.addValueActionListener(new ValueActionListener(state, stateComponent));
            stateComponent.addAlphaActionListener(new AlphaActionListener(state, stateComponent));
            this.add(stateComponent);
        }
    }

    @NotNull
    private StateComponent createStateComponent(@NotNull ResourceHelper.StateListState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/theme/StateListPicker", "createStateComponent"));
        }
        StateComponent stateComponent = new StateComponent();
        this.myStateComponents.add(stateComponent);
        String stateValue = state.getValue();
        this.updateComponent(stateComponent, stateValue, state.getAlpha());
        Map<String, Boolean> attributes = state.getAttributes();
        ArrayList<String> attributeDescriptions = new ArrayList<String>();
        for (Map.Entry<String, Boolean> attribute : attributes.entrySet()) {
            String description = attribute.getKey().substring("state_".length());
            if (!attribute.getValue().booleanValue()) {
                description = "Not " + description;
            }
            attributeDescriptions.add(StringUtil.capitalize((String)description));
        }
        String stateDescription = attributeDescriptions.size() == 0 ? "Default" : Joiner.on((String)", ").join(attributeDescriptions);
        stateComponent.setNameText(String.format(LABEL_TEMPLATE, ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), stateDescription));
        stateComponent.setComponentPopupMenu((JPopupMenu)this.createAlphaPopupMenu(state, stateComponent));
        StateComponent stateComponent2 = stateComponent;
        if (stateComponent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker", "createStateComponent"));
        }
        return stateComponent2;
    }

    @NotNull
    private JBPopupMenu createAlphaPopupMenu(final @NotNull ResourceHelper.StateListState state, final @NotNull StateComponent stateComponent) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/theme/StateListPicker", "createAlphaPopupMenu"));
        }
        if (stateComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateComponent", "com/android/tools/idea/editors/theme/StateListPicker", "createAlphaPopupMenu"));
        }
        JBPopupMenu popupMenu = new JBPopupMenu();
        final JMenuItem deleteAlpha = new JMenuItem("Delete alpha");
        popupMenu.add(deleteAlpha);
        deleteAlpha.setVisible(state.getAlpha() != null);
        final JMenuItem createAlpha = new JMenuItem("Create alpha");
        popupMenu.add(createAlpha);
        createAlpha.setVisible(state.getAlpha() == null);
        deleteAlpha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stateComponent.getAlphaComponent().setVisible(false);
                state.setAlpha(null);
                StateListPicker.this.updateComponent(stateComponent, state.getValue(), state.getAlpha());
                deleteAlpha.setVisible(false);
                createAlpha.setVisible(true);
            }
        });
        createAlpha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlphaActionListener listener = stateComponent.getAlphaActionListener();
                if (listener == null) {
                    return;
                }
                listener.actionPerformed(new ActionEvent(stateComponent.getAlphaComponent(), 1001, null));
                if (state.getAlpha() != null) {
                    stateComponent.getAlphaComponent().setVisible(true);
                    createAlpha.setVisible(false);
                    deleteAlpha.setVisible(true);
                }
            }
        });
        JBPopupMenu jBPopupMenu = popupMenu;
        if (jBPopupMenu == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker", "createAlphaPopupMenu"));
        }
        return jBPopupMenu;
    }

    public void updateStateList(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/editors/theme/StateListPicker", "updateStateList"));
        }
        Project project = this.myModule.getProject();
        if (!AndroidResourceUtil.ensureFilesWritable(project, files)) {
            return;
        }
        ArrayList psiFiles = Lists.newArrayListWithCapacity((int)files.size());
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        final ArrayList selectors = Lists.newArrayListWithCapacity((int)files.size());
        Class selectorClass = this.myStateList.getType() == ResourceFolderType.COLOR ? ColorSelector.class : DrawableSelector.class;
        for (VirtualFile file : files) {
            AndroidDomElement selector = AndroidUtils.loadDomElement(this.myModule, file, selectorClass);
            if (selector == null) {
                AndroidUtils.reportError(project, file.getName() + " is not a statelist file");
                return;
            }
            selectors.add(selector);
        }
        new WriteCommandAction.Simple(project, "Change State List", psiFiles.toArray(new PsiFile[psiFiles.size()])){

            protected void run() {
                for (AndroidDomElement selector : selectors) {
                    XmlTag tag = selector.getXmlTag();
                    for (XmlTag subtag : tag.getSubTags()) {
                        subtag.delete();
                    }
                    for (ResourceHelper.StateListState state : StateListPicker.this.myStateList.getStates()) {
                        XmlTag child = tag.createChildTag("item", tag.getNamespace(), null, false);
                        child = tag.addSubTag(child, false);
                        Map<String, Boolean> attributes = state.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            child.setAttribute(attributeName, "http://schemas.android.com/apk/res/android", attributes.get(attributeName).toString());
                        }
                        if (state.getAlpha() != null) {
                            child.setAttribute("alpha", "http://schemas.android.com/apk/res/android", state.getAlpha());
                        }
                        if (selector instanceof ColorSelector) {
                            child.setAttribute("color", "http://schemas.android.com/apk/res/android", state.getValue());
                            continue;
                        }
                        if (!(selector instanceof DrawableSelector)) continue;
                        child.setAttribute("drawable", "http://schemas.android.com/apk/res/android", state.getValue());
                    }
                }
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        }.execute();
    }

    @Nullable(value="if there is no error")
    public ValidationInfo getPrivateResourceError() {
        IAndroidTarget target = this.myConfiguration.getTarget();
        assert (target != null);
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myModule);
        assert (androidTargetData != null);
        ValidationInfo error = null;
        String errorText = "%s is a private Android resource";
        for (StateComponent component : this.myStateComponents) {
            String resourceValue = component.getResourceValue();
            if (StateListPicker.isResourcePrivate(resourceValue, androidTargetData)) {
                error = component.getResourceComponent().createSwatchValidationInfo(String.format(errorText, resourceValue));
                break;
            }
            resourceValue = component.getAlphaValue();
            if (!StateListPicker.isResourcePrivate(resourceValue, androidTargetData)) continue;
            error = new ValidationInfo(String.format(errorText, resourceValue), (JComponent)component.getAlphaComponent());
            break;
        }
        return error;
    }

    @Nullable(value="if there is no such component")
    public ValidationInfo getApiError(int minApi) {
        for (StateComponent component : this.myStateComponents) {
            int resourceApi = ResolutionUtils.getOriginalApiLevel(component.getResourceValue(), this.myModule.getProject());
            if (resourceApi > minApi) {
                return component.getResourceComponent().createSwatchValidationInfo(String.format(API_ERROR_TEXT, resourceApi));
            }
            int alphaApi = ResolutionUtils.getOriginalApiLevel(component.getAlphaValue(), this.myModule.getProject());
            if (alphaApi <= minApi) continue;
            return new ValidationInfo(String.format(API_ERROR_TEXT, alphaApi), (JComponent)component.getAlphaComponent());
        }
        return null;
    }

    private static boolean isResourcePrivate(@NotNull String resourceValue, @NotNull AndroidTargetData targetData) {
        if (resourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceValue", "com/android/tools/idea/editors/theme/StateListPicker", "isResourcePrivate"));
        }
        if (targetData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetData", "com/android/tools/idea/editors/theme/StateListPicker", "isResourcePrivate"));
        }
        ResourceUrl url = ResourceUrl.parse((String)resourceValue);
        return url != null && url.framework && !targetData.isResourcePublic(url.type.getName(), url.name);
    }

    private void updateComponent(@NotNull StateComponent component, @NotNull String resourceName, @Nullable String alphaValue) {
        String value;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/theme/StateListPicker", "updateComponent"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/android/tools/idea/editors/theme/StateListPicker", "updateComponent"));
        }
        component.setValueText(resourceName);
        component.setAlphaValue(alphaValue);
        component.setAlphaVisible(!StringUtil.isEmpty((String)alphaValue));
        component.showAlphaError(false);
        ResourceResolver resourceResolver = this.myConfiguration.getResourceResolver();
        assert (resourceResolver != null);
        ResourceValue resValue = resourceResolver.findResValue(resourceName, false);
        String string = value = resValue != null ? resourceResolver.resolveResValue(resValue).getValue() : resourceName;
        if (resValue != null && resValue.getResourceType() != ResourceType.COLOR && this.myRenderTask != null) {
            component.setValueIcons(SwatchComponent.imageListOf(this.myRenderTask.renderDrawableAllStates(resValue)));
        } else {
            Color color = ResourceHelper.parseColor(value);
            assert (color != null);
            ImmutableList colorList = ImmutableList.of((Object)color);
            component.setValueIcons(SwatchComponent.colorListOf((List<Color>)colorList));
            if (!StringUtil.isEmpty((String)alphaValue)) {
                try {
                    float alpha = Float.parseFloat(ResourceHelper.resolveStringValue((RenderResources)resourceResolver, alphaValue));
                    JBFont iconFont = JBUI.Fonts.smallFont().asBold();
                    ImmutableList list = ImmutableList.of((Object)new SwatchComponent.TextIcon(String.format("%.2f", Float.valueOf(alpha)), (Font)iconFont));
                    component.getAlphaComponent().setSwatchIcons((List<? extends SwatchComponent.SwatchIcon>)list);
                }
                catch (NumberFormatException e) {
                    component.showAlphaError(true);
                    component.getAlphaComponent().setSwatchIcons((List<? extends SwatchComponent.SwatchIcon>)WARNING_ICON_LIST);
                }
            }
        }
    }

    private void repaintAllComponents() {
        for (StateComponent component : this.myStateComponents) {
            this.updateComponent(component, component.getResourceValue(), component.getAlphaValue());
            component.repaint();
        }
    }

    private class StateComponent
    extends Box {
        private final ResourceComponent myResourceComponent;
        private final SwatchComponent myAlphaComponent;
        private final JBLabel myAlphaErrorLabel;
        private AlphaActionListener myAlphaActionListener;

        public StateComponent() {
            super(3);
            this.setFont(StateListPicker.this.getFont());
            this.myResourceComponent = new ResourceComponent();
            this.add(this.myResourceComponent);
            this.myResourceComponent.setMaximumSize(new Dimension(this.myResourceComponent.getMaximumSize().width, this.myResourceComponent.getPreferredSize().height));
            this.myResourceComponent.setVariantComboVisible(false);
            this.myAlphaComponent = new SwatchComponent(1);
            this.myAlphaComponent.setBackground((Color)JBColor.WHITE);
            this.myAlphaComponent.setForeground(null);
            this.add(this.myAlphaComponent);
            this.myAlphaComponent.setMaximumSize(new Dimension(this.myAlphaComponent.getMaximumSize().width, this.myAlphaComponent.getPreferredSize().height));
            Box alphaErrorComponent = new Box(2);
            this.myAlphaErrorLabel = new JBLabel("This value does not resolve to a floating-point number.", AllIcons.General.BalloonWarning, 10);
            this.myAlphaErrorLabel.setVisible(false);
            alphaErrorComponent.add((Component)this.myAlphaErrorLabel);
            alphaErrorComponent.add(Box.createHorizontalGlue());
            this.add(alphaErrorComponent);
        }

        @NotNull
        public ResourceComponent getResourceComponent() {
            ResourceComponent resourceComponent = this.myResourceComponent;
            if (resourceComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getResourceComponent"));
            }
            return resourceComponent;
        }

        @NotNull
        public SwatchComponent getAlphaComponent() {
            SwatchComponent swatchComponent = this.myAlphaComponent;
            if (swatchComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getAlphaComponent"));
            }
            return swatchComponent;
        }

        public void showAlphaError(boolean hasError) {
            this.myAlphaErrorLabel.setVisible(hasError);
            this.myAlphaComponent.setWarningBorder(hasError);
        }

        public void setNameText(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "setNameText"));
            }
            this.myResourceComponent.setNameText(name);
        }

        public void setValueText(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "setValueText"));
            }
            this.myResourceComponent.setValueText(value);
        }

        public void setAlphaValue(@Nullable String alphaValue) {
            this.myAlphaComponent.setText(Strings.nullToEmpty((String)alphaValue));
        }

        public void setAlphaVisible(boolean isVisible) {
            this.myAlphaComponent.setVisible(isVisible);
        }

        public void setValueIcons(List<SwatchComponent.SwatchIcon> icons) {
            this.myResourceComponent.setSwatchIcons(icons);
        }

        @NotNull
        public String getResourceValue() {
            String string = this.myResourceComponent.getValueText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getResourceValue"));
            }
            return string;
        }

        @NotNull
        public String getAlphaValue() {
            String string = this.myAlphaComponent.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "getAlphaValue"));
            }
            return string;
        }

        public void addValueActionListener(@NotNull ValueActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "addValueActionListener"));
            }
            this.myResourceComponent.addActionListener(listener);
        }

        public void addAlphaActionListener(@NotNull AlphaActionListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/StateListPicker$StateComponent", "addAlphaActionListener"));
            }
            this.myAlphaComponent.addActionListener(listener);
            this.myAlphaActionListener = listener;
        }

        @Nullable
        public AlphaActionListener getAlphaActionListener() {
            return this.myAlphaActionListener;
        }

        @Override
        public void setComponentPopupMenu(JPopupMenu popup) {
            super.setComponentPopupMenu(popup);
            this.myResourceComponent.setComponentPopupMenu(popup);
            this.myAlphaComponent.setComponentPopupMenu(popup);
        }
    }

    private class AlphaActionListener
    implements ActionListener {
        private final ResourceHelper.StateListState myState;
        private final StateComponent myComponent;

        public AlphaActionListener(ResourceHelper.StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwatchComponent source = this.myComponent.getAlphaComponent();
            String itemValue = source.getText();
            ResourceResolver resourceResolver = StateListPicker.this.myConfiguration.getResourceResolver();
            assert (resourceResolver != null);
            ResourceValue resValue = resourceResolver.findResValue(itemValue, false);
            String resolvedResource = resValue != null ? resourceResolver.resolveResValue(resValue).getName() : itemValue;
            ChooseResourceDialog dialog = new ChooseResourceDialog(StateListPicker.this.myModule, DIMENSIONS_ONLY, resolvedResource, null);
            dialog.show();
            if (dialog.isOK()) {
                this.myState.setAlpha(dialog.getResourceName());
                AndroidFacet facet = AndroidFacet.getInstance(StateListPicker.this.myModule);
                assert (facet != null);
                facet.refreshResources();
                StateListPicker.this.updateComponent(this.myComponent, this.myState.getValue(), this.myState.getAlpha());
                StateListPicker.this.repaintAllComponents();
            }
        }
    }

    class ValueActionListener
    implements ActionListener {
        private final ResourceHelper.StateListState myState;
        private final StateComponent myComponent;

        public ValueActionListener(ResourceHelper.StateListState state, StateComponent stateComponent) {
            this.myState = state;
            this.myComponent = stateComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ResourceComponent resourceComponent = this.myComponent.getResourceComponent();
            String itemValue = resourceComponent.getValueText();
            String resourceName = !"@empty".equals(itemValue) && !"@null".equals(itemValue) && itemValue.startsWith("@") ? itemValue.substring(itemValue.indexOf(47) + 1) : itemValue;
            ResourceResolver resourceResolver = StateListPicker.this.myConfiguration.getResourceResolver();
            assert (resourceResolver != null);
            String resolvedResource = itemValue;
            ResourceValue resValue = resourceResolver.findResValue(itemValue, false);
            if (resValue != null) {
                resolvedResource = resValue.getResourceType() == ResourceType.COLOR ? ResourceHelper.colorToString(ResourceHelper.resolveColor((RenderResources)resourceResolver, resValue, StateListPicker.this.myModule.getProject())) : resourceResolver.resolveResValue(resValue).getName();
            }
            ResourceType[] allowedTypes = StateListPicker.this.myStateList.getType() == ResourceFolderType.COLOR ? GraphicalResourceRendererEditor.COLORS_ONLY : GraphicalResourceRendererEditor.DRAWABLES_ONLY;
            ChooseResourceDialog dialog = new ChooseResourceDialog(StateListPicker.this.myModule, allowedTypes, resolvedResource, null, ChooseResourceDialog.ResourceNameVisibility.FORCE, resourceName);
            dialog.show();
            if (dialog.isOK()) {
                this.myState.setValue(dialog.getResourceName());
                AndroidFacet facet = AndroidFacet.getInstance(StateListPicker.this.myModule);
                if (facet != null) {
                    facet.refreshResources();
                }
                StateListPicker.this.updateComponent(this.myComponent, this.myState.getValue(), this.myState.getAlpha());
                StateListPicker.this.repaintAllComponents();
            }
        }
    }
}

