/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.swing.ui.SwatchComponent;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class ColorRendererEditor
extends GraphicalResourceRendererEditor {
    public ColorRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "<init>"));
        }
        if (previewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previewPanel", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "<init>"));
        }
        super(context, previewPanel, isEditor);
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component, @NotNull EditedStyleItem item) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "updateComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "updateComponent"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "updateComponent"));
        }
        assert (context.getResourceResolver() != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)context.getResourceResolver(), (ResourceValue)item.getSelectedValue(), context.getProject());
        component.setSwatchIcons(SwatchComponent.colorListOf(colors));
        component.setNameText(item.getQualifiedName());
        component.setValueText(item.getValue());
        Set<String> lowContrastColors = ColorUtils.getLowContrastColors(context, item);
        if (!lowContrastColors.isEmpty()) {
            component.setWarningVisible(true);
            StringBuilder contrastErrorMessageBuilder = new StringBuilder("<html>Not enough contrast with ");
            int i = 0;
            for (String color : lowContrastColors) {
                contrastErrorMessageBuilder.append(color);
                if (i < lowContrastColors.size() - 2) {
                    contrastErrorMessageBuilder.append(", ");
                } else if (i == lowContrastColors.size() - 2) {
                    contrastErrorMessageBuilder.append(" and ");
                }
                ++i;
            }
            this.myComponent.setWarning(contrastErrorMessageBuilder.toString());
        } else {
            component.setWarningVisible(false);
        }
    }

    @Override
    @NotNull
    protected ResourceType[] getAllowedResourceTypes() {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(this.myContext.getConfiguration(), this.myItem.getSelectedValue());
        String attributeName = this.myItem.getName().toLowerCase();
        if (attributeName.contains("color") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            if (COLORS_ONLY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "getAllowedResourceTypes"));
            }
            return COLORS_ONLY;
        }
        if (attributeName.contains("drawable") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            if (DRAWABLES_ONLY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "getAllowedResourceTypes"));
            }
            return DRAWABLES_ONLY;
        }
        if (COLORS_AND_DRAWABLES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "getAllowedResourceTypes"));
        }
        return COLORS_AND_DRAWABLES;
    }
}

