/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableRendererEditor
extends GraphicalResourceRendererEditor {
    @Nullable
    private final RenderTask myRenderTask;

    public DrawableRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "<init>"));
        }
        if (previewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previewPanel", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "<init>"));
        }
        super(context, previewPanel, isEditor);
        this.myRenderTask = DrawableRendererEditor.configureRenderTask(context.getCurrentContextModule(), context.getConfiguration());
    }

    @Nullable
    public static RenderTask configureRenderTask(@NotNull Module module, @NotNull Configuration configuration) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "configureRenderTask"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "configureRenderTask"));
        }
        RenderTask result = null;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            RenderService service = RenderService.get(facet);
            result = service.createTask(null, configuration, new RenderLogger("ThemeEditorLogger", module), null);
        }
        return result;
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component, @NotNull EditedStyleItem item) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "updateComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "updateComponent"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "updateComponent"));
        }
        assert (context.getResourceResolver() != null);
        if (this.myRenderTask != null) {
            component.setSwatchIcons(SwatchComponent.imageListOf(this.myRenderTask.renderDrawableAllStates((ResourceValue)item.getSelectedValue())));
        }
        String nameText = String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), ThemeEditorUtils.getDisplayHtml(item));
        component.setNameText(nameText);
        component.setValueText(item.getValue());
    }

    @Override
    @NotNull
    protected ResourceType[] getAllowedResourceTypes() {
        if (GraphicalResourceRendererEditor.DRAWABLES_ONLY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/DrawableRendererEditor", "getAllowedResourceTypes"));
        }
        return GraphicalResourceRendererEditor.DRAWABLES_ONLY;
    }
}

