/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final StyleResourceValue myStyleResourceValue;
    @NotNull
    private final Configuration myConfiguration;
    private final Project myProject;
    @Nullable
    private final Module mySourceModule;

    public ThemeEditorStyle(@NotNull Configuration configuration, @NotNull StyleResourceValue styleResourceValue, @Nullable Module sourceModule) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        if (styleResourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceValue", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        this.myStyleResourceValue = styleResourceValue;
        this.myConfiguration = configuration;
        this.myProject = configuration.getModule().getProject();
        this.mySourceModule = sourceModule;
    }

    public boolean isProjectStyle() {
        if (this.myStyleResourceValue.isFramework()) {
            return false;
        }
        ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(this.myConfiguration.getModule(), true);
        assert (repository != null) : this.myConfiguration.getModule().getName();
        return repository.hasResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
    }

    @NotNull
    private StyleResourceValue getStyleResourceValue() {
        StyleResourceValue styleResourceValue = this.myStyleResourceValue;
        if (styleResourceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceValue"));
        }
        return styleResourceValue;
    }

    @NotNull
    private Collection<com.android.ide.common.res2.ResourceItem> getStyleResourceItems() {
        ImmutableList resultItems;
        assert (!this.isFramework());
        if (this.isProjectStyle()) {
            Module module = this.getModuleForAcquiringResources();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : module.getName() + " module doesn't have AndroidFacet";
            final HashMap resourceItems = Maps.newHashMap();
            ThemeEditorUtils.acceptResourceResolverVisitor(facet, new ThemeEditorUtils.ResourceFolderVisitor(){

                @Override
                public void visitResourceFolder(@NotNull LocalResourceRepository resources, String moduleName, @NotNull String variantName, boolean isSourceSelected) {
                    if (resources == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle$1", "visitResourceFolder"));
                    }
                    if (variantName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle$1", "visitResourceFolder"));
                    }
                    if (!isSourceSelected) {
                        return;
                    }
                    List items = resources.getResourceItem(ResourceType.STYLE, ThemeEditorStyle.this.myStyleResourceValue.getName());
                    if (items == null) {
                        return;
                    }
                    for (com.android.ide.common.res2.ResourceItem item : items) {
                        String key = item.getConfiguration().toShortDisplayString() + "/" + item.getName();
                        resourceItems.put(key, item);
                    }
                }
            });
            resultItems = ImmutableList.copyOf(resourceItems.values());
        } else {
            AppResourceRepository resourceRepository = AppResourceRepository.getAppResources(this.getModuleForAcquiringResources(), true);
            assert (resourceRepository != null);
            ImmutableList items = resourceRepository.getResourceItem(ResourceType.STYLE, this.getName());
            resultItems = items != null ? items : Collections.emptyList();
        }
        ImmutableList immutableList = resultItems;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceItems"));
        }
        return immutableList;
    }

    private Module getModuleForAcquiringResources() {
        return this.mySourceModule != null ? this.mySourceModule : this.myConfiguration.getModule();
    }

    public boolean isReadOnly() {
        return !this.isProjectStyle();
    }

    @NotNull
    public String getQualifiedName() {
        String string = ResolutionUtils.getQualifiedStyleName(this.myStyleResourceValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getStyleResourceValue().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getName"));
        }
        return string;
    }

    private static ImmutableCollection<FolderConfiguration> getFolderConfigurationsFromResourceItems(@NotNull Collection<com.android.ide.common.res2.ResourceItem> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getFolderConfigurationsFromResourceItems"));
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (com.android.ide.common.res2.ResourceItem item : items) {
            assert (item != null);
            listBuilder.add((Object)item.getConfiguration());
        }
        return listBuilder.build();
    }

    @NotNull
    public Collection<FolderConfiguration> getFolderConfigurations() {
        if (this.isFramework()) {
            ImmutableList immutableList = ImmutableList.of((Object)new FolderConfiguration());
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getFolderConfigurations"));
            }
            return immutableList;
        }
        ImmutableCollection<FolderConfiguration> immutableCollection = ThemeEditorStyle.getFolderConfigurationsFromResourceItems(this.getStyleResourceItems());
        if (immutableCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getFolderConfigurations"));
        }
        return immutableCollection;
    }

    @NotNull
    public Multimap<String, ConfiguredElement<ItemResourceValue>> getConfiguredValues() {
        ArrayListMultimap itemResourceValues = ArrayListMultimap.create();
        if (this.isFramework()) {
            assert (this.myConfiguration.getFrameworkResources() != null);
            ResourceItem styleItem = this.myConfiguration.getFrameworkResources().getResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                ResourceValue styleResourceValue = styleItem.getResourceValue(ResourceType.STYLE, file.getConfiguration(), true);
                FolderConfiguration folderConfiguration = file.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (ItemResourceValue value : ((StyleResourceValue)styleResourceValue).getValues()) {
                    itemResourceValues.put((Object)ResolutionUtils.getQualifiedItemName(value), ConfiguredElement.create(folderConfiguration, value));
                }
            }
        } else {
            AppResourceRepository repository = AppResourceRepository.getAppResources(this.getModuleForAcquiringResources(), true);
            assert (repository != null);
            List styleDefinitions = repository.getResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
            assert (styleDefinitions != null);
            for (com.android.ide.common.res2.ResourceItem styleDefinition : styleDefinitions) {
                ResourceValue styleResourceValue = styleDefinition.getResourceValue(this.isFramework());
                FolderConfiguration folderConfiguration = styleDefinition.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (ItemResourceValue value : ((StyleResourceValue)styleResourceValue).getValues()) {
                    itemResourceValues.put((Object)ResolutionUtils.getQualifiedItemName(value), ConfiguredElement.create(folderConfiguration, value));
                }
            }
        }
        ArrayListMultimap arrayListMultimap = itemResourceValues;
        if (arrayListMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getConfiguredValues"));
        }
        return arrayListMultimap;
    }

    public boolean hasItem(@Nullable EditedStyleItem item) {
        return item != null && this.getStyleResourceValue().getItem(item.getName(), item.isFrameworkAttr()) != null;
    }

    public ItemResourceValue getItem(@NotNull String name, boolean isFramework) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getItem"));
        }
        return this.getStyleResourceValue().getItem(name, isFramework);
    }

    public ThemeEditorStyle getParent() {
        return this.getParent(null);
    }

    public Collection<ConfiguredElement<String>> getParentNames() {
        if (this.isFramework()) {
            ThemeEditorStyle parent = this.getParent();
            if (parent != null) {
                return ImmutableList.of(ConfiguredElement.create(this.getConfiguration().getEditedConfig(), parent.getQualifiedName()));
            }
            return Collections.emptyList();
        }
        ConfigurationManager manager = this.myConfiguration.getConfigurationManager();
        ResourceResolverCache resolverCache = new ResourceResolverCache(manager);
        Collection<com.android.ide.common.res2.ResourceItem> allStyleDefinitions = this.getStyleResourceItems();
        ImmutableCollection<FolderConfiguration> allConfigurations = ThemeEditorStyle.getFolderConfigurationsFromResourceItems(allStyleDefinitions);
        FolderConfiguration fullBaseConfiguration = this.myConfiguration.getFullConfig();
        ImmutableList.Builder parents = ImmutableList.builder();
        for (final com.android.ide.common.res2.ResourceItem item : allStyleDefinitions) {
            Collection notSelectedConfigurations = Collections2.filter(allConfigurations, (Predicate)new Predicate<FolderConfiguration>(){

                public boolean apply(FolderConfiguration input) {
                    return !input.equals((Object)item.getConfiguration());
                }
            });
            FolderConfiguration folderConfiguration = QualifierUtils.restrictConfiguration(item.getConfiguration(), notSelectedConfigurations);
            if (folderConfiguration == null) {
                LOG.warn(String.format("For item '%1$s': Folder configuration '%2$s' can never be selected. There are no qualifiers combination that would allow selecting it.", item.getName(), item.getConfiguration()));
                continue;
            }
            FolderConfiguration fullFolderConfiguration = FolderConfiguration.copyOf((FolderConfiguration)fullBaseConfiguration);
            fullFolderConfiguration.add(folderConfiguration);
            ResourceResolver resolver = resolverCache.getResourceResolver(this.myConfiguration.getTarget(), this.getQualifiedName(), fullFolderConfiguration);
            StyleResourceValue parent = resolver.getParent(this.myStyleResourceValue);
            if (parent != null) {
                parents.add(ConfiguredElement.create(item.getConfiguration(), ResolutionUtils.getQualifiedStyleName(parent)));
                continue;
            }
            LOG.warn(String.format("Parent of %s is null", this.myStyleResourceValue.getName()));
        }
        return parents.build();
    }

    @Nullable(value="if this is a root style")
    public ThemeEditorStyle getParent(@Nullable ThemeResolver themeResolver) {
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue parent = resolver.getParent(this.getStyleResourceValue());
        if (parent == null) {
            return null;
        }
        if (themeResolver == null) {
            return ResolutionUtils.getStyle(this.myConfiguration, ResolutionUtils.getQualifiedStyleName(parent), null);
        }
        return themeResolver.getTheme(ResolutionUtils.getQualifiedStyleName(parent));
    }

    @Nullable(value="if the attribute does not exist in this theme")
    private XmlTag getValueTag(@NotNull XmlTag sourceTag, final @NotNull String attribute) {
        if (sourceTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTag", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (!this.isProjectStyle()) {
            return null;
        }
        final Ref resultXmlTag = new Ref();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        sourceTag.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlTag)) {
                    return;
                }
                XmlTag tag = (XmlTag)element;
                if ("item".equals(tag.getName()) && attribute.equals(tag.getAttributeValue("name"))) {
                    resultXmlTag.set((Object)tag);
                }
            }
        });
        return (XmlTag)resultXmlTag.get();
    }

    @NotNull
    private static Iterable<com.android.ide.common.res2.ResourceItem> filterStylesByApiLevel(final int minProjectApi, final int minAcceptableApi, @NotNull Iterable<com.android.ide.common.res2.ResourceItem> styleResourceItems) {
        if (styleResourceItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceItems", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "filterStylesByApiLevel"));
        }
        Iterable iterable = Iterables.filter(styleResourceItems, (Predicate)new Predicate<com.android.ide.common.res2.ResourceItem>(){

            public boolean apply(@Nullable com.android.ide.common.res2.ResourceItem input) {
                assert (input != null);
                FolderConfiguration itemConfiguration = input.getConfiguration();
                if (itemConfiguration.isDefault() && minProjectApi < minAcceptableApi) {
                    return false;
                }
                VersionQualifier versionQualifier = itemConfiguration.getVersionQualifier();
                return !(versionQualifier == null ? minProjectApi < minAcceptableApi : versionQualifier.getVersion() < minAcceptableApi);
            }
        });
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "filterStylesByApiLevel"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<com.android.ide.common.res2.ResourceItem> filterStylesByFolder(@NotNull Collection<FolderConfiguration> selectedFolders, @NotNull Iterable<com.android.ide.common.res2.ResourceItem> styleResourceItems) {
        if (selectedFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFolders", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "filterStylesByFolder"));
        }
        if (styleResourceItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceItems", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "filterStylesByFolder"));
        }
        final HashSet foldersSet = Sets.newHashSet(selectedFolders);
        Iterable iterable = Iterables.filter(styleResourceItems, (Predicate)new Predicate<com.android.ide.common.res2.ResourceItem>(){

            public boolean apply(@Nullable com.android.ide.common.res2.ResourceItem input) {
                assert (input != null);
                return foldersSet.contains(input.getConfiguration());
            }
        });
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "filterStylesByFolder"));
        }
        return iterable;
    }

    @NotNull
    private static Iterable<XmlTag> getXmlTagsFromStyles(final @NotNull Project project, @NotNull Iterable<com.android.ide.common.res2.ResourceItem> styleResourceItems) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getXmlTagsFromStyles"));
        }
        if (styleResourceItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceItems", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getXmlTagsFromStyles"));
        }
        FluentIterable fluentIterable = FluentIterable.from(styleResourceItems).transform((Function)new Function<com.android.ide.common.res2.ResourceItem, XmlTag>(){

            public XmlTag apply(@Nullable com.android.ide.common.res2.ResourceItem input) {
                assert (input != null);
                return LocalResourceRepository.getItemTag(project, input);
            }
        }).filter(Predicates.notNull());
        if (fluentIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getXmlTagsFromStyles"));
        }
        return fluentIterable;
    }

    @NotNull
    private static PsiFile[] getPsiFilesFromXmlTags(@NotNull Iterable<XmlTag> stylesXmlTags) {
        if (stylesXmlTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesXmlTags", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getPsiFilesFromXmlTags"));
        }
        PsiFile[] psiFileArray = (PsiFile[])FluentIterable.from(stylesXmlTags).transform((Function)new Function<XmlTag, PsiFile>(){

            public PsiFile apply(@Nullable XmlTag input) {
                assert (input != null);
                return input.getContainingFile();
            }
        }).filter(Predicates.notNull()).toArray(PsiFile.class);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getPsiFilesFromXmlTags"));
        }
        return psiFileArray;
    }

    public void setValue(@NotNull String attribute, @NotNull String value) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        this.setValue(this.getFolderConfigurations(), attribute, value);
    }

    public void setValue(@NotNull FolderConfiguration currentFolder, @NotNull String attribute, @NotNull String value) {
        if (currentFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFolder", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        this.setValue((Collection<FolderConfiguration>)ImmutableList.of((Object)currentFolder), attribute, value);
    }

    public void setValue(@NotNull Collection<FolderConfiguration> selectedFolders, final @NotNull String attribute, final @NotNull String value) {
        if (selectedFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFolders", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        if (selectedFolders.isEmpty()) {
            return;
        }
        int attributeDefinitionApi = Math.max(ResolutionUtils.getOriginalApiLevel(attribute, this.myProject), ResolutionUtils.getOriginalApiLevel(value, this.myProject));
        int minProjectApi = ThemeEditorUtils.getMinApiLevel(this.myConfiguration.getModule());
        final int minAcceptableApi = attributeDefinitionApi != -1 ? attributeDefinitionApi : 1;
        final Collection<com.android.ide.common.res2.ResourceItem> styleResourceItems = this.getStyleResourceItems();
        final FolderConfiguration sourceConfiguration = ThemeEditorStyle.findAcceptableSourceFolderConfiguration(this.myConfiguration.getModule(), minAcceptableApi, ThemeEditorStyle.getFolderConfigurationsFromResourceItems(styleResourceItems));
        final com.android.ide.common.res2.ResourceItem sourceStyle = (com.android.ide.common.res2.ResourceItem)Iterables.find(styleResourceItems, (Predicate)new Predicate<com.android.ide.common.res2.ResourceItem>(){

            public boolean apply(@Nullable com.android.ide.common.res2.ResourceItem input) {
                assert (input != null);
                return input.getConfiguration().equals((Object)sourceConfiguration);
            }
        }, null);
        Iterable<com.android.ide.common.res2.ResourceItem> filteredStyles = ThemeEditorStyle.filterStylesByFolder(selectedFolders, styleResourceItems);
        filteredStyles = ThemeEditorStyle.filterStylesByApiLevel(minProjectApi, minAcceptableApi, filteredStyles);
        final Iterable<XmlTag> stylesXmlTags = ThemeEditorStyle.getXmlTagsFromStyles(this.myProject, filteredStyles);
        PsiFile[] toBeEdited = ThemeEditorStyle.getPsiFilesFromXmlTags(stylesXmlTags);
        new WriteCommandAction.Simple(this.myProject, "Setting value of " + attribute, toBeEdited){

            protected void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myProject);
                boolean copyStyle = true;
                for (XmlTag sourceXml : stylesXmlTags) {
                    XmlTag tag = ThemeEditorStyle.this.getValueTag(sourceXml, attribute);
                    if (tag != null) {
                        tag.getValue().setEscapedText(value);
                        copyStyle = false;
                        continue;
                    }
                    XmlTag child = sourceXml.createChildTag("item", sourceXml.getNamespace(), value, false);
                    child.setAttribute("name", attribute);
                    sourceXml.addSubTag(child, false);
                }
                if (copyStyle && sourceStyle != null) {
                    final VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
                    boolean acceptableApiExists = Iterables.any((Iterable)styleResourceItems, (Predicate)new Predicate<com.android.ide.common.res2.ResourceItem>(){

                        public boolean apply(com.android.ide.common.res2.ResourceItem input) {
                            return input.getQualifiers().contains(qualifier.getFolderSegment());
                        }
                    });
                    if (!acceptableApiExists) {
                        XmlTag sourceXmlTag = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, sourceStyle);
                        assert (sourceXmlTag != null);
                        ThemeEditorUtils.copyTheme(minAcceptableApi, sourceXmlTag);
                        AndroidFacet facet = AndroidFacet.getInstance(ThemeEditorStyle.this.getModuleForAcquiringResources());
                        if (facet != null) {
                            facet.refreshResources();
                        }
                    }
                    Collection newResources = ThemeEditorStyle.this.getStyleResourceItems();
                    for (com.android.ide.common.res2.ResourceItem resourceItem : newResources) {
                        if (!resourceItem.getQualifiers().contains(qualifier.getFolderSegment())) continue;
                        XmlTag sourceXml = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, resourceItem);
                        assert (sourceXml != null);
                        XmlTag child = ThemeEditorStyle.this.getValueTag(sourceXml, attribute);
                        if (child == null) {
                            child = sourceXml.createChildTag("item", sourceXml.getNamespace(), value, false);
                        }
                        child.setAttribute("name", attribute);
                        sourceXml.addSubTag(child, false);
                        break;
                    }
                }
            }
        }.execute();
    }

    public void setParent(@NotNull String newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        this.setParent(this.getFolderConfigurations(), newParent);
    }

    public void setParent(@NotNull FolderConfiguration currentFolder, @NotNull String newParent) {
        if (currentFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFolder", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        this.setParent((Collection<FolderConfiguration>)ImmutableList.of((Object)currentFolder), newParent);
    }

    public void setParent(@NotNull Collection<FolderConfiguration> selectedFolders, final @NotNull String newParent) {
        if (selectedFolders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFolders", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        int minProjectApi = ThemeEditorUtils.getMinApiLevel(this.myConfiguration.getModule());
        final int minAcceptableApi = ResolutionUtils.getOriginalApiLevel(newParent, this.myProject);
        final FolderConfiguration sourceConfiguration = ThemeEditorStyle.findAcceptableSourceFolderConfiguration(this.myConfiguration.getModule(), minAcceptableApi, this.getFolderConfigurations());
        Collection<com.android.ide.common.res2.ResourceItem> styleResourceItems = this.getStyleResourceItems();
        final com.android.ide.common.res2.ResourceItem sourceStyle = (com.android.ide.common.res2.ResourceItem)Iterables.find(styleResourceItems, (Predicate)new Predicate<com.android.ide.common.res2.ResourceItem>(){

            public boolean apply(@Nullable com.android.ide.common.res2.ResourceItem input) {
                assert (input != null);
                return input.getConfiguration().equals((Object)sourceConfiguration);
            }
        }, null);
        Iterable<com.android.ide.common.res2.ResourceItem> filteredStyles = ThemeEditorStyle.filterStylesByFolder(selectedFolders, styleResourceItems);
        filteredStyles = ThemeEditorStyle.filterStylesByApiLevel(minProjectApi, minAcceptableApi, filteredStyles);
        final Iterable<XmlTag> stylesXmlTags = ThemeEditorStyle.getXmlTagsFromStyles(this.myProject, filteredStyles);
        PsiFile[] toBeEdited = ThemeEditorStyle.getPsiFilesFromXmlTags(stylesXmlTags);
        new WriteCommandAction.Simple(this.myProject, "Updating parent to " + newParent, toBeEdited){

            protected void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myProject);
                for (XmlTag sourceXml : stylesXmlTags) {
                    sourceXml.setAttribute("parent", newParent);
                }
                if (sourceStyle != null) {
                    XmlTag sourceXmlTag = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, sourceStyle);
                    assert (sourceXmlTag != null);
                    ThemeEditorUtils.copyTheme(minAcceptableApi, sourceXmlTag);
                    AndroidFacet facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myConfiguration.getModule());
                    if (facet != null) {
                        facet.refreshResources();
                    }
                    Collection newResources = ThemeEditorStyle.this.getStyleResourceItems();
                    VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
                    for (com.android.ide.common.res2.ResourceItem resourceItem : newResources) {
                        if (!resourceItem.getQualifiers().contains(qualifier.getFolderSegment())) continue;
                        XmlTag sourceXml = LocalResourceRepository.getItemTag(ThemeEditorStyle.this.myProject, resourceItem);
                        assert (sourceXml != null);
                        sourceXml.setAttribute("parent", newParent);
                        break;
                    }
                }
            }
        }.execute();
    }

    public String toString() {
        if (!this.isReadOnly()) {
            return "[" + this.getName() + "]";
        }
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ThemeEditorStyle)) {
            return false;
        }
        return this.getQualifiedName().equals(((ThemeEditorStyle)obj).getQualifiedName());
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getConfiguration"));
        }
        return configuration;
    }

    public void removeAttribute(@NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "removeAttribute"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        com.intellij.util.containers.HashSet toBeEdited = new com.intellij.util.containers.HashSet();
        com.intellij.util.containers.HashSet toBeRemoved = new com.intellij.util.containers.HashSet();
        for (com.android.ide.common.res2.ResourceItem resourceItem : this.getStyleResourceItems()) {
            XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myProject, resourceItem);
            assert (sourceXml != null);
            XmlTag tag = this.getValueTag(sourceXml, attribute);
            if (tag == null) continue;
            toBeEdited.add(tag.getContainingFile());
            toBeRemoved.add(tag);
        }
        new WriteCommandAction.Simple(this.myProject, "Removing " + attribute, toBeEdited.toArray(new PsiFile[toBeEdited.size()]), (Collection)toBeRemoved){
            final /* synthetic */ Collection val$toBeRemoved;
            {
                this.val$toBeRemoved = collection;
                super(x0, x1, x2);
            }

            protected void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myProject);
                for (XmlTag tag : this.val$toBeRemoved) {
                    tag.delete();
                }
            }
        }.execute();
    }

    @Nullable
    public PsiElement getNamePsiElement() {
        Collection<com.android.ide.common.res2.ResourceItem> resources = this.getStyleResourceItems();
        if (resources.isEmpty()) {
            return null;
        }
        XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myProject, resources.iterator().next());
        assert (sourceXml != null);
        XmlAttribute nameAttribute = sourceXml.getAttribute("name");
        if (nameAttribute == null) {
            return null;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return null;
        }
        return new ValueResourceElementWrapper(attributeValue);
    }

    @Nullable
    public Module getSourceModule() {
        return this.mySourceModule;
    }

    @Nullable(value="when there is no need to copy the folder since it already exists")
    private static FolderConfiguration findAcceptableSourceFolderConfiguration(@NotNull Module module, int minAcceptableApi, @NotNull Collection<FolderConfiguration> folders) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findAcceptableSourceFolderConfiguration"));
        }
        if (folders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folders", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findAcceptableSourceFolderConfiguration"));
        }
        int minProjectApiLevel = ThemeEditorUtils.getMinApiLevel(module);
        int highestNonAllowedApi = 0;
        FolderConfiguration toBeCopied = null;
        if (minAcceptableApi < minProjectApiLevel) {
            return null;
        }
        for (FolderConfiguration folderConfiguration : folders) {
            int version = minProjectApiLevel;
            VersionQualifier versionQualifier = folderConfiguration.getVersionQualifier();
            if (versionQualifier != null && versionQualifier.isValid()) {
                version = versionQualifier.getVersion();
            }
            if (version < minAcceptableApi) {
                if (version <= highestNonAllowedApi) continue;
                highestNonAllowedApi = version;
                toBeCopied = folderConfiguration;
                continue;
            }
            if (version != minAcceptableApi) continue;
            return null;
        }
        return toBeCopied;
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myConfiguration.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myConfiguration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }

    public boolean isFramework() {
        return this.myStyleResourceValue.isFramework();
    }

    @NotNull
    public FolderConfiguration findBestConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findBestConfiguration"));
        }
        Collection<FolderConfiguration> folderConfigurations = this.getFolderConfigurations();
        Configurable bestMatch = configuration.findMatchingConfigurable((List)ImmutableList.copyOf((Collection)Collections2.transform(folderConfigurations, (Function)new Function<FolderConfiguration, Configurable>(){

            @Nullable
            public Configurable apply(final FolderConfiguration input) {
                assert (input != null);
                return new Configurable(){

                    public FolderConfiguration getConfiguration() {
                        return input;
                    }
                };
            }
        })));
        FolderConfiguration folderConfiguration = bestMatch == null ? folderConfigurations.iterator().next() : bestMatch.getConfiguration();
        if (folderConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findBestConfiguration"));
        }
        return folderConfiguration;
    }
}

