/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.swing.ui.ClickableLabel;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceComponent
extends JPanel {
    private static final short MAX_SWATCH_ICONS = 3;
    public static final String NAME_LABEL = "Name Label";
    private final SwatchComponent mySwatchComponent = new SwatchComponent(3);
    private final ClickableLabel myNameLabel = new ClickableLabel();
    protected final ClickableLabel myWarningLabel = new ClickableLabel();
    private final VariantsComboBox myVariantCombo = new VariantsComboBox();

    public ResourceComponent() {
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        this.myNameLabel.setFont(this.myNameLabel.getFont().deriveFont(1));
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        topRowPanel.add(Box.createHorizontalGlue());
        topRowPanel.add(this.myVariantCombo);
        this.add((Component)topRowPanel, "Center");
        this.mySwatchComponent.setBackground((Color)JBColor.WHITE);
        this.mySwatchComponent.setForeground(null);
        this.add((Component)this.mySwatchComponent, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = Math.max(this.getFontMetrics(this.getFont()).getHeight(), this.myVariantCombo.getPreferredSize().height);
            int secondRowHeight = this.mySwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    public void setSwatchIcons(@NotNull List<SwatchComponent.SwatchIcon> icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setSwatchIcons"));
        }
        this.mySwatchComponent.setSwatchIcons(icons);
    }

    public void setNameText(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setNameText"));
        }
        this.myNameLabel.setText(name);
    }

    public void setWarning(@NotNull String warning) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setWarning"));
        }
        this.myWarningLabel.setToolTipText(warning);
    }

    public void setWarningVisible(boolean isVisible) {
        this.myWarningLabel.setVisible(isVisible);
    }

    public void setVariantsModel(@Nullable ComboBoxModel comboBoxModel) {
        this.myVariantCombo.setModel(comboBoxModel != null ? comboBoxModel : new DefaultComboBoxModel());
    }

    public void addVariantItemListener(@NotNull ItemListener itemListener) {
        if (itemListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemListener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addVariantItemListener"));
        }
        this.myVariantCombo.addItemListener(itemListener);
    }

    public void addVariantPopupClosingListener(@NotNull VariantsComboBox.PopupClosingListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "addVariantPopupClosingListener"));
        }
        this.myVariantCombo.addPopupClosingListener(listener);
    }

    public void setValueText(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "setValueText"));
        }
        this.mySwatchComponent.setText(value);
    }

    @NotNull
    public String getValueText() {
        String string = this.mySwatchComponent.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "getValueText"));
        }
        return string;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.mySwatchComponent != null) {
            this.mySwatchComponent.setFont(font);
        }
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        this.myNameLabel.setComponentPopupMenu(popup);
        this.mySwatchComponent.setComponentPopupMenu(popup);
    }

    public void addActionListener(final ActionListener listener) {
        this.myNameLabel.addActionListener(listener);
        this.myWarningLabel.addActionListener(listener);
        this.mySwatchComponent.addActionListener(listener);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!ResourceComponent.this.contains(e.getPoint()) || !SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                listener.actionPerformed(new ActionEvent(e.getSource(), 1001, null));
            }
        });
    }

    public void setVariantComboVisible(boolean isVisible) {
        this.myVariantCombo.setVisible(isVisible);
    }

    @NotNull
    public ValidationInfo createSwatchValidationInfo(@NotNull String errorText) {
        if (errorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "createSwatchValidationInfo"));
        }
        ValidationInfo validationInfo = new ValidationInfo(errorText, (JComponent)this.mySwatchComponent);
        if (validationInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ui/ResourceComponent", "createSwatchValidationInfo"));
        }
        return validationInfo;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }
}

