/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.dsl.parser.DependenciesElement;
import com.android.tools.idea.gradle.dsl.parser.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.parser.ProjectDependencyElement;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GradleRenameModuleHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "isAvailableOnDataContext"));
        }
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return AndroidStudioInitializer.isAndroidStudio() && module != null && LocalFileSystem.getInstance().findFileByIoFile(new File(module.getModuleFilePath()).getParentFile()) != null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "isRenaming"));
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "invoke"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "invoke"));
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "invoke"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "invoke"));
        }
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        assert (module != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator(project, module));
    }

    @NotNull
    public String getActionTitle() {
        String string = RefactoringBundle.message((String)"rename.module.title");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/GradleRenameModuleHandler", "getActionTitle"));
        }
        return string;
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final Module myModule;

        public MyInputValidator(@NotNull Project project, @NotNull Module module) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/GradleRenameModuleHandler$MyInputValidator", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/GradleRenameModuleHandler$MyInputValidator", "<init>"));
            }
            this.myProject = project;
            this.myModule = module;
        }

        public boolean checkInput(@Nullable String inputString) {
            return inputString != null && inputString.length() > 0 && !inputString.equals(this.myModule.getName()) && !inputString.contains(":");
        }

        public boolean canClose(final @NotNull String inputString) {
            if (inputString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/android/tools/idea/gradle/GradleRenameModuleHandler$MyInputValidator", "canClose"));
            }
            final GradleSettingsFile settingsFile = GradleSettingsFile.get(this.myProject);
            if (settingsFile == null) {
                Messages.showErrorDialog((Project)this.myProject, (String)"settings.gradle file not found", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            final VirtualFile moduleRoot = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myModule.getModuleFilePath()).getParentFile());
            assert (moduleRoot != null);
            if (this.myModule.getProject().getBaseDir().equals(moduleRoot)) {
                Messages.showErrorDialog((Project)this.myProject, (String)"Can't rename root module", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            WriteCommandAction<Boolean> action = new WriteCommandAction<Boolean>(this.myProject, IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{this.myModule.getName()}), new PsiFile[]{settingsFile.getPsiFile()}){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/GradleRenameModuleHandler$MyInputValidator$1", "run"));
                    }
                    result.setResult((Object)true);
                    String oldModuleGradlePath = GradleSettingsFile.getModuleGradlePath(MyInputValidator.this.myModule);
                    if (oldModuleGradlePath == null) {
                        return;
                    }
                    GrLiteral moduleReference = settingsFile.findModuleReference(MyInputValidator.this.myModule);
                    if (moduleReference == null) {
                        Messages.showErrorDialog((Project)MyInputValidator.this.myProject, (String)("Can't find module '" + MyInputValidator.this.myModule.getName() + "' in settings.gradle"), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        return;
                    }
                    try {
                        moduleRoot.rename((Object)this, inputString);
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((Project)MyInputValidator.this.myProject, (String)("Rename folder failed: " + e.getMessage()), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        result.setResult((Object)false);
                        return;
                    }
                    moduleReference.updateText(moduleReference.getText().replace(MyInputValidator.this.myModule.getName(), inputString));
                    for (Module module : ModuleManager.getInstance((Project)MyInputValidator.this.myProject).getModules()) {
                        GradleBuildModel buildModel = GradleBuildModel.get(module);
                        if (buildModel == null) continue;
                        for (DependenciesElement elements : buildModel.getDependenciesBlocks()) {
                            for (ProjectDependencyElement element : elements.getProjectDependencies()) {
                                if (!oldModuleGradlePath.equals(element.getPath())) continue;
                                element.setName(inputString);
                            }
                        }
                    }
                    UndoManager.getInstance((Project)MyInputValidator.this.myProject).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                        public void undo() throws UnexpectedUndoException {
                            GradleProjectImporter.getInstance().requestProjectSync(MyInputValidator.this.myProject, null);
                        }

                        public void redo() throws UnexpectedUndoException {
                            GradleProjectImporter.getInstance().requestProjectSync(MyInputValidator.this.myProject, null);
                        }
                    });
                    result.setResult((Object)true);
                }
            };
            if (((Boolean)action.execute().getResultObject()).booleanValue()) {
                GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
                return true;
            }
            return false;
        }
    }
}

