/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelModuleCustomizer
implements ModuleCustomizer<JavaProject> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable JavaProject javaProject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "customizeModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "customizeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "customizeModule"));
        }
        if (javaProject == null) {
            return;
        }
        LanguageLevel languageLevel = javaProject.getJavaLanguageLevel();
        if (JavaLanguageLevelModuleCustomizer.isNotSupported(languageLevel)) {
            List dependents = modelsProvider.getAllDependentModules(module);
            languageLevel = JavaLanguageLevelModuleCustomizer.getMinimumLanguageLevelForAndroidModules(dependents.toArray(new Module[dependents.size()]));
        }
        if (JavaLanguageLevelModuleCustomizer.isNotSupported(languageLevel)) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            languageLevel = JavaLanguageLevelModuleCustomizer.getMinimumLanguageLevelForAndroidModules(modules);
        }
        if (JavaLanguageLevelModuleCustomizer.isNotSupported(languageLevel)) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        ((LanguageLevelModuleExtensionImpl)modelsProvider.getModifiableRootModel(module).getModuleExtension(LanguageLevelModuleExtensionImpl.class)).setLanguageLevel(languageLevel);
    }

    private static boolean isNotSupported(@Nullable LanguageLevel languageLevel) {
        return languageLevel == null || languageLevel.compareTo((Enum)LanguageLevel.JDK_1_8) >= 0;
    }

    @Nullable
    private static LanguageLevel getMinimumLanguageLevelForAndroidModules(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "getMinimumLanguageLevelForAndroidModules"));
        }
        if (modules.length == 0) {
            return null;
        }
        LanguageLevel result = null;
        ArrayList languageLevels = Lists.newArrayList();
        for (Module dependency : modules) {
            LanguageLevel dependencyLanguageLevel = JavaLanguageLevelModuleCustomizer.getLanguageLevelForAndroidModule(dependency);
            if (dependencyLanguageLevel == null) continue;
            languageLevels.add(dependencyLanguageLevel);
        }
        for (LanguageLevel dependencyLanguageLevel : languageLevels) {
            if (result != null && result.compareTo((Enum)dependencyLanguageLevel) <= 0) continue;
            result = dependencyLanguageLevel;
        }
        return result;
    }

    @Nullable
    private static LanguageLevel getLanguageLevelForAndroidModule(@NotNull Module module) {
        AndroidGradleModel androidModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/JavaLanguageLevelModuleCustomizer", "getLanguageLevelForAndroidModule"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getJavaLanguageLevel();
        }
        return null;
    }
}

