/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.dsl.parser.ExternalDependencyElement;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.ProjectDependencyElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;

public class DependenciesElement
implements GradleDslElement {
    @NotNull
    private final GrClosableBlock myPsiElement;
    @NotNull
    private final List<ExternalDependencyElement> myExternalDependencies;
    @NotNull
    private final List<ProjectDependencyElement> myProjectDependencies;

    DependenciesElement(@NotNull GrClosableBlock psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "<init>"));
        }
        this.myExternalDependencies = Lists.newArrayList();
        this.myProjectDependencies = Lists.newArrayList();
        this.myPsiElement = psiElement;
    }

    void addAll(@NotNull List<DependencyElement> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "addAll"));
        }
        for (DependencyElement dependency : dependencies) {
            this.add(dependency);
        }
    }

    private void add(@NotNull DependencyElement dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "add"));
        }
        if (dependency instanceof ExternalDependencyElement) {
            this.myExternalDependencies.add((ExternalDependencyElement)dependency);
        } else if (dependency instanceof ProjectDependencyElement) {
            this.myProjectDependencies.add((ProjectDependencyElement)dependency);
        }
    }

    @NotNull
    public ImmutableList<ExternalDependencyElement> getExternalDependencies() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myExternalDependencies);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "getExternalDependencies"));
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ProjectDependencyElement> getProjectDependencies() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myProjectDependencies);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "getProjectDependencies"));
        }
        return immutableList;
    }

    public void addExternalDependency(@NotNull String configurationName, @NotNull String compactNotation) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "addExternalDependency"));
        }
        if (compactNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/dsl/parser/DependenciesElement", "addExternalDependency"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Project project = this.myPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrStatement statement = factory.createStatementFromText((CharSequence)(configurationName + " '" + compactNotation + "'"));
        this.myPsiElement.addStatementBefore(statement, null);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statement);
    }
}

