/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ExternalDependencyElement
implements DependencyElement {
    @NotNull
    private final String myConfigurationName;
    @NotNull
    private final Notation myNotation;

    @Nullable
    static ExternalDependencyElement withCompactNotation(@NotNull String configurationName, @NotNull GrLiteral literal) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "withCompactNotation"));
        }
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "withCompactNotation"));
        }
        CompactNotation notation = CompactNotation.parse(literal);
        if (notation != null) {
            return new ExternalDependencyElement(configurationName, notation);
        }
        return null;
    }

    @Nullable
    static ExternalDependencyElement withMapNotation(@NotNull String configurationName, @NotNull List<GrNamedArgument> namedArguments) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "withMapNotation"));
        }
        if (namedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArguments", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "withMapNotation"));
        }
        MapNotation notation = MapNotation.parse(namedArguments);
        if (notation != null) {
            return new ExternalDependencyElement(configurationName, notation);
        }
        return null;
    }

    private ExternalDependencyElement(@NotNull String configurationName, @NotNull Notation notation) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "<init>"));
        }
        if (notation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notation", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "<init>"));
        }
        this.myConfigurationName = configurationName;
        this.myNotation = notation;
    }

    @NotNull
    public String getConfigurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "getConfigurationName"));
        }
        return string;
    }

    @Nullable
    public String getGroup() {
        return this.myNotation.getSpec().group;
    }

    @NotNull
    public String getName() {
        String string = this.myNotation.getSpec().name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "getName"));
        }
        return string;
    }

    @Nullable
    public String getVersion() {
        return this.myNotation.getSpec().version;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement", "setVersion"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myNotation.setVersion(version);
    }

    @Nullable
    public String getClassifier() {
        return this.myNotation.getSpec().classifier;
    }

    @Nullable
    public String getExtension() {
        return this.myNotation.getSpec().extension;
    }

    public String toString() {
        return "ExternalDependencyElement{configurationName='" + this.myConfigurationName + '\'' + ", spec='" + this.myNotation.getSpec() + '\'' + '}';
    }

    static class DependencySpec {
        @NotNull
        String name;
        @Nullable
        String group;
        @Nullable
        String version;
        @Nullable
        String classifier;
        @Nullable
        String extension;

        DependencySpec(@NotNull String name, @Nullable String group, @Nullable String version, @Nullable String classifier, @Nullable String extension) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$DependencySpec", "<init>"));
            }
            this.name = name;
            this.group = Strings.emptyToNull((String)group);
            this.version = Strings.emptyToNull((String)version);
            this.classifier = Strings.emptyToNull((String)classifier);
            this.extension = Strings.emptyToNull((String)extension);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencySpec that = (DependencySpec)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.classifier, (Object)that.classifier) && Objects.equal((Object)this.extension, (Object)that.extension);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.group, this.version, this.classifier, this.extension});
        }

        public String toString() {
            ArrayList segments = Lists.newArrayList((Object[])new String[]{this.group, this.name, this.version, this.classifier});
            String s = Joiner.on((char)':').skipNulls().join((Iterable)segments);
            if (this.extension != null) {
                s = s + "@" + this.extension;
            }
            return s;
        }
    }

    static class MapNotation
    implements Notation {
        @NonNls
        private static final String VERSION_PROPERTY = "version";
        @NotNull
        private final Map<String, GrLiteral> myArgumentsByName;
        @NotNull
        private final DependencySpec mySpec;

        @Nullable
        static MapNotation parse(@NotNull List<GrNamedArgument> namedArguments) {
            if (namedArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArguments", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$MapNotation", "parse"));
            }
            HashMap argumentsByName = Maps.newHashMap();
            HashMap argumentValuesByName = Maps.newHashMap();
            for (GrNamedArgument argument : namedArguments) {
                GrLiteral literal = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)argument, GrLiteral.class);
                if (literal == null) continue;
                String name = argument.getLabelName();
                argumentsByName.put(name, literal);
                argumentValuesByName.put(name, PsiElements.getUnquotedText(literal));
            }
            DependencySpec spec = MapNotation.parse(argumentValuesByName);
            if (spec != null) {
                return new MapNotation(argumentsByName, spec);
            }
            return null;
        }

        @Nullable
        static DependencySpec parse(@NotNull Map<String, String> namedArguments) {
            if (namedArguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArguments", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$MapNotation", "parse"));
            }
            String name = namedArguments.get("name");
            if (StringUtil.isNotEmpty((String)name)) {
                return new DependencySpec(name, namedArguments.get("group"), namedArguments.get(VERSION_PROPERTY), namedArguments.get("classifier"), namedArguments.get("ext"));
            }
            return null;
        }

        private MapNotation(@NotNull Map<String, GrLiteral> argumentsByName, @NotNull DependencySpec spec) {
            if (argumentsByName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsByName", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$MapNotation", "<init>"));
            }
            if (spec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$MapNotation", "<init>"));
            }
            this.myArgumentsByName = argumentsByName;
            this.mySpec = spec;
        }

        @Override
        @NotNull
        public DependencySpec getSpec() {
            DependencySpec dependencySpec = this.mySpec;
            if (dependencySpec == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$MapNotation", "getSpec"));
            }
            return dependencySpec;
        }

        @Override
        public void setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VERSION_PROPERTY, "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$MapNotation", "setVersion"));
            }
            GrLiteral literal = this.myArgumentsByName.get(VERSION_PROPERTY);
            if (literal != null) {
                Project project = literal.getProject();
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                this.mySpec.version = version;
                GrLiteral newCoordinatePsiLiteral = factory.createLiteralFromValue((Object)version);
                literal.replace((PsiElement)newCoordinatePsiLiteral);
            }
        }
    }

    static class CompactNotation
    implements Notation {
        @NotNull
        private final GrLiteral myLiteral;
        @NotNull
        private final DependencySpec mySpec;

        @Nullable
        static CompactNotation parse(@NotNull GrLiteral literal) {
            DependencySpec spec;
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$CompactNotation", "parse"));
            }
            String text = PsiElements.getUnquotedText(literal);
            if (text != null && (spec = CompactNotation.parse(text)) != null) {
                return new CompactNotation(literal, spec);
            }
            return null;
        }

        @Nullable
        static DependencySpec parse(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$CompactNotation", "parse"));
            }
            List segments = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)text);
            int segmentCount = segments.size();
            if (segmentCount > 0) {
                segments = Lists.newArrayList((Iterable)segments);
                String lastSegment = (String)segments.remove(segmentCount - 1);
                String extension = null;
                int indexOfAt = lastSegment.indexOf(64);
                if (indexOfAt != -1) {
                    extension = lastSegment.substring(indexOfAt + 1, lastSegment.length());
                    lastSegment = lastSegment.substring(0, indexOfAt);
                }
                segments.add(lastSegment);
                segmentCount = segments.size();
                String group = null;
                String name = null;
                String version = null;
                String classifier = null;
                if (segmentCount == 1) {
                    name = (String)segments.get(0);
                } else if (segmentCount == 2) {
                    if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                        name = (String)segments.get(0);
                        version = lastSegment;
                    } else {
                        group = (String)segments.get(0);
                        name = (String)segments.get(1);
                    }
                } else if (segmentCount == 3 || segmentCount == 4) {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                    version = (String)segments.get(2);
                    if (segmentCount == 4) {
                        classifier = (String)segments.get(3);
                    }
                }
                if (StringUtil.isNotEmpty((String)name)) {
                    return new DependencySpec(name, group, version, classifier, extension);
                }
            }
            return null;
        }

        private CompactNotation(@NotNull GrLiteral literal, @NotNull DependencySpec spec) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$CompactNotation", "<init>"));
            }
            if (spec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$CompactNotation", "<init>"));
            }
            this.myLiteral = literal;
            this.mySpec = spec;
        }

        @Override
        @NotNull
        public DependencySpec getSpec() {
            DependencySpec dependencySpec = this.mySpec;
            if (dependencySpec == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$CompactNotation", "getSpec"));
            }
            return dependencySpec;
        }

        @Override
        public void setVersion(@NotNull String version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/dsl/parser/ExternalDependencyElement$CompactNotation", "setVersion"));
            }
            Project project = this.myLiteral.getProject();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
            this.mySpec.version = version;
            GrLiteral newCoordinatePsiLiteral = factory.createLiteralFromValue((Object)this.mySpec.toString());
            this.myLiteral.replace((PsiElement)newCoordinatePsiLiteral);
        }
    }

    private static interface Notation {
        @NotNull
        public DependencySpec getSpec();

        public void setVersion(@NotNull String var1);
    }
}

