/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependenciesElement;
import com.android.tools.idea.gradle.dsl.parser.DependenciesElementParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslElementParser;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GradleBuildModel {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<DependenciesElement> myDependenciesBlocks;
    private final GradleDslElementParser[] myParsers;
    @Nullable
    private PsiFile myPsiFile;

    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "get"));
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? GradleBuildModel.parseBuildFile(file, module.getProject()) : null;
    }

    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "parseBuildFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "parseBuildFile"));
        }
        GradleBuildModel buildFile = new GradleBuildModel(file, project);
        buildFile.reparse();
        GradleBuildModel gradleBuildModel = buildFile;
        if (gradleBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "parseBuildFile"));
        }
        return gradleBuildModel;
    }

    private GradleBuildModel(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "<init>"));
        }
        this.myDependenciesBlocks = Lists.newArrayList();
        this.myParsers = new GradleDslElementParser[]{new DependenciesElementParser()};
        this.myFile = file;
        this.myProject = project;
    }

    public void reparse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.reset();
        this.myPsiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (this.myPsiFile != null) {
            this.myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

                public void visitMethodCallExpression(GrMethodCallExpression e) {
                    for (GradleDslElementParser parser : GradleBuildModel.this.myParsers) {
                        if (parser.parse((GroovyPsiElement)e, GradleBuildModel.this)) break;
                    }
                }

                public void visitAssignmentExpression(GrAssignmentExpression e) {
                    for (GradleDslElementParser parser : GradleBuildModel.this.myParsers) {
                        if (parser.parse((GroovyPsiElement)e, GradleBuildModel.this)) break;
                    }
                }
            }));
        }
    }

    private void reset() {
        this.myDependenciesBlocks.clear();
    }

    void add(@NotNull DependenciesElement dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "add"));
        }
        this.myDependenciesBlocks.add(dependencies);
    }

    @NotNull
    public ImmutableList<DependenciesElement> getDependenciesBlocks() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myDependenciesBlocks);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "getDependenciesBlocks"));
        }
        return immutableList;
    }

    public void addExternalDependency(@NotNull String configurationName, @NotNull String compactNotation) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "addExternalDependency"));
        }
        if (compactNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compactNotation", "com/android/tools/idea/gradle/dsl/parser/GradleBuildModel", "addExternalDependency"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (this.myPsiFile != null);
        if (this.myDependenciesBlocks.isEmpty()) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)this.myProject);
            String text = "dependencies {\n" + configurationName + " '" + compactNotation + "'\n}";
            GrExpression expression = factory.createExpressionFromText((CharSequence)text);
            this.myPsiFile.add((PsiElement)expression);
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)expression);
        } else {
            DependenciesElement dependenciesBlock = this.myDependenciesBlocks.get(0);
            dependenciesBlock.addExternalDependency(configurationName, compactNotation);
        }
    }

    public boolean hasPsiFile() {
        return this.myPsiFile != null;
    }
}

