/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.DependencyElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;

public class ProjectDependencyElement
implements DependencyElement {
    @NotNull
    String myConfigurationName;
    @NotNull
    GrLiteralContainer myGradlePathElement;
    @Nullable
    GrLiteralContainer myTargetConfigurationElement;

    @Nullable
    public static ProjectDependencyElement withCompactNotation(@NotNull String configurationName, @NotNull GrLiteralContainer projectNamePsiElement) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "withCompactNotation"));
        }
        if (projectNamePsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectNamePsiElement", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "withCompactNotation"));
        }
        if (projectNamePsiElement.getValue() == null) {
            return null;
        }
        return new ProjectDependencyElement(configurationName, projectNamePsiElement, null);
    }

    @Nullable
    public static ProjectDependencyElement withMapNotation(@NotNull String configurationName, @NotNull GrArgumentList argumentList) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "withMapNotation"));
        }
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "withMapNotation"));
        }
        GrLiteral projectNamePsiElement = ProjectDependencyElement.findNamedArgumentLiteralValue(argumentList, "path");
        if (projectNamePsiElement == null || projectNamePsiElement.getValue() == null) {
            return null;
        }
        return new ProjectDependencyElement(configurationName, (GrLiteralContainer)projectNamePsiElement, (GrLiteralContainer)ProjectDependencyElement.findNamedArgumentLiteralValue(argumentList, "configuration"));
    }

    @Nullable
    private static GrLiteral findNamedArgumentLiteralValue(@NotNull GrArgumentList argumentList, @NotNull String label) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "findNamedArgumentLiteralValue"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "findNamedArgumentLiteralValue"));
        }
        GrNamedArgument namedArgument = argumentList.findNamedArgument(label);
        if (namedArgument == null) {
            return null;
        }
        if (namedArgument.getExpression() instanceof GrLiteral) {
            return (GrLiteral)namedArgument.getExpression();
        }
        return null;
    }

    private ProjectDependencyElement(@NotNull String configurationName, @NotNull GrLiteralContainer projectNamePsiElement, @Nullable GrLiteralContainer targetConfigurationElement) {
        if (configurationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationName", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "<init>"));
        }
        if (projectNamePsiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectNamePsiElement", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "<init>"));
        }
        this.myConfigurationName = configurationName;
        this.myGradlePathElement = projectNamePsiElement;
        this.myTargetConfigurationElement = targetConfigurationElement;
    }

    @NotNull
    public String getConfigurationName() {
        String string = this.myConfigurationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "getConfigurationName"));
        }
        return string;
    }

    @NotNull
    public String getPath() {
        Object literalValue = this.myGradlePathElement.getValue();
        assert (literalValue != null);
        String string = literalValue.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.getPath());
        int segmentCount = pathSegments.size();
        String string = segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "getName"));
        }
        return string;
    }

    @Nullable
    public String getTargetConfiguration() {
        if (this.myTargetConfigurationElement == null) {
            return null;
        }
        Object value = this.myTargetConfigurationElement.getValue();
        return value != null ? value.toString() : null;
    }

    public void setName(@NotNull String newName) {
        String newPath;
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/android/tools/idea/gradle/dsl/parser/ProjectDependencyElement", "setName"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List segments = Splitter.on((String)":").splitToList((CharSequence)this.getPath());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + newName.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, newName);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        String currentText = this.myGradlePathElement.getText();
        char quote = '\'';
        if (StringUtil.isQuotedString((String)currentText)) {
            quote = currentText.charAt(0);
        }
        newPath = quote + newPath + quote;
        this.myGradlePathElement = this.myGradlePathElement.updateText(newPath);
    }
}

