/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.android.DependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.ExternalDependenciesUsageTracker;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.LibraryAttachments;
import com.android.tools.idea.gradle.project.ProjectDiagnostics;
import com.android.tools.idea.gradle.project.ProjectJdkChecks;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.android.tools.idea.templates.TemplateManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostProjectSetupTasksExecutor {
    private static boolean ourNewSdkVersionToolsInfoAlreadyShown;
    private static boolean ourCheckedExpiration;
    private static final boolean DEFAULT_GENERATE_SOURCES_AFTER_SYNC = true;
    private static final boolean DEFAULT_USING_CACHED_PROJECT_DATA = false;
    private static final long DEFAULT_LAST_SYNC_TIMESTAMP = -1L;
    @NotNull
    private final Project myProject;
    private volatile boolean myGenerateSourcesAfterSync;
    private volatile boolean myUsingCachedProjectData;
    private volatile long myLastSyncTimestamp;

    @NotNull
    public static PostProjectSetupTasksExecutor getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getInstance"));
        }
        PostProjectSetupTasksExecutor postProjectSetupTasksExecutor = (PostProjectSetupTasksExecutor)ServiceManager.getService((Project)project, PostProjectSetupTasksExecutor.class);
        if (postProjectSetupTasksExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getInstance"));
        }
        return postProjectSetupTasksExecutor;
    }

    public PostProjectSetupTasksExecutor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "<init>"));
        }
        this.myGenerateSourcesAfterSync = true;
        this.myUsingCachedProjectData = false;
        this.myLastSyncTimestamp = -1L;
        this.myProject = project;
    }

    public void onProjectSyncCompletion() {
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        messages.reportDependencySetupErrors();
        messages.reportComponentIncompatibilities();
        ProjectDiagnostics.findAndReportStructureIssues(this.myProject);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            if (!ProjectJdkChecks.hasCorrectJdkVersion(module)) break;
        }
        if (Projects.hasErrors(this.myProject)) {
            this.addSdkLinkIfNecessary();
            PostProjectSetupTasksExecutor.checkSdkToolsVersion(this.myProject);
            this.updateGradleSyncState();
            return;
        }
        new ExternalDependenciesUsageTracker(this.myProject).trackExternalDependenciesInAndroidApps();
        Projects.executeProjectChanges(this.myProject, new Runnable(){

            @Override
            public void run() {
                PostProjectSetupTasksExecutor.this.attachSourcesToLibraries();
                PostProjectSetupTasksExecutor.this.adjustModuleStructures();
                PostProjectSetupTasksExecutor.this.ensureValidSdks();
            }
        });
        Projects.enforceExternalBuild(this.myProject);
        AndroidGradleProjectComponent.getInstance(this.myProject).checkForSupportedModules();
        this.findAndShowVariantConflicts();
        PostProjectSetupTasksExecutor.checkSdkToolsVersion(this.myProject);
        this.addSdkLinkIfNecessary();
        ProjectResourceRepository.moduleRootsChanged(this.myProject);
        this.updateGradleSyncState();
        if (this.myGenerateSourcesAfterSync) {
            GradleProjectBuilder.getInstance(this.myProject).generateSourcesOnly();
        }
        this.myGenerateSourcesAfterSync = true;
        TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
    }

    private void updateGradleSyncState() {
        if (!this.myUsingCachedProjectData) {
            GradleSyncState.getInstance(this.myProject).syncEnded();
            GradleProjectSyncData.save(this.myProject);
        } else {
            long lastSyncTimestamp = this.myLastSyncTimestamp;
            if (lastSyncTimestamp == -1L) {
                lastSyncTimestamp = System.currentTimeMillis();
            }
            GradleSyncState.getInstance(this.myProject).syncSkipped(lastSyncTimestamp);
        }
        this.myUsingCachedProjectData = false;
        this.myLastSyncTimestamp = -1L;
    }

    private void adjustModuleStructures() {
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(this.myProject);
        HashSet androidSdks = Sets.newHashSet();
        try {
            for (Module module : modelsProvider.getModules()) {
                ModifiableRootModel model = modelsProvider.getModifiableRootModel(module);
                PostProjectSetupTasksExecutor.adjustInterModuleDependencies(module, (IdeModifiableModelsProvider)modelsProvider);
                Sdk sdk = model.getSdk();
                if (sdk != null) {
                    if (!AndroidSdkUtils.isAndroidSdk(sdk)) continue;
                    androidSdks.add(sdk);
                    continue;
                }
                Sdk jdk = IdeSdks.getJdk();
                model.setSdk(jdk);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        for (Sdk sdk : androidSdks) {
            PostProjectSetupTasksExecutor.refreshLibrariesIn(sdk);
        }
        Projects.removeAllModuleCompiledArtifacts(this.myProject);
    }

    private static void adjustInterModuleDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "adjustInterModuleDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "adjustInterModuleDependencies"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject == null) {
            return;
        }
        ModifiableRootModel modifiableModel = modelsProvider.getModifiableRootModel(module);
        for (Module dependency : modifiableModel.getModuleDependencies()) {
            LibraryDependency backup;
            AndroidProject dependencyAndroidProject = GradleUtil.getAndroidProject(dependency);
            if (dependencyAndroidProject != null || (backup = Projects.getModuleCompiledArtifact(dependency)) == null) continue;
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, backup, androidProject);
        }
    }

    private static void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "refreshLibrariesIn"));
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        sdkModificator = sdk.getSdkModificator();
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    private void attachSourcesToLibraries() {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)this.myProject);
        LibraryAttachments storedLibraryAttachments = LibraryAttachments.getStoredLibraryAttachments(this.myProject);
        for (Library library : libraryTable.getLibraries()) {
            HashSet sourcePaths = Sets.newHashSet();
            for (VirtualFile file : library.getFiles(OrderRootType.SOURCES)) {
                sourcePaths.add(file.getUrl());
            }
            Library.ModifiableModel libraryModel = library.getModifiableModel();
            for (VirtualFile classFile : library.getFiles(OrderRootType.CLASSES)) {
                String url;
                VirtualFile sourceJar = PostProjectSetupTasksExecutor.findSourceJarForJar(classFile);
                if (sourceJar == null || sourcePaths.contains(url = AbstractDependenciesModuleCustomizer.pathToUrl(sourceJar.getPath()))) continue;
                libraryModel.addRoot(url, OrderRootType.SOURCES);
                sourcePaths.add(url);
            }
            if (storedLibraryAttachments != null) {
                storedLibraryAttachments.addUrlsTo(libraryModel);
            }
            libraryModel.commit();
        }
        if (storedLibraryAttachments != null) {
            storedLibraryAttachments.removeFromProject();
        }
    }

    @Nullable
    private static VirtualFile findSourceJarForJar(@NotNull VirtualFile jarFile) {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "findSourceJarForJar"));
        }
        File jarFilePath = PostProjectSetupTasksExecutor.getJarFromJarUrl(jarFile.getUrl());
        return jarFilePath != null ? GradleUtil.findSourceJarForLibrary(jarFilePath) : null;
    }

    @Nullable
    private static File getJarFromJarUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "getJarFromJarUrl"));
        }
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return new File(FileUtil.toSystemDependentName((String)path));
    }

    private void findAndShowVariantConflicts() {
        boolean atLeastOneSolved;
        List<Conflict> selectionConflicts;
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        if (!(selectionConflicts = conflicts.getSelectionConflicts()).isEmpty() && (atLeastOneSolved = ConflictResolution.solveSelectionConflicts(selectionConflicts))) {
            conflicts = ConflictSet.findConflicts(this.myProject);
        }
        conflicts.showSelectionConflicts();
    }

    private void addSdkLinkIfNecessary() {
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        int sdkErrorCount = messages.getMessageCount("Failed to set up SDK");
        if (sdkErrorCount > 0) {
            String text = "Open Android SDK Manager and install all missing platforms.";
            Message hint = new Message("Failed to set up SDK", Message.Type.INFO, NonNavigatable.INSTANCE, text);
            messages.add(hint, new OpenAndroidSdkManagerHyperlink());
        }
    }

    private static void checkSdkToolsVersion(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "checkSdkToolsVersion"));
        }
        if (project.isDisposed() || ourNewSdkVersionToolsInfoAlreadyShown) {
            return;
        }
        PostProjectSetupTasksExecutor.checkExpiredPreviewBuild(project);
        File androidHome = IdeSdks.getAndroidSdkPath();
        if (androidHome != null && !VersionCheck.isCompatibleVersion(androidHome)) {
            InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
            String message = "Version " + VersionCheck.MIN_TOOLS_REV + " is available.";
            AndroidGradleNotification.getInstance(project).showBalloon("Android SDK Tools", message, NotificationType.INFORMATION, hyperlink);
            ourNewSdkVersionToolsInfoAlreadyShown = true;
        }
    }

    private static void checkExpiredPreviewBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "checkExpiredPreviewBuild"));
        }
        if (project.isDisposed() || ourCheckedExpiration) {
            return;
        }
        String fullVersion = ApplicationInfo.getInstance().getFullVersion();
        if (fullVersion.contains("Preview") || fullVersion.contains("Beta") || fullVersion.contains("RC")) {
            Calendar expirationDate = (Calendar)ApplicationInfo.getInstance().getBuildDate().clone();
            expirationDate.add(2, 2);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                OpenUrlHyperlink hyperlink = new OpenUrlHyperlink("http://tools.android.com/download/studio/", "Show Available Versions");
                String message = String.format("This preview build (%1$s) is old; please update to a newer preview or a stable version", fullVersion);
                AndroidGradleNotification.getInstance(project).showBalloon("Old Preview Build", message, NotificationType.INFORMATION, hyperlink);
                ourNewSdkVersionToolsInfoAlreadyShown = true;
            }
        }
        ourCheckedExpiration = true;
    }

    private void ensureValidSdks() {
        boolean checkJdkVersion = true;
        HashSet invalidAndroidSdks = Sets.newHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet == null || androidFacet.getAndroidModel() == null) continue;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && !invalidAndroidSdks.contains(sdk) && (PostProjectSetupTasksExecutor.isMissingAndroidLibrary(sdk) || PostProjectSetupTasksExecutor.shouldRemoveAnnotationsJar(sdk))) {
                AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
                AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
                if (additionalData != null && sdkData != null) {
                    IAndroidTarget target = additionalData.getBuildTarget(sdkData);
                    if (target == null) {
                        LocalSdk localSdk = sdkData.getLocalSdk();
                        localSdk.clearLocalPkg(EnumSet.of(PkgType.PKG_PLATFORM));
                        target = localSdk.getTargetFromHashString(additionalData.getBuildTargetHashString());
                    }
                    if (target != null) {
                        SdkModificator sdkModificator = sdk.getSdkModificator();
                        sdkModificator.removeAllRoots();
                        for (OrderRoot orderRoot : AndroidSdkUtils.getLibraryRootsForTarget(target, sdk.getHomePath(), true)) {
                            sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
                        }
                        ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
                        sdkModificator.commitChanges();
                    }
                }
                if (PostProjectSetupTasksExecutor.isMissingAndroidLibrary(sdk)) {
                    invalidAndroidSdks.add(sdk);
                }
            }
            AndroidGradleModel androidModel = AndroidGradleModel.get(androidFacet);
            assert (androidModel != null);
            if (!checkJdkVersion || ProjectJdkChecks.hasCorrectJdkVersion(module, androidModel)) continue;
            checkJdkVersion = false;
        }
        if (!invalidAndroidSdks.isEmpty()) {
            this.reinstallMissingPlatforms(invalidAndroidSdks);
        }
    }

    private static boolean isMissingAndroidLibrary(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "isMissingAndroidLibrary"));
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk)) {
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("android.jar") || !library.exists()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean shouldRemoveAnnotationsJar(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "shouldRemoveAnnotationsJar"));
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk)) {
            IAndroidTarget target;
            AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
            boolean needsAnnotationsJar = false;
            if (additionalData != null && sdkData != null && (target = additionalData.getBuildTarget(sdkData)) != null) {
                needsAnnotationsJar = AndroidSdkUtils.needsAnnotationsJarInClasspath(target);
            }
            for (VirtualFile library : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!library.getName().equals("annotations.jar") || !library.exists() || needsAnnotationsJar) continue;
                return true;
            }
        }
        return false;
    }

    private void reinstallMissingPlatforms(@NotNull Collection<Sdk> invalidAndroidSdks) {
        if (invalidAndroidSdks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalidAndroidSdks", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor", "reinstallMissingPlatforms"));
        }
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(this.myProject);
        ArrayList versionsToInstall = Lists.newArrayList();
        ArrayList missingPlatforms = Lists.newArrayList();
        for (Sdk sdk : invalidAndroidSdks) {
            String platform;
            AndroidSdkAdditionalData additionalData = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
            if (additionalData == null || (platform = additionalData.getBuildTargetHashString()) == null) continue;
            missingPlatforms.add("'" + platform + "'");
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)platform);
            if (version == null) continue;
            versionsToInstall.add(version);
        }
        if (!versionsToInstall.isEmpty()) {
            String group = String.format("Failed to sync Gradle project '%1$s'", this.myProject.getName());
            String text = "Missing Android platform(s) detected: " + Joiner.on((String)", ").join((Iterable)missingPlatforms);
            Message msg = new Message(group, Message.Type.ERROR, text);
            messages.add(msg, new InstallPlatformHyperlink(versionsToInstall.toArray(new AndroidVersion[versionsToInstall.size()])));
        }
    }

    public void setGenerateSourcesAfterSync(boolean generateSourcesAfterSync) {
        this.myGenerateSourcesAfterSync = generateSourcesAfterSync;
    }

    public void setLastSyncTimestamp(long lastSyncTimestamp) {
        this.myLastSyncTimestamp = lastSyncTimestamp;
    }

    public void setUsingCachedProjectData(boolean usingCachedProjectData) {
        this.myUsingCachedProjectData = usingCachedProjectData;
    }

    private static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final FullRevision myVersion;

        InstallSdkToolsHyperlink(@NotNull FullRevision version) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$InstallSdkToolsHyperlink", "<init>"));
            }
            super("install.build.tools", "Install Tools " + version);
            this.myVersion = version;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/PostProjectSetupTasksExecutor$InstallSdkToolsHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                FullRevision minBuildToolsRev = new FullRevision(20, 0, 0);
                requested.add(PkgDesc.Builder.newPlatformTool((FullRevision)minBuildToolsRev).create());
            }
            requested.add(PkgDesc.Builder.newTool((FullRevision)this.myVersion, (FullRevision)this.myVersion).create());
            SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
            wizard.init();
            if (wizard.showAndGet()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }
}

