/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.compatibility.ComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.FileLocation;
import com.android.tools.idea.gradle.project.compatibility.VersionRange;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.module.Module;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidGradlePluginVersionReader
implements ComponentVersionReader {
    AndroidGradlePluginVersionReader() {
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "appliesTo"));
        }
        return AndroidFacet.getInstance(module) != null;
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        AndroidGradleModel androidModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "getComponentVersion"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getAndroidProject().getModelVersion();
        }
        return null;
    }

    @Override
    @Nullable
    public FileLocation getVersionSource(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "getVersionSource"));
        }
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable FileLocation location) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "getQuickFixes"));
        }
        String version = "1.3.0";
        if (expectedVersion != null && expectedVersion.contains(version)) {
            FixGradleModelVersionHyperlink quickFix = new FixGradleModelVersionHyperlink(version, null, false);
            List<NotificationHyperlink> list = Collections.singletonList(quickFix);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "getQuickFixes"));
            }
            return list;
        }
        List<NotificationHyperlink> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "getQuickFixes"));
        }
        return list;
    }

    @Override
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("Android Gradle plugin" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/compatibility/AndroidGradlePluginVersionReader", "getComponentName"));
        }
        return "Android Gradle plugin";
    }
}

