/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.android.tools.idea.gradle.util.ProxySettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProperties {
    @NonNls
    private static final String JVM_ARGS_PROPERTY_NAME = "org.gradle.jvmargs";
    @NotNull
    private final File myPath;
    private final Properties myProperties;

    public GradleProperties(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/util/GradleProperties", "<init>"));
        }
        this(new File(Projects.getBaseDirPath(project), "gradle.properties"));
    }

    @VisibleForTesting
    GradleProperties(@NotNull File path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/util/GradleProperties", "<init>"));
        }
        this.myPath = path;
        this.myProperties = PropertiesUtil.getProperties(this.myPath);
    }

    @VisibleForTesting
    String getProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/util/GradleProperties", "getProperty"));
        }
        return this.myProperties.getProperty(name);
    }

    @NotNull
    public ProxySettings getHttpProxySettings() {
        ProxySettings proxySettings = new ProxySettings(this.myProperties, "http");
        if (proxySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleProperties", "getHttpProxySettings"));
        }
        return proxySettings;
    }

    @NotNull
    public ProxySettings getHttpsProxySettings() {
        ProxySettings proxySettings = new ProxySettings(this.myProperties, "https");
        if (proxySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleProperties", "getHttpsProxySettings"));
        }
        return proxySettings;
    }

    public void save() throws IOException {
        PropertiesUtil.savePropertiesToFile(this.myProperties, this.myPath, GradleProperties.getHeaderComment());
    }

    @NotNull
    private static String getHeaderComment() {
        Object[] lines = new String[]{"# Project-wide Gradle settings.", "", "# For more details on how to configure your build environment visit", "# http://www.gradle.org/docs/current/userguide/build_environment.html", "", "# Specifies the JVM arguments used for the daemon process.", "# The setting is particularly useful for tweaking memory settings.", "# Default value: -Xmx10248m -XX:MaxPermSize=256m", "# org.gradle.jvmargs=-Xmx2048m -XX:MaxPermSize=512m -XX:+HeapDumpOnOutOfMemoryError -Dfile.encoding=UTF-8", "", "# When configured, Gradle will run in incubating parallel mode.", "# This option should only be used with decoupled projects. More details, visit", "# http://www.gradle.org/docs/current/userguide/multi_project_builds.html#sec:decoupled_projects", "# org.gradle.parallel=true"};
        String string = Joiner.on((String)SystemProperties.getLineSeparator()).join(lines);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/util/GradleProperties", "getHeaderComment"));
        }
        return string;
    }

    public void setJvmArgs(@NotNull String jvmArgs) {
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/util/GradleProperties", "setJvmArgs"));
        }
        this.myProperties.setProperty(JVM_ARGS_PROPERTY_NAME, jvmArgs);
    }

    @Nullable
    public String getJvmArgs() {
        return this.myProperties.getProperty(JVM_ARGS_PROPERTY_NAME);
    }

    public Properties getProperties() {
        return this.myProperties;
    }
}

