/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.google.common.primitives.Ints;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private final AndroidLogcatPreferences myPreferences;
    @NonNls
    private static final Pattern LOGMESSAGE_PATTERN = Pattern.compile("^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d.\\d+)\\s+(\\d+)-(\\d+)/(\\S+)\\s+([A-Z])/([^ ]+): (.*)$");
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);

    public AndroidLogcatFormatter(@NotNull AndroidLogcatPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "<init>"));
        }
        this.myPreferences = preferences;
    }

    @NotNull
    public static String formatMessageFull(@NotNull AndroidLogcatReceiver.LogMessageHeader header, @NotNull String message) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessageFull"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessageFull"));
        }
        String string = AndroidLogcatFormatter.formatMessage(FULL_FORMAT, header, message);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessageFull"));
        }
        return string;
    }

    @NotNull
    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder = new StringBuilder();
        if (showTime) {
            builder.append("%1$s ");
        }
        if (showPid) {
            builder.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder.append("%3$s ");
        }
        builder.append("%4$c");
        if (showTag) {
            builder.append("/%5$s");
        }
        builder.append(": %6$s");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "createCustomFormat"));
        }
        return string;
    }

    @NotNull
    static String formatMessage(@NotNull String format, @NotNull String msg) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (format.isEmpty()) {
            String string = msg;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
            }
            return string;
        }
        Message message = AndroidLogcatFormatter.parseMessage(msg);
        if (message.getHeader() == null) {
            String string = message.getMessage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
            }
            return string;
        }
        String string = AndroidLogcatFormatter.formatMessage(format, message.getHeader(), message.getMessage());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        return string;
    }

    @NotNull
    private static String formatMessage(@NotNull String format, @NotNull AndroidLogcatReceiver.LogMessageHeader header, @NotNull String message) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        String ids = String.format(Locale.US, "%d-%s", header.myPid, header.myTid);
        String string = String.format(Locale.US, format, header.myTime, ids, header.myAppPackage.isEmpty() ? "?" : header.myAppPackage, Character.valueOf(header.myLogLevel.getPriorityLetter()), header.myTag, message);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        return string;
    }

    public static String formatMessage(@NotNull Log.LogLevel level, @NotNull String message) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "formatMessage"));
        }
        AndroidLogcatReceiver.LogMessageHeader header = new AndroidLogcatReceiver.LogMessageHeader();
        header.myTime = "00-00 00:00:00.0";
        header.myLogLevel = level;
        header.myPid = 0;
        header.myTid = "0";
        header.myAppPackage = "?";
        header.myTag = "Internal";
        return AndroidLogcatFormatter.formatMessageFull(header, message);
    }

    public static Message parseMessage(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/android/tools/idea/logcat/AndroidLogcatFormatter", "parseMessage"));
        }
        Matcher matcher = LOGMESSAGE_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return new Message(null, msg);
        }
        AndroidLogcatReceiver.LogMessageHeader header = new AndroidLogcatReceiver.LogMessageHeader();
        header.myTime = matcher.group(1);
        Integer pid = Ints.tryParse((String)matcher.group(2));
        header.myPid = pid == null ? 0 : pid;
        header.myTid = matcher.group(3);
        header.myAppPackage = matcher.group(4);
        header.myLogLevel = Log.LogLevel.getByLetter((char)matcher.group(5).charAt(0));
        header.myTag = matcher.group(6);
        String message = matcher.group(7);
        return new Message(header, message);
    }

    public String formatMessage(String msg) {
        return AndroidLogcatFormatter.formatMessage(this.myPreferences.LOGCAT_FORMAT_STRING, msg);
    }

    public static final class Message {
        @Nullable
        AndroidLogcatReceiver.LogMessageHeader myHeader;
        @NotNull
        String myMessage;

        public Message(@Nullable AndroidLogcatReceiver.LogMessageHeader logHeader, @NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/logcat/AndroidLogcatFormatter$Message", "<init>"));
            }
            this.myHeader = logHeader;
            this.myMessage = message;
        }

        @Nullable
        public AndroidLogcatReceiver.LogMessageHeader getHeader() {
            return this.myHeader;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatFormatter$Message", "getMessage"));
            }
            return string;
        }
    }
}

