/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidConsoleWriter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatReceiver
extends AndroidOutputReceiver
implements Disposable {
    private static Pattern HEADER_PATTERN = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d+):\\s*(\\S+)\\s([VDIWEAF])/(.*)\\s\\]$", 32);
    public static final String STACK_TRACE_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    public static final String STACK_TRACE_CAUSE_LINE_PREFIX = Character.toString(' ');
    private volatile boolean myCanceled;
    private final AndroidConsoleWriter myWriter;
    private final IDevice myDevice;
    private final StackTraceExpander myStackTraceExpander;
    @Nullable
    private LogMessageHeader myActiveHeader;

    public AndroidLogcatReceiver(@NotNull IDevice device, @NotNull AndroidConsoleWriter writer) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        this(device, writer, new StackTraceExpander(STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX));
    }

    AndroidLogcatReceiver(@NotNull IDevice device, @NotNull AndroidConsoleWriter writer, StackTraceExpander expander) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "<init>"));
        }
        this.myCanceled = false;
        this.myDevice = device;
        this.myWriter = writer;
        this.myStackTraceExpander = expander;
    }

    @Override
    public void processNewLine(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatReceiver", "processNewLine"));
        }
        if (line.isEmpty()) {
            this.myStackTraceExpander.reset();
            this.myActiveHeader = null;
            return;
        }
        Matcher matcher = HEADER_PATTERN.matcher(line);
        if (matcher.matches()) {
            long tidValue;
            this.myActiveHeader = new LogMessageHeader();
            this.myActiveHeader.myTime = matcher.group(1);
            this.myActiveHeader.myPid = Integer.valueOf(matcher.group(2));
            String tid = matcher.group(3);
            try {
                tidValue = Long.decode(tid);
            }
            catch (NumberFormatException e) {
                tidValue = -1L;
            }
            this.myActiveHeader.myTid = Long.toString(tidValue);
            this.myActiveHeader.myAppPackage = this.myDevice.getClientName(this.myActiveHeader.myPid);
            this.myActiveHeader.myLogLevel = AndroidLogcatReceiver.getByLetterString(matcher.group(4));
            this.myActiveHeader.myTag = matcher.group(5).trim().replace(' ', '\u00a0');
        } else if (this.myActiveHeader != null) {
            this.myStackTraceExpander.process(line);
            for (String processedLine : this.myStackTraceExpander.getProcessedLines()) {
                processedLine = AndroidLogcatReceiver.getFullMessage(this.myActiveHeader, processedLine);
                this.myWriter.addMessage(processedLine);
            }
        }
    }

    @Nullable
    private static Log.LogLevel getByLetterString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        Log.LogLevel logLevel = Log.LogLevel.getByLetterString((String)s);
        if (logLevel == null && s.equals("F")) {
            return Log.LogLevel.ASSERT;
        }
        return logLevel;
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    private static String getFullMessage(LogMessageHeader header, String message) {
        return AndroidLogcatFormatter.formatMessageFull(header, message);
    }

    public void cancel() {
        this.myCanceled = true;
    }

    static final class LogMessageHeader {
        String myTime;
        Log.LogLevel myLogLevel;
        int myPid;
        String myTid;
        String myAppPackage;
        String myTag;

        LogMessageHeader() {
        }
    }
}

