/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.OpenVmTraceHandler;
import com.android.tools.idea.ddms.actions.DumpSysActions;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.monitor.cpu.CpuMonitorView;
import com.android.tools.idea.monitor.gpu.GpuMonitorView;
import com.android.tools.idea.monitor.memory.MemoryMonitorView;
import com.android.tools.idea.monitor.network.NetworkMonitorView;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ProjectTopics;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final String TOOL_WINDOW_ID = AndroidBundle.message("android.logcat.title", new Object[0]);
    @NonNls
    private static final String ADBLOGS_CONTENT_ID = "AdbLogsContent";
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createToolWindowContent"));
        }
        ExecutionManager.getInstance((Project)project).getContentManager();
        RunnerLayoutUi layoutUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("Android", "Android", "Android", (Disposable)project);
        toolWindow.setIcon(AndroidIcons.AndroidToolWindow);
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        DeviceContext deviceContext = new DeviceContext();
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new OpenVmTraceHandler(project));
        Content logcatContent = AndroidToolWindowFactory.createLogcatContent(layoutUi, project, deviceContext);
        final AndroidLogcatView logcatView = (AndroidLogcatView)logcatContent.getUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY);
        assert (logcatView != null);
        logcatContent.setSearchComponent((JComponent)logcatView.createSearchComponent());
        layoutUi.addContent(logcatContent, 0, PlaceInGrid.center, false);
        Content memoryContent = AndroidToolWindowFactory.createMemoryContent(layoutUi, project, deviceContext);
        layoutUi.addContent(memoryContent, 1, PlaceInGrid.center, false);
        Content cpuContent = AndroidToolWindowFactory.createCpuContent(layoutUi, project, deviceContext);
        layoutUi.addContent(cpuContent, 2, PlaceInGrid.center, false);
        Content gpuContent = AndroidToolWindowFactory.createGpuContent(layoutUi, project, deviceContext);
        layoutUi.addContent(gpuContent, 3, PlaceInGrid.center, false);
        Content networkContent = AndroidToolWindowFactory.createNetworkContent(layoutUi, project, deviceContext);
        layoutUi.addContent(networkContent, 4, PlaceInGrid.center, false);
        layoutUi.getOptions().setLeftToolbar(this.getToolbarActions(project, deviceContext), "unknown");
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        DevicePanel devicePanel = new DevicePanel(project, deviceContext);
        JPanel panel = devicePanel.getComponent();
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        loadingPanel.add((Component)panel, (Object)"North");
        loadingPanel.add((Component)layoutUi.getComponent(), (Object)"Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)loadingPanel, "", true);
        c.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        c.putUserData(DEVICES_PANEL_KEY, (Object)devicePanel);
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleView console;
                logcatView.activate();
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                if (window != null && window.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                    AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                }
            }
        }, project.getDisposed());
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        loadingPanel.setLoadingText("Initializing ADB");
        loadingPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                Logger.getInstance(AndroidToolWindowFactory.class).info("Successfully obtained debug bridge");
                loadingPanel.stopLoading();
            }

            public void onFailure(Throwable t) {
                loadingPanel.stopLoading();
                Logger.getInstance(AndroidToolWindowFactory.class).info("Unable to obtain debug bridge", t);
                String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already.\nTry re-opening Studio after killing any existing adb daemons.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%1$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", adb.getAbsolutePath());
                Messages.showErrorDialog((String)msg, (String)"ADB Connection Error");
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private static Content createMemoryContent(@NotNull RunnerLayoutUi layoutUi, @NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (layoutUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutUi", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createMemoryContent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createMemoryContent"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createMemoryContent"));
        }
        MemoryMonitorView view = new MemoryMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("Memory", view.createComponent(), "Memory", AndroidIcons.MemoryMonitor, null);
        content.setCloseable(false);
        return content;
    }

    private static Content createCpuContent(@NotNull RunnerLayoutUi layoutUi, @NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (layoutUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutUi", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createCpuContent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createCpuContent"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createCpuContent"));
        }
        CpuMonitorView view = new CpuMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("CPU", view.createComponent(), "CPU", AndroidIcons.CpuMonitor, null);
        content.setCloseable(false);
        return content;
    }

    private static Content createGpuContent(@NotNull RunnerLayoutUi layoutUi, @NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (layoutUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutUi", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createGpuContent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createGpuContent"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createGpuContent"));
        }
        GpuMonitorView view = new GpuMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("GPU", view.createComponent(), "GPU", AndroidIcons.GpuMonitor, null);
        content.setCloseable(false);
        return content;
    }

    private static Content createNetworkContent(@NotNull RunnerLayoutUi layoutUi, @NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (layoutUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutUi", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createNetworkContent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createNetworkContent"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "createNetworkContent"));
        }
        NetworkMonitorView view = new NetworkMonitorView(project, deviceContext);
        Content content = layoutUi.createContent("Network", view.createComponent(), "Network", AndroidIcons.NetworkMonitor, null);
        content.setCloseable(false);
        return content;
    }

    @NotNull
    public ActionGroup getToolbarActions(Project project, DeviceContext deviceContext) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ScreenshotAction(project, deviceContext));
        group.add((AnAction)new ScreenRecorderAction(project, deviceContext));
        group.add((AnAction)DumpSysActions.create(project, deviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new TerminateVMAction(deviceContext));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    private static Content createLogcatContent(RunnerLayoutUi layoutUi, final Project project, DeviceContext deviceContext) {
        final AndroidLogcatView logcatView = new AndroidLogcatView(project, deviceContext){

            @Override
            protected boolean isActive() {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                return window.isVisible();
            }
        };
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){
            boolean myToolWindowVisible;

            public void stateChanged() {
                boolean visible;
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(TOOL_WINDOW_ID);
                if (window != null && (visible = window.isVisible()) != this.myToolWindowVisible) {
                    ConsoleView console;
                    this.myToolWindowVisible = visible;
                    logcatView.activate();
                    if (visible && (console = logcatView.getLogConsole().getConsole()) != null) {
                        AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                    }
                }
            }
        });
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        JPanel logcatContentPanel = logcatView.getContentPanel();
        Content logcatContent = layoutUi.createContent("Android Logcat", (JComponent)logcatContentPanel, "logcat", AndroidIcons.Ddms.Logcat, null);
        logcatContent.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        logcatContent.setDisposer((Disposable)logcatView);
        logcatContent.setCloseable(false);
        logcatContent.setPreferredFocusableComponent((JComponent)logcatContentPanel);
        return logcatContent;
    }

    private static void checkFacetAndSdk(Project project, @NotNull ConsoleView console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/android/tools/idea/monitor/AndroidToolWindowFactory", "checkFacetAndSdk"));
        }
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        if (facets.size() == 0) {
            console.clear();
            console.print(AndroidBundle.message("android.logcat.no.android.facets.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            console.clear();
            final Module module = facet.getModule();
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
                console.printHyperlink("configure", new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                    }
                });
                console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                console.print(AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName()) + '\n', ConsoleViewContentType.ERROR_OUTPUT);
            }
        }
    }

    private static class MyAndroidPlatformListener
    extends ModuleRootAdapter {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(@NotNull AndroidLogcatView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/monitor/AndroidToolWindowFactory$MyAndroidPlatformListener", "<init>"));
            }
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(ModuleRootEvent event) {
            final ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOL_WINDOW_ID);
            if (window == null) {
                return;
            }
            if (window.isDisposed() || !window.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Comparing.equal((Object)this.myPrevPlatform, (Object)newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!window.isDisposed() && window.isVisible()) {
                            MyAndroidPlatformListener.this.myView.activate();
                        }
                    }
                });
            }
        }

        @Nullable
        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (facets.size() > 0) {
                AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
                newPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            }
            return newPlatform;
        }
    }
}

