/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.tools.idea.npw.ChooseApiLevelDialog;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.sdk.SdkLoadedCallback;
import com.android.tools.idea.sdk.SdkPackages;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.stats.DistributionService;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DialogWrapperHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureFormFactorStep
extends DynamicWizardStepWithHeaderAndDescription {
    public static final String MIN_SDK_STRING = "Minimum SDK";
    private static final ScopedStateStore.Key<String> API_FEEDBACK_KEY = ScopedStateStore.createKey("API Feedback", ScopedStateStore.Scope.STEP, String.class);
    public static final ScopedStateStore.Key<Integer> NUM_ENABLED_FORM_FACTORS_KEY = ScopedStateStore.createKey("NumberOfEnabledFormFactors", ScopedStateStore.Scope.WIZARD, Integer.class);
    private JPanel myPanel;
    private JPanel myFormFactorPanel;
    private JBLabel myHelpMeChooseLabel;
    private HyperlinkLabel myHelpMeChooseLink;
    private List<Pair<ScopedStateStore.Key<Boolean>, JCheckBox>> myCheckboxKeys;
    private Map<FormFactorUtils.FormFactor, Integer> myFormFactors;
    private ChooseApiLevelDialog myChooseApiLevelDialog;
    private Disposable myDisposable;
    private Map<FormFactorUtils.FormFactor, FormFactorSdkControls> myFormFactorApiSelectors;
    private static final String DOWNLOAD_LINK_CARD = "link";
    private static final String DOWNLOAD_PROGRESS_CARD = "progress";

    public ConfigureFormFactorStep(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/android/tools/idea/npw/ConfigureFormFactorStep", "<init>"));
        }
        super("Select the form factors your app will run on", "Different platforms may require separate SDKs", disposable);
        this.$$$setupUI$$$();
        this.myHelpMeChooseLabel = new JBLabel(ConfigureFormFactorStep.getApiHelpText(0, ""));
        this.myHelpMeChooseLink = new HyperlinkLabel("Help me choose");
        this.myCheckboxKeys = Lists.newArrayList();
        this.myFormFactors = Maps.newTreeMap();
        this.myChooseApiLevelDialog = new ChooseApiLevelDialog(null, -1);
        this.myFormFactorApiSelectors = Maps.newHashMap();
        this.myDisposable = disposable;
        Disposer.register((Disposable)disposable, (Disposable)this.myChooseApiLevelDialog.getDisposable());
        this.setBodyComponent(this.myPanel);
        this.populateAdditionalFormFactors();
    }

    @Override
    public void init() {
        super.init();
        this.myHelpMeChooseLink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Integer minApiLevel = ConfigureFormFactorStep.this.myState.get(FormFactorUtils.getMinApiLevelKey(FormFactorUtils.FormFactor.MOBILE));
                ConfigureFormFactorStep.this.myChooseApiLevelDialog = new ChooseApiLevelDialog(null, minApiLevel == null ? 0 : minApiLevel);
                Disposer.register((Disposable)ConfigureFormFactorStep.this.myDisposable, (Disposable)ConfigureFormFactorStep.this.myChooseApiLevelDialog.getDisposable());
                if (ConfigureFormFactorStep.this.myChooseApiLevelDialog.showAndGet()) {
                    int selectedApiLevel = ConfigureFormFactorStep.this.myChooseApiLevelDialog.getSelectedApiLevel();
                    ((FormFactorSdkControls)ConfigureFormFactorStep.this.myFormFactorApiSelectors.get(FormFactorUtils.FormFactor.MOBILE)).setSelectedItem(Integer.toString(selectedApiLevel));
                }
            }
        });
        this.register(API_FEEDBACK_KEY, this.myHelpMeChooseLabel, new ScopedDataBinder.ComponentBinding<String, JBLabel>(){

            @Override
            public void setValue(@Nullable String newValue, @NotNull JBLabel label) {
                if (label == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/npw/ConfigureFormFactorStep$2", "setValue"));
                }
                final JBLabel referenceLabel = label;
                final String referenceString = newValue;
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        referenceLabel.setText(referenceString);
                    }
                });
            }
        });
        this.registerValueDeriver(API_FEEDBACK_KEY, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 3.makeSetOf(FormFactorUtils.getTargetComboBoxKey(FormFactorUtils.FormFactor.MOBILE));
            }

            @Override
            @Nullable
            public String deriveValue(@NotNull ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/ConfigureFormFactorStep$3", "deriveValue"));
                }
                FormFactorApiComboBox.AndroidTargetComboBoxItem selectedItem = state.get(FormFactorUtils.getTargetComboBoxKey(FormFactorUtils.FormFactor.MOBILE));
                String name = Integer.toString(selectedItem == null ? 0 : selectedItem.apiLevel);
                if (selectedItem != null && selectedItem.target != null) {
                    name = selectedItem.target.getVersion().getApiString();
                }
                return ConfigureFormFactorStep.getApiHelpText(selectedItem == null ? 0 : selectedItem.apiLevel, name);
            }
        });
        HashSet keys = Sets.newHashSet();
        for (Pair<ScopedStateStore.Key<Boolean>, JCheckBox> item : this.myCheckboxKeys) {
            keys.add(item.getFirst());
            this.register((ScopedStateStore.Key)item.getFirst(), (JCheckBox)item.getSecond());
        }
        this.myState.put((ScopedStateStore.Key)this.myCheckboxKeys.get(0).getFirst(), true);
        for (FormFactorSdkControls control : this.myFormFactorApiSelectors.values()) {
            control.getMinSdkCombo().loadSavedApi();
        }
    }

    private static String getApiHelpText(int selectedApi, String selectedApiName) {
        float percentage = (float)(DistributionService.getInstance().getSupportedDistributionForApiLevel(selectedApi) * 100.0);
        return String.format(Locale.getDefault(), "<html>Lower API levels target more devices, but have fewer features available. By targeting API %1$s<br>and later, your app will run on %2$s of the devices that are active on the<br>Google Play Store.</html>", selectedApiName, percentage < 1.0f ? "&lt; 1%" : String.format(Locale.getDefault(), "approximately <b>%.1f%%</b>", Float.valueOf(percentage)));
    }

    private void populateAdditionalFormFactors() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        this.myFormFactors.clear();
        this.myFormFactorPanel.removeAll();
        int row = 0;
        for (File templateFile : applicationTemplates) {
            FormFactorUtils.FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplate(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactorUtils.FormFactor.get(metadata.getFormFactor())) == null) continue;
            Integer prevMinSdk = this.myFormFactors.get(formFactor);
            int templateMinSdk = metadata.getMinSdk();
            if (prevMinSdk != null && templateMinSdk <= prevMinSdk) continue;
            this.myFormFactors.put(formFactor, templateMinSdk);
        }
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.myFormFactors.size() * 2 + 2, 2);
        gridLayoutManager.setVGap(5);
        gridLayoutManager.setHGap(10);
        this.myFormFactorPanel.setLayout((LayoutManager)gridLayoutManager);
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors.keySet()) {
            GridConstraints c = new GridConstraints();
            c.setRow(row);
            c.setColumn(0);
            c.setFill(0);
            c.setAnchor(8);
            JCheckBox inclusionCheckBox = new JCheckBox(formFactor.toString());
            this.myFormFactorPanel.add((Component)inclusionCheckBox, c);
            this.myCheckboxKeys.add((Pair<ScopedStateStore.Key<Boolean>, JCheckBox>)Pair.create(FormFactorUtils.getInclusionKey(formFactor), (Object)inclusionCheckBox));
            if (formFactor.baseFormFactor == null) {
                FormFactorSdkControls controls = new FormFactorSdkControls(formFactor, this.myFormFactors.get(formFactor));
                FormFactorApiComboBox minSdkComboBox = controls.getMinSdkCombo();
                minSdkComboBox.setName(formFactor.id + ".minSdk");
                controls.layout(this.myFormFactorPanel, ++row, inclusionCheckBox.getIconTextGap());
                this.myFormFactorApiSelectors.put(formFactor, controls);
                minSdkComboBox.register(this);
                if (minSdkComboBox.getItemCount() == 0) {
                    inclusionCheckBox.setSelected(false);
                    inclusionCheckBox.setEnabled(false);
                    inclusionCheckBox.setText(inclusionCheckBox.getText() + " (Not Installed)");
                    JBCardLayout layout = new JBCardLayout();
                    JPanel downloadCardPanel = new JPanel((LayoutManager)layout);
                    downloadCardPanel.add(DOWNLOAD_PROGRESS_CARD, ConfigureFormFactorStep.createDownloadingMessage());
                    HyperlinkLabel link = new HyperlinkLabel("Download");
                    downloadCardPanel.add(DOWNLOAD_LINK_CARD, (Component)link);
                    layout.show((Container)downloadCardPanel, DOWNLOAD_PROGRESS_CARD);
                    c.setColumn(1);
                    this.myFormFactorPanel.add((Component)downloadCardPanel, c);
                    this.findCompatibleSdk(formFactor, this.myFormFactors.get(formFactor), link, downloadCardPanel);
                }
            }
            if (formFactor.equals(FormFactorUtils.FormFactor.MOBILE)) {
                c.setRow(++row);
                c.setColumn(1);
                c.setAnchor(9);
                c.setFill(1);
                this.myFormFactorPanel.add((Component)this.myHelpMeChooseLabel, c);
                c.setRow(++row);
                this.myFormFactorPanel.add((Component)this.myHelpMeChooseLink, c);
            }
            ++row;
        }
    }

    private static JComponent createDownloadingMessage() {
        JPanel downloadPanel = new JPanel(new FlowLayout());
        AsyncProcessIcon refreshIcon = new AsyncProcessIcon("loading");
        JLabel refreshingLabel = new JLabel("Looking for SDK...");
        refreshingLabel.setForeground((Color)JBColor.GRAY);
        downloadPanel.add((Component)refreshIcon);
        downloadPanel.add(refreshingLabel);
        return downloadPanel;
    }

    private void findCompatibleSdk(final FormFactorUtils.FormFactor formFactor, final int minSdkLevel, final HyperlinkLabel link, final JPanel cardPanel) {
        SdkLoadedCallback onComplete = new SdkLoadedCallback(true){

            @Override
            public void doRun(@NotNull SdkPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/ConfigureFormFactorStep$4", "doRun"));
                }
                ArrayList packageList = Lists.newArrayList(packages.getNewPkgs());
                Collections.sort(packageList);
                Iterator result = Iterables.filter((Iterable)packageList, FormFactorUtils.getMinSdkPackageFilter(formFactor, minSdkLevel)).iterator();
                if (result.hasNext()) {
                    ConfigureFormFactorStep.this.showDownloadLink(link, (RemotePkgInfo)result.next(), cardPanel);
                } else {
                    cardPanel.setVisible(false);
                }
            }
        };
        Runnable onError = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cardPanel.setVisible(false);
                    }
                }, ModalityState.any());
            }
        };
        SdkState.getInstance(AndroidSdkUtils.tryToChooseAndroidSdk()).loadAsync(SdkState.DEFAULT_EXPIRATION_PERIOD_MS, false, null, onComplete, onError, false);
    }

    private void showDownloadLink(HyperlinkLabel link, final RemotePkgInfo remote, JPanel cardPanel) {
        link.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                ConfigureFormFactorStep.showDownloadWizard(remote.getPkgDesc());
                ConfigureFormFactorStep.this.populateAdditionalFormFactors();
                ConfigureFormFactorStep.this.myFormFactorPanel.validate();
            }
        });
        ((JBCardLayout)cardPanel.getLayout()).show((Container)cardPanel, DOWNLOAD_LINK_CARD);
    }

    private static void showDownloadWizard(IPkgDesc pack) {
        ArrayList requestedPackages = Lists.newArrayList((Object[])new IPkgDesc[]{pack});
        SdkQuickfixWizard sdkQuickfixWizard = new SdkQuickfixWizard(null, null, requestedPackages, new DialogWrapperHost(null, DialogWrapper.IdeModalityType.PROJECT));
        sdkQuickfixWizard.init();
        sdkQuickfixWizard.show();
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        if (this.myState.containsKey(WizardConstants.NEWLY_INSTALLED_API_KEY)) {
            FormFactorApiComboBox.loadInstalledVersions();
        }
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        super.deriveValues(modified);
        int enabledFormFactors = 0;
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors.keySet()) {
            Boolean included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor));
            if (included == null) continue;
            if (this.myFormFactorApiSelectors.containsKey(formFactor)) {
                this.myFormFactorApiSelectors.get(formFactor).setEnabled(included);
            }
            if (!included.booleanValue()) continue;
            ++enabledFormFactors;
            FormFactorSdkControls controls = this.myFormFactorApiSelectors.get(formFactor);
            if (controls == null) continue;
            controls.getMinSdkCombo().deriveValues(this.myState, modified);
        }
        this.myState.put(NUM_ENABLED_FORM_FACTORS_KEY, enabledFormFactors);
    }

    @Override
    public boolean validate() {
        this.setErrorHtml("");
        Integer enabledFormFactors = this.myState.get(NUM_ENABLED_FORM_FACTORS_KEY);
        if (enabledFormFactors == null || enabledFormFactors < 1) {
            this.setErrorHtml("At least one form factor must be selected.");
            return false;
        }
        for (FormFactorUtils.FormFactor formFactor : this.myFormFactors.keySet()) {
            Boolean included = this.myState.get(FormFactorUtils.getInclusionKey(formFactor));
            if (included == null || !included.booleanValue()) continue;
            if (!this.isBaseEnabled(formFactor)) {
                return false;
            }
            if (formFactor.baseFormFactor != null || this.myState.get(FormFactorUtils.getMinApiKey(formFactor)) != null) continue;
            this.setErrorHtml(formFactor + " must have a Minimum SDK level selected.");
            return false;
        }
        return true;
    }

    private boolean isBaseEnabled(FormFactorUtils.FormFactor formFactor) {
        if (formFactor.baseFormFactor == null) {
            return true;
        }
        Boolean isBaseEnabled = this.myState.get(FormFactorUtils.getInclusionKey(formFactor.baseFormFactor));
        if (isBaseEnabled == null || !isBaseEnabled.booleanValue()) {
            this.setErrorHtml("In order to support " + formFactor + " you need to enable " + formFactor.baseFormFactor);
            return false;
        }
        FormFactorApiComboBox.AndroidTargetComboBoxItem baseMinSdk = this.myState.get(FormFactorUtils.getTargetComboBoxKey(formFactor.baseFormFactor));
        if (!FormFactorUtils.getMinSdkComboBoxFilter(formFactor, this.myFormFactors.get(formFactor)).apply((Object)baseMinSdk)) {
            this.setErrorHtml("Set a minimum SDK level on " + formFactor.baseFormFactor + " that is compatible with " + formFactor);
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getStepName() {
        if ("Configure Form Factors" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ConfigureFormFactorStep", "getStepName"));
        }
        return "Configure Form Factors";
    }

    @Nullable
    public String getHelpText(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/android/tools/idea/npw/ConfigureFormFactorStep", "getHelpText"));
        }
        if (param.equals("minApi")) {
            return "Choose the lowest version of Android that your application will support. Lower API levels target more devices, but means fewer features are available. By targeting API 10 and later, you reach approximately 99% of the market.";
        }
        if (param.equals("targetApi")) {
            return "Choose the highest API level that the application is known to work with. This attribute informs the system that you have tested against the target version and the system should not enable any compatibility behaviors to maintain your app's forward-compatibility with the target version. The application is still able to run on older versions (down to minSdkVersion). Your application may look dated if you are not targeting the current version.";
        }
        if (param.equals("buildApi")) {
            return "Choose a target API to compile your code against, from your installed SDKs. This is typically the most recent version, or the first version that supports all the APIs you want to directly access without reflection.";
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPanel;
    }

    @Override
    @NotNull
    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings wizardStepHeaderSettings = DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createTitleOnlyHeader("Target Android Devices");
        if (wizardStepHeaderSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/ConfigureFormFactorStep", "getStepHeader"));
        }
        return wizardStepHeaderSettings;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFormFactorPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(750, -1), new Dimension(750, -1)));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 1, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class FormFactorSdkControls {
        private final JLabel myLabel = new JLabel("Minimum SDK");
        private final FormFactorApiComboBox myMinSdkCombobox;

        public FormFactorSdkControls(FormFactorUtils.FormFactor formFactor, int minApi) {
            this.myMinSdkCombobox = new FormFactorApiComboBox(formFactor, minApi);
        }

        public void setEnabled(boolean enabled) {
            for (JComponent component : ImmutableSet.of((Object)this.myLabel, (Object)this.myMinSdkCombobox)) {
                component.setEnabled(enabled);
            }
        }

        public void setSelectedItem(String item) {
            ScopedDataBinder.setSelectedItem(this.myMinSdkCombobox, item);
        }

        public JLabel getLabel() {
            return this.myLabel;
        }

        public FormFactorApiComboBox getMinSdkCombo() {
            return this.myMinSdkCombobox;
        }

        private void layout(JPanel panel, int row, int ident) {
            GridConstraints c = new GridConstraints();
            c.setVSizePolicy(0);
            c.setRow(row);
            c.setColumn(0);
            c.setFill(0);
            c.setAnchor(8);
            c.setRow(row);
            c.setIndent(ident);
            panel.add((Component)this.myLabel, c);
            c.setIndent(0);
            c.setColumn(1);
            c.setFill(1);
            panel.add((Component)this.myMinSdkCombobox, c);
        }
    }
}

