/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.sdklib.repository.descriptors.IPkgDescAddon;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormFactorUtils {
    public static final String INCLUDE_FORM_FACTOR = "included";
    public static final String ATTR_MODULE_NAME = "projectName";

    @NotNull
    public static ScopedStateStore.Key<FormFactorApiComboBox.AndroidTargetComboBoxItem> getTargetComboBoxKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getTargetComboBoxKey"));
        }
        ScopedStateStore.Key<FormFactorApiComboBox.AndroidTargetComboBoxItem> key = ScopedStateStore.createKey(formFactor.id + "minApi" + "combo", ScopedStateStore.Scope.STEP, FormFactorApiComboBox.AndroidTargetComboBoxItem.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getTargetComboBoxKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<Integer> getMinApiLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getMinApiLevelKey"));
        }
        ScopedStateStore.Key<Integer> key = ScopedStateStore.createKey(formFactor.id + "minApiLevel", ScopedStateStore.Scope.WIZARD, Integer.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getMinApiLevelKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<String> getMinApiKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getMinApiKey"));
        }
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(formFactor.id + "minApi", ScopedStateStore.Scope.WIZARD, String.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getMinApiKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<String> getBuildApiKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getBuildApiKey"));
        }
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(formFactor.id + "buildApiString", ScopedStateStore.Scope.WIZARD, String.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getBuildApiKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<Integer> getTargetApiLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getTargetApiLevelKey"));
        }
        ScopedStateStore.Key<Integer> key = ScopedStateStore.createKey(formFactor.id + "targetApi", ScopedStateStore.Scope.WIZARD, Integer.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getTargetApiLevelKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<String> getTargetApiStringKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getTargetApiStringKey"));
        }
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(formFactor.id + "targetApiString", ScopedStateStore.Scope.WIZARD, String.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getTargetApiStringKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<Integer> getBuildApiLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getBuildApiLevelKey"));
        }
        ScopedStateStore.Key<Integer> key = ScopedStateStore.createKey(formFactor.id + "buildApi", ScopedStateStore.Scope.WIZARD, Integer.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getBuildApiLevelKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<String> getLanguageLevelKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getLanguageLevelKey"));
        }
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(formFactor.id + "javaVersion", ScopedStateStore.Scope.WIZARD, String.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getLanguageLevelKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<Boolean> getInclusionKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getInclusionKey"));
        }
        ScopedStateStore.Key<Boolean> key = ScopedStateStore.createKey(formFactor.id + INCLUDE_FORM_FACTOR, ScopedStateStore.Scope.WIZARD, Boolean.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getInclusionKey"));
        }
        return key;
    }

    @NotNull
    public static ScopedStateStore.Key<String> getModuleNameKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getModuleNameKey"));
        }
        ScopedStateStore.Key<String> key = ScopedStateStore.createKey(formFactor.id + ATTR_MODULE_NAME, ScopedStateStore.Scope.WIZARD, String.class);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getModuleNameKey"));
        }
        return key;
    }

    public static Map<String, Object> scrubFormFactorPrefixes(@NotNull FormFactor formFactor, @NotNull Map<String, Object> values) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "scrubFormFactorPrefixes"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/android/tools/idea/npw/FormFactorUtils", "scrubFormFactorPrefixes"));
        }
        HashMap toReturn = Maps.newHashMapWithExpectedSize((int)values.size());
        for (String key : values.keySet()) {
            if (key.startsWith(formFactor.id)) {
                toReturn.put(key.substring(formFactor.id.length()), values.get(key));
                continue;
            }
            toReturn.put(key, values.get(key));
        }
        return toReturn;
    }

    public static String getPropertiesComponentMinSdkKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getPropertiesComponentMinSdkKey"));
        }
        return formFactor.id + "minApi";
    }

    @NotNull
    public static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getModuleName"));
        }
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        String name = formFactor.id.replaceAll("[/\\\\?%*:|\"<>!;]", "");
        name = name.replaceAll("\\s", "_");
        String string = name.toLowerCase();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils", "getModuleName"));
        }
        return string;
    }

    public static Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem> getMinSdkComboBoxFilter(final @NotNull FormFactor formFactor, final int minSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getMinSdkComboBoxFilter"));
        }
        return new Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem>(){

            public boolean apply(@Nullable FormFactorApiComboBox.AndroidTargetComboBoxItem input) {
                if (input == null) {
                    return false;
                }
                return FormFactorUtils.doFilter(formFactor, minSdkLevel, input.target != null ? input.target.getName() : null, input.apiLevel) || input.target != null && input.target.getVersion().isPreview();
            }
        };
    }

    public static Predicate<RemotePkgInfo> getMinSdkPackageFilter(final @NotNull FormFactor formFactor, final int minSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "getMinSdkPackageFilter"));
        }
        return new Predicate<RemotePkgInfo>(){

            public boolean apply(@Nullable RemotePkgInfo input) {
                if (input == null) {
                    return false;
                }
                if (input.getPkgDesc().getType() == PkgType.PKG_ADDON) {
                    IPkgDescAddon addon = (IPkgDescAddon)input.getPkgDesc();
                    return FormFactorUtils.doFilter(formFactor, minSdkLevel, addon.getName().getId(), addon.getAndroidVersion().getFeatureLevel());
                }
                return false;
            }
        };
    }

    private static boolean doFilter(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable String inputName, int targetSdkLevel) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorUtils", "doFilter"));
        }
        if (!formFactor.myApiWhitelist.isEmpty()) {
            for (String filterItem : formFactor.myApiWhitelist) {
                if (!FormFactorUtils.matches(filterItem, inputName, targetSdkLevel)) continue;
                return true;
            }
            return false;
        }
        for (String filterItem : formFactor.myApiBlacklist) {
            if (!FormFactorUtils.matches(filterItem, inputName, targetSdkLevel)) continue;
            return false;
        }
        return targetSdkLevel >= minSdkLevel;
    }

    private static boolean matches(@NotNull String filterItem, @Nullable String inputName, int inputVersion) {
        if (filterItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterItem", "com/android/tools/idea/npw/FormFactorUtils", "matches"));
        }
        if (Integer.toString(inputVersion).equals(filterItem)) {
            return true;
        }
        return inputName != null && inputName.contains(filterItem);
    }

    @Nullable
    public static Icon getFormFactorsImage(JComponent component, boolean requireEmulator) {
        int width = 0;
        int height = 0;
        for (DeviceMenuAction.FormFactor formFactor : DeviceMenuAction.FormFactor.values()) {
            Icon icon = formFactor.getLargeIcon();
            height = icon.getIconHeight();
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            width += formFactor.getLargeIcon().getIconWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        for (DeviceMenuAction.FormFactor formFactor : DeviceMenuAction.FormFactor.values()) {
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            Icon icon = formFactor.getLargeIcon();
            icon.paintIcon(component, graphics, x, 0);
            x += icon.getIconWidth();
        }
        if (graphics != null) {
            graphics.dispose();
            return new ImageIcon(image);
        }
        return null;
    }

    public static class FormFactor
    implements Comparable<FormFactor> {
        public static final FormFactor MOBILE = new FormFactor("Mobile", DeviceMenuAction.FormFactor.MOBILE, "Phone and Tablet", 15, Lists.newArrayList((Object[])new String[]{"20", "Glass", "Google APIs"}), null, 0, null);
        public static final FormFactor WEAR = new FormFactor("Wear", DeviceMenuAction.FormFactor.WEAR, "Wear", 21, null, Lists.newArrayList((Object[])new String[]{"20", "21", "22"}), 1, null);
        public static final FormFactor TV = new FormFactor("TV", DeviceMenuAction.FormFactor.TV, "TV", 21, Lists.newArrayList((Object[])new String[]{"20"}), null, 2, null);
        public static final FormFactor CAR = new FormFactor("Car", DeviceMenuAction.FormFactor.CAR, "Android Auto", 21, null, null, 3, MOBILE);
        public static final FormFactor GLASS = new FormFactor("Glass", DeviceMenuAction.FormFactor.GLASS, "Glass", 19, null, Lists.newArrayList((Object[])new String[]{"Glass", "google_gdk"}), 4, null);
        private static final Map<String, FormFactor> myFormFactors = new ImmutableMap.Builder().put((Object)FormFactor.MOBILE.id, (Object)MOBILE).put((Object)FormFactor.WEAR.id, (Object)WEAR).put((Object)FormFactor.TV.id, (Object)TV).put((Object)FormFactor.CAR.id, (Object)CAR).put((Object)FormFactor.GLASS.id, (Object)GLASS).build();
        public final String id;
        @Nullable
        private String myDisplayName;
        public final int defaultApi;
        @NotNull
        private final List<String> myApiBlacklist;
        @NotNull
        private final List<String> myApiWhitelist;
        @NotNull
        private final DeviceMenuAction.FormFactor myEnumValue;
        private final int relativeOrder;
        @Nullable
        public final FormFactor baseFormFactor;

        FormFactor(@NotNull String id, @NotNull DeviceMenuAction.FormFactor enumValue, @Nullable String displayName, int defaultApi, @Nullable List<String> apiBlacklist, @Nullable List<String> apiWhitelist, int relativeOrder, @Nullable FormFactor baseFormFactor) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/npw/FormFactorUtils$FormFactor", "<init>"));
            }
            if (enumValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumValue", "com/android/tools/idea/npw/FormFactorUtils$FormFactor", "<init>"));
            }
            this.id = id;
            this.myEnumValue = enumValue;
            this.myDisplayName = displayName;
            this.defaultApi = defaultApi;
            this.relativeOrder = relativeOrder;
            this.myApiBlacklist = apiBlacklist != null ? apiBlacklist : Collections.emptyList();
            this.myApiWhitelist = apiWhitelist != null ? apiWhitelist : Collections.emptyList();
            this.baseFormFactor = baseFormFactor;
        }

        @Nullable
        public static FormFactor get(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/npw/FormFactorUtils$FormFactor", "get"));
            }
            if (myFormFactors.containsKey(id)) {
                return myFormFactors.get(id);
            }
            return new FormFactor(id, DeviceMenuAction.FormFactor.MOBILE, id, 1, null, null, myFormFactors.size(), null);
        }

        @NotNull
        public DeviceMenuAction.FormFactor getEnumValue() {
            DeviceMenuAction.FormFactor formFactor = this.myEnumValue;
            if (formFactor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils$FormFactor", "getEnumValue"));
            }
            return formFactor;
        }

        public String toString() {
            return this.myDisplayName == null ? this.id : this.myDisplayName;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myEnumValue.getIcon64();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorUtils$FormFactor", "getIcon"));
            }
            return icon;
        }

        public static Iterator<FormFactor> iterator() {
            return myFormFactors.values().iterator();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof FormFactor && ((FormFactor)obj).id.equals(this.id);
        }

        @Override
        public int compareTo(FormFactor formFactor) {
            return this.relativeOrder - formFactor.relativeOrder;
        }
    }
}

