/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AsyncWriterDelegate
implements Runnable {
    private static final Logger LOG = Logger.getInstance(AsyncWriterDelegate.class);
    @NotNull
    private BlockingQueue<Message> myWriteQueue = new LinkedBlockingDeque<Message>();
    private boolean myShouldContinue = true;

    AsyncWriterDelegate() {
    }

    void queueWrite(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) throws InterruptedException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/AsyncWriterDelegate", "queueWrite"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/profiling/capture/AsyncWriterDelegate", "queueWrite"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myWriteQueue.put(new WriteMessage(captureHandle, data));
    }

    void closeFileAndRunTaskAsynchronously(@NotNull CaptureHandle captureHandle, @Nullable Runnable task) throws InterruptedException {
        if (captureHandle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/AsyncWriterDelegate", "closeFileAndRunTaskAsynchronously"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myWriteQueue.put(new FinalizeMessage(captureHandle, task));
    }

    void queueExit() throws InterruptedException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myWriteQueue.put(new ExitMessage());
    }

    @Override
    public void run() {
        try {
            while (this.myShouldContinue) {
                Message message = this.myWriteQueue.take();
                message.performMessageRequest();
            }
            if (!this.myWriteQueue.isEmpty()) {
                LOG.warn("AsyncWriterDelegate was stopped before all messages in flight were handled.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myWriteQueue.clear();
    }

    private static class FinalizeMessage
    extends Message {
        @NotNull
        private CaptureHandle myCaptureHandle;
        @Nullable
        private Runnable myTask;

        private FinalizeMessage(@NotNull CaptureHandle captureHandle, @Nullable Runnable task) {
            if (captureHandle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/AsyncWriterDelegate$FinalizeMessage", "<init>"));
            }
            this.myCaptureHandle = captureHandle;
            this.myTask = task;
        }

        @Override
        protected void performMessageRequest() {
            this.myCaptureHandle.closeFileOutputStream();
            if (this.myTask != null) {
                this.myTask.run();
            }
        }
    }

    private static class WriteMessage
    extends Message {
        @NotNull
        private CaptureHandle myCaptureHandle;
        @NotNull
        private byte[] myData;

        private WriteMessage(@NotNull CaptureHandle captureHandle, @NotNull byte[] data) {
            if (captureHandle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "captureHandle", "com/android/tools/idea/profiling/capture/AsyncWriterDelegate$WriteMessage", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/profiling/capture/AsyncWriterDelegate$WriteMessage", "<init>"));
            }
            this.myCaptureHandle = captureHandle;
            this.myData = data;
        }

        @Override
        protected void performMessageRequest() {
            try {
                CaptureService.appendDataSynchronous(this.myCaptureHandle, this.myData);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private class ExitMessage
    extends Message {
        private ExitMessage() {
        }

        @Override
        protected void performMessageRequest() {
            AsyncWriterDelegate.this.myShouldContinue = false;
        }
    }

    private static abstract class Message {
        private Message() {
        }

        protected abstract void performMessageRequest();
    }
}

