/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectBuildNotifications {
    private static final Topic<AndroidProjectBuildListener> PROJECT_BUILD_LISTENER_TOPIC = new Topic("Android Project Build", AndroidProjectBuildListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;

    public static void subscribe(@NotNull Project project, @NotNull AndroidProjectBuildListener listener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "subscribe"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "subscribe"));
        }
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(PROJECT_BUILD_LISTENER_TOPIC, (Object)listener);
    }

    @NotNull
    public static AndroidProjectBuildNotifications getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "getInstance"));
        }
        AndroidProjectBuildNotifications androidProjectBuildNotifications = (AndroidProjectBuildNotifications)ServiceManager.getService((Project)project, AndroidProjectBuildNotifications.class);
        if (androidProjectBuildNotifications == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "getInstance"));
        }
        return androidProjectBuildNotifications;
    }

    public AndroidProjectBuildNotifications(@NotNull Project project, @NotNull MessageBus messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "<init>"));
        }
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void notifyBuildComplete(final @NotNull BuildContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/project/AndroidProjectBuildNotifications", "notifyBuildComplete"));
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                ((AndroidProjectBuildListener)AndroidProjectBuildNotifications.this.myMessageBus.syncPublisher(PROJECT_BUILD_LISTENER_TOPIC)).buildComplete(context);
            }
        });
    }

    public static interface BuildContext {
    }

    public static interface AndroidProjectBuildListener {
        public void buildComplete(@NotNull BuildContext var1);
    }
}

