/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.Density;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AddMissingAttributesFix;
import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.rendering.ShowExceptionFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class RenderErrorPanel
extends JPanel {
    public static final boolean SIZE_ERROR_PANEL_DYNAMICALLY = true;
    private static final int ERROR_PANEL_OPACITY = UIUtil.isUnderDarcula() ? 224 : 208;
    private static final String RENDER_SESSION_IMPL_FQCN = "com.android.layoutlib.bridge.impl.RenderSessionImpl";
    private static final Logger LOG = Logger.getInstance(RenderErrorPanel.class);
    private JEditorPane myHTMLViewer;
    private final HyperlinkListener myHyperLinkListener;
    private RenderResult myResult;
    private HighlightSeverity mySeverity;
    private HtmlLinkManager myLinkManager;
    private final JScrollPane myScrollPane;

    public RenderErrorPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.myHTMLViewer = new JEditorPane("text/html", "<HTML><BODY>Render Problems</BODY></HTML>");
        this.myHTMLViewer.setEditable(false);
        this.myHyperLinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                        HTMLDocument doc = (HTMLDocument)pane.getDocument();
                        doc.processHTMLFrameHyperlinkEvent(evt);
                        return;
                    }
                    String url = e.getDescription();
                    if (url.equals("action:close")) {
                        RenderErrorPanel.this.close();
                        return;
                    }
                    RenderErrorPanel.this.performClick(url);
                }
            }
        };
        this.myHTMLViewer.addHyperlinkListener(this.myHyperLinkListener);
        this.myHTMLViewer.setMargin(new Insets(3, 3, 3, 3));
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myHTMLViewer);
        this.setupStyle();
        this.add((Component)this.myScrollPane, "Center");
    }

    public void dispose() {
        this.removeAll();
        if (this.myHTMLViewer != null) {
            this.myHTMLViewer.removeHyperlinkListener(this.myHyperLinkListener);
            this.myHTMLViewer = null;
        }
    }

    @Nullable
    public String showErrors(@NotNull RenderResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/RenderErrorPanel", "showErrors"));
        }
        RenderLogger logger = result.getLogger();
        if (!logger.hasProblems()) {
            this.showErrors(null, null, null);
            return null;
        }
        try {
            String html = this.generateHtml(result, result.getLogger().getLinkManager());
            this.showErrors(html, result, logger.getLinkManager());
            return html;
        }
        catch (Exception e) {
            this.showEmpty();
            return null;
        }
    }

    public void showErrors(@Nullable String html, @Nullable RenderResult result, @Nullable HtmlLinkManager linkManager) {
        this.showErrors(HighlightSeverity.ERROR, html, result, linkManager);
    }

    public void showWarning(@Nullable String html) {
        this.showErrors(HighlightSeverity.WARNING, html, null, null);
    }

    private void showErrors(HighlightSeverity severity, @Nullable String html, @Nullable RenderResult result, @Nullable HtmlLinkManager linkManager) {
        this.mySeverity = severity;
        if (html == null) {
            this.myResult = null;
            this.showEmpty();
            return;
        }
        try {
            this.myHTMLViewer.read(new StringReader(html), null);
            this.setupStyle();
            this.myHTMLViewer.setCaretPosition(0);
            this.myResult = result;
            this.myLinkManager = linkManager;
        }
        catch (Exception e) {
            this.showEmpty();
        }
    }

    public void performClick(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/idea/rendering/RenderErrorPanel", "performClick"));
        }
        Module module = this.myResult.getModule();
        PsiFile file = this.myResult.getFile();
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
        assert (dataContext != null);
        this.myLinkManager.handleUrl(url, module, file, dataContext, this.myResult);
    }

    private void close() {
        this.setVisible(false);
    }

    private void setupStyle() {
        JViewport viewPort = this.myScrollPane.getViewport();
        viewPort.setOpaque(false);
        viewPort.setBackground(null);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.setBackground(null);
        Document document = this.myHTMLViewer.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)document;
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        Style style = styledDocument.addStyle("active", null);
        StyleConstants.setFontFamily(style, scheme.getEditorFontName());
        StyleConstants.setFontSize(style, scheme.getEditorFontSize());
        styledDocument.setCharacterAttributes(0, document.getLength(), style, false);
        Color background = this.myHTMLViewer.getBackground();
        if (background != null) {
            background = new Color(background.getRed(), background.getGreen(), background.getBlue(), ERROR_PANEL_OPACITY);
            this.myHTMLViewer.setBackground(background);
        }
    }

    public JEditorPane getEditorPane() {
        return this.myHTMLViewer;
    }

    public int getPreferredHeight(int width) {
        return this.myHTMLViewer.getPreferredSize().height;
    }

    @Nullable
    public HighlightSeverity getSeverity() {
        return this.mySeverity;
    }

    public String generateHtml(@NotNull RenderResult result, @NotNull HtmlLinkManager linkManager) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/RenderErrorPanel", "generateHtml"));
        }
        if (linkManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkManager", "com/android/tools/idea/rendering/RenderErrorPanel", "generateHtml"));
        }
        this.myResult = result;
        this.myLinkManager = linkManager;
        RenderLogger logger = result.getLogger();
        RenderTask renderTask = result.getRenderTask();
        assert (logger.hasProblems());
        HtmlBuilder builder = new HtmlBuilder(new StringBuilder(300));
        builder.openHtmlBody();
        builder.addHtml("<A HREF=\"");
        builder.addHtml("action:close");
        builder.addHtml("\">");
        builder.addIcon(HtmlBuilderHelper.getCloseIconPath());
        builder.addHtml("</A>");
        builder.addHeading("Rendering Problems", HtmlBuilderHelper.getHeaderFontColor()).newline();
        RenderErrorPanel.reportMissingStyles(logger, builder);
        if (renderTask != null) {
            RenderErrorPanel.reportOldNinePathRenderLib(logger, builder, renderTask);
            RenderErrorPanel.reportRelevantCompilationErrors(logger, builder, renderTask);
            this.reportMissingSizeAttributes(logger, builder, renderTask);
            this.reportMissingClasses(logger, builder, renderTask);
        }
        this.reportBrokenClasses(logger, builder);
        this.reportInstantiationProblems(logger, builder);
        this.reportOtherProblems(logger, builder);
        this.reportUnknownFragments(logger, builder);
        if (renderTask != null) {
            this.reportRenderingFidelityProblems(logger, builder, renderTask);
        }
        builder.closeHtmlBody();
        return builder.getHtml();
    }

    private void reportMissingClasses(@NotNull RenderLogger logger, @NotNull HtmlBuilder builder, @NotNull RenderTask renderTask) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingClasses"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingClasses"));
        }
        if (renderTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderTask", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingClasses"));
        }
        Set<String> missingClasses = logger.getMissingClasses();
        if (missingClasses != null && !missingClasses.isEmpty()) {
            Collection<String> views;
            if (missingClasses.contains("CalendarView")) {
                builder.add("The ").addBold("CalendarView").add(" widget does not work correctly with this render target. As a workaround, try using the API 15 (Android 4.0.3) render target library by selecting it from the toolbar menu above.");
                if (missingClasses.size() == 1) {
                    return;
                }
            }
            boolean missingResourceClass = logger.isMissingResourceClass() && logger.getResourceClass() != null && logger.hasLoadedClasses();
            builder.add("The following classes could not be found:");
            builder.beginList();
            ArrayList customViews = null;
            ArrayList androidViewClassNames = null;
            Module module = logger.getModule();
            if (module != null && !(views = RenderErrorPanel.getAllViews(module)).isEmpty()) {
                customViews = Lists.newArrayListWithExpectedSize((int)Math.max(10, views.size() - 80));
                androidViewClassNames = Lists.newArrayListWithExpectedSize((int)views.size());
                for (String fqcn : views) {
                    if (fqcn.startsWith("android.") && !ResourceHelper.viewNeedsPackage(fqcn)) {
                        androidViewClassNames.add(fqcn);
                        continue;
                    }
                    customViews.add(fqcn);
                }
            }
            if (missingResourceClass) {
                builder.listItem();
                builder.add(logger.getResourceClass());
            }
            boolean foundCustomView = false;
            for (String className : missingClasses) {
                builder.listItem();
                builder.add(className);
                builder.add(" (");
                foundCustomView |= this.addTypoSuggestions(builder, className, customViews, false);
                this.addTypoSuggestions(builder, className, customViews, true);
                this.addTypoSuggestions(builder, className, androidViewClassNames, false);
                if (this.myLinkManager == null) {
                    return;
                }
                builder.addLink("Fix Build Path", this.myLinkManager.createEditClassPathUrl());
                RenderContext renderContext = renderTask.getRenderContext();
                if (renderContext != null && renderContext.getType() == RenderContext.UsageType.LAYOUT_EDITOR) {
                    builder.add(", ");
                    builder.addLink("Edit XML", this.myLinkManager.createShowTagUrl(className));
                }
                if (className.indexOf(46) != -1) {
                    builder.add(", ");
                    builder.addLink("Create Class", this.myLinkManager.createNewClassUrl(className));
                }
                builder.add(")");
            }
            builder.endList();
            builder.addIcon(HtmlBuilderHelper.getTipIconPath());
            builder.addLink("Tip: Try to ", "build", " the project.", this.myLinkManager.createCompileModuleUrl());
            if (foundCustomView) {
                builder.newline();
                builder.add("One or more missing custom views were found in the project, but does not appear to have been compiled yet.");
            }
            builder.newline().newline();
        }
    }

    private boolean addTypoSuggestions(@NotNull HtmlBuilder builder, String actual, @Nullable Collection<String> views, boolean compareWithPackage) {
        int maxDistance;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "addTypoSuggestions"));
        }
        if (views == null || views.isEmpty()) {
            return false;
        }
        String actualBase = actual.substring(actual.lastIndexOf(46) + 1);
        String match = compareWithPackage ? actual : actualBase;
        int n = maxDistance = actualBase.length() >= 4 ? 2 : 1;
        if (views.size() > 0) {
            for (String suggested : views) {
                String matchWith;
                String suggestedBase = suggested.substring(suggested.lastIndexOf(46) + 1);
                String string = matchWith = compareWithPackage ? suggested : suggestedBase;
                if (Math.abs(actualBase.length() - suggestedBase.length()) > maxDistance) continue;
                boolean sameBase = actualBase.equals(suggestedBase);
                if (!compareWithPackage && sameBase) continue;
                if (compareWithPackage) {
                    if (!sameBase) continue;
                    if (actualBase.equals(actual) && !actualBase.equals(suggested) && ResourceHelper.viewNeedsPackage(suggested)) {
                        builder.addLink(String.format("Change to %1$s", suggested), this.myLinkManager.createReplaceTagsUrl(actual, suggested));
                        builder.add(", ");
                        continue;
                    }
                }
                if (compareWithPackage && Math.abs(match.length() - matchWith.length()) > maxDistance) continue;
                if (match.equals(matchWith)) {
                    return true;
                }
                if (LintUtils.editDistance((String)match, (String)matchWith) > maxDistance) continue;
                String labelClass = suggestedBase.equals(actual) || actual.indexOf(46) != -1 ? suggested : suggestedBase;
                builder.addLink(String.format("Change to %1$s", labelClass), this.myLinkManager.createReplaceTagsUrl(actual, ResourceHelper.viewNeedsPackage(suggested) ? suggested : suggestedBase));
                builder.add(", ");
            }
        }
        return false;
    }

    private void reportUnknownFragments(@NotNull RenderLogger logger, final @NotNull HtmlBuilder builder) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportUnknownFragments"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportUnknownFragments"));
        }
        List<String> fragmentNames = logger.getMissingFragments();
        if (fragmentNames != null && !fragmentNames.isEmpty()) {
            builder.add("A ").addHtml("<code>").add("<fragment>").addHtml("</code>").add(" tag allows a layout file to dynamically include different layouts at runtime. ");
            builder.add("At layout editing time the specific layout to be used is not known. You can choose which layout you would like previewed while editing the layout.");
            builder.beginList();
            for (final String className : fragmentNames) {
                boolean isActivityKnown;
                builder.listItem();
                boolean isIdentified = className != null && !className.isEmpty();
                boolean bl = isActivityKnown = isIdentified && !className.startsWith("@");
                if (isIdentified) {
                    builder.add("<fragment ");
                    builder.addBold(className);
                    builder.add(" ...>");
                } else {
                    builder.add("<fragment>");
                }
                builder.add(" (");
                if (isActivityKnown) {
                    final Module module = logger.getModule();
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            assert (module != null);
                            Project project = module.getProject();
                            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                            PsiClass clz = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
                            String layoutName = RenderErrorPanel.this.myResult.getFile().getName();
                            boolean separate = false;
                            if (clz != null) {
                                String matchText = clz.getText();
                                Pattern LAYOUT_FIELD_PATTERN = Pattern.compile("R\\.layout\\.([a-z0-9_]+)");
                                Matcher matcher = LAYOUT_FIELD_PATTERN.matcher(matchText);
                                TreeSet layouts = Sets.newTreeSet();
                                int index = 0;
                                while (matcher.find(index)) {
                                    layouts.add(matcher.group(1));
                                    index = matcher.end();
                                }
                                for (String layout : layouts) {
                                    if (layout.equals(layoutName)) continue;
                                    if (separate) {
                                        builder.add(", ");
                                    }
                                    builder.addLink("Use @layout/" + layout, RenderErrorPanel.this.myLinkManager.createAssignLayoutUrl(className, layout));
                                    separate = true;
                                }
                            }
                            if (separate) {
                                builder.add(", ");
                            }
                            builder.addLink("Pick Layout...", RenderErrorPanel.this.myLinkManager.createPickLayoutUrl(className));
                        }
                    });
                } else {
                    builder.addLink("Choose Fragment Class...", this.myLinkManager.createAssignFragmentUrl(className));
                }
                builder.add(")");
            }
            builder.endList();
            builder.newline();
            builder.addLink("Do not warn about <fragment> tags in this session", this.myLinkManager.createIgnoreFragmentsUrl());
            builder.newline();
        }
    }

    @NotNull
    private static Collection<String> getAllViews(final @Nullable Module module) {
        if (module == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "getAllViews"));
            }
            return list;
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            Collection collection = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<String>>(){

                public Collection<String> compute() {
                    return RenderErrorPanel.getAllViews(module);
                }
            });
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "getAllViews"));
            }
            return collection;
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass psiClass : RenderErrorPanel.findInheritors(module, "android.view.View")) {
            String name = psiClass.getQualifiedName();
            if (name == null) continue;
            names.add(name);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "getAllViews"));
        }
        return hashSet;
    }

    @NotNull
    private static Collection<PsiClass> findInheritors(final @NotNull Module module, final @NotNull String name) {
        block8: {
            Collection collection;
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderErrorPanel", "findInheritors"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/rendering/RenderErrorPanel", "findInheritors"));
            }
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                Collection collection2 = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiClass>>(){

                    public Collection<PsiClass> compute() {
                        return RenderErrorPanel.findInheritors(module, name);
                    }
                });
                if (collection2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "findInheritors"));
                }
                return collection2;
            }
            Project project = module.getProject();
            try {
                PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
                if (base == null) break block8;
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
                collection = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true).findAll();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "findInheritors"));
            }
            return collection;
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "findInheritors"));
        }
        return list;
    }

    private void reportBrokenClasses(@NotNull RenderLogger logger, @NotNull HtmlBuilder builder) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportBrokenClasses"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportBrokenClasses"));
        }
        Map<String, Throwable> brokenClasses = logger.getBrokenClasses();
        if (brokenClasses != null && !brokenClasses.isEmpty()) {
            Object facet;
            final Module module = logger.getModule();
            if (module != null && (facet = AndroidFacet.getInstance(module)) != null && ((AndroidFacet)((Object)facet)).requiresAndroidModel() && ((AndroidFacet)((Object)facet)).getAndroidModel() != null) {
                AndroidProject androidProject = AndroidGradleModel.get((AndroidFacet)((Object)facet)).getAndroidProject();
                String modelVersion = androidProject.getModelVersion();
                if (GradleUtil.hasLayoutRenderingIssue(androidProject)) {
                    builder.addBold("Using an obsolete version of the Gradle plugin (" + modelVersion + "); this can lead to layouts not rendering correctly.").newline();
                    builder.addIcon(HtmlBuilderHelper.getTipIconPath());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            FixGradleModelVersionHyperlink quickFix = new FixGradleModelVersionHyperlink("1.3.0", null, false);
                            quickFix.executeIfClicked(module.getProject(), new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, quickFix.getUrl()));
                        }
                    };
                    builder.add("Tip: Either ").addLink("update the Gradle plugin build version to 1.2.3", this.myLinkManager.createRunnableLink(runnable)).add(" or later, or downgrade to version 1.1.3, or as a workaround, ");
                    builder.beginList();
                    builder.listItem().addLink("", "Build the project", ", then", this.myLinkManager.createCompileModuleUrl());
                    builder.listItem().addLink("", "Gradle Sync the project", ", then", this.myLinkManager.createSyncProjectUrl());
                    builder.listItem().addLink("Manually ", "refresh the layout", " (or restart the IDE)", this.myLinkManager.createRefreshRenderUrl());
                    builder.endList();
                    builder.newline();
                }
            }
            for (Throwable throwable : brokenClasses.values()) {
                if (!RenderLogger.isIssue164378(throwable)) continue;
                RenderLogger.addHtmlForIssue164378(throwable, module, this.myLinkManager, builder, false);
                break;
            }
            builder.add("The following classes could not be instantiated:");
            Throwable firstThrowable = null;
            builder.beginList();
            for (Map.Entry<String, Throwable> entry : brokenClasses.entrySet()) {
                String className = entry.getKey();
                Throwable throwable = entry.getValue();
                builder.listItem();
                builder.add(className);
                builder.add(" (");
                builder.addLink("Open Class", this.myLinkManager.createOpenClassUrl(className));
                if (throwable != null && module != null) {
                    builder.add(", ");
                    ShowExceptionFix detailsFix = new ShowExceptionFix(module.getProject(), throwable);
                    builder.addLink("Show Exception", this.myLinkManager.createRunnableLink(detailsFix));
                }
                builder.add(", ");
                builder.addLink("Clear Cache", this.myLinkManager.createRefreshRenderUrl());
                builder.add(")");
                if (firstThrowable != null || throwable == null) continue;
                firstThrowable = throwable;
            }
            builder.endList();
            builder.addIcon(HtmlBuilderHelper.getTipIconPath());
            builder.addLink("Tip: Use ", "View.isInEditMode()", " in your custom views to skip code or show sample data when shown in the IDE", "http://developer.android.com/reference/android/view/View.html#isInEditMode()");
            if (firstThrowable != null) {
                builder.newline().newline();
                builder.addHeading("Exception Details", HtmlBuilderHelper.getHeaderFontColor()).newline();
                this.reportThrowable(builder, firstThrowable, false);
                this.reportSandboxError(builder, firstThrowable, true, false);
            }
            builder.newline().newline();
        }
    }

    private void reportSandboxError(@NotNull HtmlBuilder builder, Throwable throwable, boolean newlineBefore, boolean newlineAfter) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportSandboxError"));
        }
        if (throwable instanceof SecurityException) {
            int version;
            if (newlineBefore) {
                builder.newline();
            }
            builder.addLink("Turn off custom view rendering sandbox", this.myLinkManager.createDisableSandboxUrl());
            String lastFailedPath = RenderSecurityManager.getLastFailedPath();
            if (lastFailedPath != null) {
                builder.newline().newline();
                builder.add("Diagnostic info for Studio bug report:").newline();
                builder.add("Failed path: ").add(lastFailedPath).newline();
                String tempDir = System.getProperty("java.io.tmpdir");
                builder.add("Normal temp dir: ").add(tempDir).newline();
                File normalized = new File(tempDir);
                builder.add("Normalized temp dir: ").add(normalized.getPath()).newline();
                try {
                    builder.add("Canonical temp dir: ").add(normalized.getCanonicalPath()).newline();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                builder.add("os.name: ").add(SystemInfo.OS_NAME).newline();
                builder.add("os.version: ").add(SystemInfo.OS_VERSION).newline();
                builder.add("java.runtime.version: ").add(SystemInfo.JAVA_RUNTIME_VERSION);
            }
            if (throwable.getMessage().equals("Unable to create temporary file") && SystemInfo.JAVA_VERSION.startsWith("1.7.0_") && (version = Integer.parseInt(SystemInfo.JAVA_VERSION.substring(SystemInfo.JAVA_VERSION.indexOf(95) + 1))) > 0 && version < 45) {
                builder.newline();
                builder.addIcon(HtmlBuilderHelper.getTipIconPath());
                builder.add("Tip: This may be caused by using an older version of JDK 1.7.0; try using at least 1.7.0_45 (you are using " + SystemInfo.JAVA_VERSION + ")");
            }
            if (newlineAfter) {
                builder.newline().newline();
            }
        }
    }

    private void reportRenderingFidelityProblems(@NotNull RenderLogger logger, @NotNull HtmlBuilder builder, final @NotNull RenderTask renderTask) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportRenderingFidelityProblems"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportRenderingFidelityProblems"));
        }
        if (renderTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderTask", "com/android/tools/idea/rendering/RenderErrorPanel", "reportRenderingFidelityProblems"));
        }
        List<RenderProblem> fidelityWarnings = logger.getFidelityWarnings();
        if (fidelityWarnings != null && !fidelityWarnings.isEmpty()) {
            builder.add("The graphics preview in the layout editor may not be accurate:").newline();
            builder.beginList();
            int count = 0;
            for (RenderProblem warning : fidelityWarnings) {
                int remaining;
                builder.listItem();
                warning.appendHtml(builder.getStringBuilder());
                final Object clientData = warning.getClientData();
                if (clientData != null) {
                    builder.addLink(" (Ignore for this session)", this.myLinkManager.createRunnableLink(new Runnable(){

                        @Override
                        public void run() {
                            RenderLogger.ignoreFidelityWarning(clientData);
                            RenderContext renderContext = renderTask.getRenderContext();
                            if (renderContext != null) {
                                renderContext.requestRender();
                            }
                        }
                    }));
                }
                builder.newline();
                if (++count != 3 || (remaining = fidelityWarnings.size() - count) <= 0) continue;
                builder.add("(").addHtml(Integer.toString(remaining)).add(" additional render fidelity issues hidden)");
                break;
            }
            builder.endList();
            builder.addLink("Ignore all fidelity warnings for this session", this.myLinkManager.createRunnableLink(new Runnable(){

                @Override
                public void run() {
                    RenderLogger.ignoreAllFidelityWarnings();
                    RenderContext renderContext = renderTask.getRenderContext();
                    if (renderContext != null) {
                        renderContext.requestRender();
                    }
                }
            }));
            builder.newline();
        }
    }

    private static void reportMissingStyles(RenderLogger logger, HtmlBuilder builder) {
        if (logger.seenTagPrefix("project.building")) {
            builder.addBold("Project Still Building: May cause rendering errors until the build is done.").newline();
            builder.newline().newline();
        } else if (logger.seenTagPrefix("resources.resolve.theme")) {
            builder.addBold("Missing styles. Is the correct theme chosen for this layout?").newline();
            builder.addIcon(HtmlBuilderHelper.getTipIconPath());
            builder.add("Use the Theme combo box above the layout to choose a different layout, or fix the theme style references.");
            builder.newline().newline();
        }
    }

    private static void reportOldNinePathRenderLib(RenderLogger logger, HtmlBuilder builder, @NotNull RenderTask renderTask) {
        if (renderTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderTask", "com/android/tools/idea/rendering/RenderErrorPanel", "reportOldNinePathRenderLib"));
        }
        for (Throwable trace : logger.getTraces()) {
            if (!trace.toString().contains("java.lang.IndexOutOfBoundsException: Index: 2, Size: 2") || renderTask.getConfiguration().getDensity() != Density.TV) continue;
            builder.addBold("It looks like you are using a render target where the layout library does not support the tvdpi density.");
            builder.newline().newline();
            builder.add("Please try either updating to the latest available version (using the SDK manager), or if no updated version is available for this specific version of Android, try using a more recent render target version.");
            builder.newline().newline();
            break;
        }
    }

    private static void reportRelevantCompilationErrors(RenderLogger logger, HtmlBuilder builder, RenderTask renderTask) {
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        WolfTheProblemSolver wolfgang = WolfTheProblemSolver.getInstance((Project)project);
        if (wolfgang.hasProblemFilesBeneath(module)) {
            boolean hasJavaErrors;
            if (logger.seenTagPrefix("resources.")) {
                boolean haveResourceErrors = wolfgang.hasProblemFilesBeneath((Condition)new Condition<VirtualFile>(){

                    public boolean value(VirtualFile virtualFile) {
                        return virtualFile.getFileType() == StdFileTypes.XML;
                    }
                });
                if (haveResourceErrors) {
                    builder.addBold("NOTE: This project contains resource errors, so aapt did not succeed, which can cause rendering failures. Fix resource problems first.");
                    builder.newline().newline();
                }
            } else if (renderTask.getLayoutlibCallback().isUsed() && (hasJavaErrors = wolfgang.hasProblemFilesBeneath((Condition)new Condition<VirtualFile>(){

                public boolean value(VirtualFile virtualFile) {
                    return virtualFile.getFileType() == StdFileTypes.JAVA;
                }
            }))) {
                builder.addBold("NOTE: This project contains Java compilation errors, which can cause rendering failures for custom views. Fix compilation problems first.");
                builder.newline().newline();
            }
        }
    }

    private void reportMissingSizeAttributes(final @NotNull RenderLogger logger, final HtmlBuilder builder, RenderTask renderTask) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSizeAttributes"));
        }
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        if (logger.isMissingSize()) {
            builder.addBold("NOTE: One or more layouts are missing the layout_width or layout_height attributes. These are required in most layouts.").newline();
            final ResourceResolver resourceResolver = renderTask.getResourceResolver();
            XmlFile psiFile = renderTask.getPsiFile();
            if (psiFile == null) {
                LOG.error("PsiFile is missing in RenderTask used in RenderErrorPanel!");
                return;
            }
            AddMissingAttributesFix fix = new AddMissingAttributesFix(project, psiFile, resourceResolver);
            List<XmlTag> missing = fix.findViewsMissingSizes();
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(module);
            final String fill = moduleInfo == null || moduleInfo.getBuildSdkVersion() == null || moduleInfo.getBuildSdkVersion().getApiLevel() >= 8 ? "match_parent" : "fill_parent";
            for (final XmlTag tag : missing) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        boolean missingHeight;
                        boolean missingWidth = !AddMissingAttributesFix.definesWidth(tag, resourceResolver);
                        boolean bl = missingHeight = !AddMissingAttributesFix.definesHeight(tag, resourceResolver);
                        assert (missingWidth || missingHeight);
                        String id = tag.getAttributeValue("id");
                        id = id == null || id.length() == 0 ? '<' + tag.getName() + '>' : '\"' + LintUtils.stripIdPrefix((String)id) + '\"';
                        if (missingWidth) {
                            RenderErrorPanel.this.reportMissingSize(builder, logger, fill, tag, id, "layout_width");
                        }
                        if (missingHeight) {
                            RenderErrorPanel.this.reportMissingSize(builder, logger, fill, tag, id, "layout_height");
                        }
                    }
                });
            }
            builder.newline();
            builder.add("Or: ");
            builder.addLink("Automatically add all missing attributes", this.myLinkManager.createCommandLink(fix)).newline();
            builder.newline().newline();
        }
    }

    private void reportOtherProblems(RenderLogger logger, HtmlBuilder builder) {
        List<RenderProblem> messages = logger.getMessages();
        if (messages != null && !messages.isEmpty()) {
            HashSet seenTags = Sets.newHashSet();
            for (RenderProblem message : messages) {
                String tag = message.getTag();
                if (tag != null && seenTags.contains(tag)) continue;
                seenTags.add(tag);
                HighlightSeverity severity = message.getSeverity();
                if (severity == HighlightSeverity.ERROR) {
                    builder.addIcon(HtmlBuilderHelper.getErrorIconPath());
                } else if (severity == HighlightSeverity.WARNING) {
                    builder.addIcon(HtmlBuilderHelper.getWarningIconPath());
                }
                String html = message.getHtml();
                Throwable throwable = message.getThrowable();
                if (throwable != null) {
                    this.reportSandboxError(builder, throwable, false, true);
                    if (this.reportThrowable(builder, throwable, !html.isEmpty() || !message.isDefaultHtml()) && !html.isEmpty()) {
                        builder.getStringBuilder().append(html);
                        builder.newlineIfNecessary();
                    }
                } else {
                    builder.getStringBuilder().append(html);
                    builder.newlineIfNecessary();
                }
                if (tag != null) {
                    int count;
                    if ("resources.format".equals(tag)) {
                        this.appendFlagValueSuggestions(builder, message);
                    }
                    if ((count = logger.getTagCount(tag)) > 1) {
                        builder.add(" (").addHtml(Integer.toString(count)).add(" similar errors not shown)");
                    }
                }
                builder.newline();
            }
        }
    }

    private void appendFlagValueSuggestions(HtmlBuilder builder, RenderProblem message) {
        String[] values;
        Object clientData = message.getClientData();
        if (!(clientData instanceof String[])) {
            return;
        }
        String[] strings = (String[])clientData;
        if (strings.length != 2) {
            return;
        }
        RenderTask renderTask = this.myResult.getRenderTask();
        if (renderTask == null) {
            return;
        }
        IAndroidTarget target = renderTask.getConfiguration().getTarget();
        if (target == null) {
            return;
        }
        AndroidPlatform platform = renderTask.getPlatform();
        if (platform == null) {
            return;
        }
        AndroidTargetData targetData = platform.getSdkData().getTargetData(target);
        AttributeDefinitions definitionLookup = targetData.getPublicAttrDefs(this.myResult.getFile().getProject());
        String attributeName = strings[0];
        String currentValue = strings[1];
        if (definitionLookup == null) {
            return;
        }
        AttributeDefinition definition = definitionLookup.getAttrDefByName(attributeName);
        if (definition == null) {
            return;
        }
        Set<AttributeFormat> formats = definition.getFormats();
        if ((formats.contains((Object)AttributeFormat.Flag) || formats.contains((Object)AttributeFormat.Enum)) && (values = definition.getValues()).length > 0) {
            builder.newline();
            builder.addNbsps(4);
            builder.add("Change ").add(currentValue).add(" to: ");
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    builder.add(", ");
                }
                builder.addLink(value, this.myLinkManager.createReplaceAttributeValueUrl(attributeName, currentValue, value));
            }
        }
    }

    private boolean reportThrowable(@NotNull HtmlBuilder builder, final @NotNull Throwable throwable, boolean hideIfIrrelevant) {
        StackTraceElement frame;
        int i;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportThrowable"));
        }
        if (throwable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/android/tools/idea/rendering/RenderErrorPanel", "reportThrowable"));
        }
        StackTraceElement[] frames = throwable.getStackTrace();
        int end = -1;
        boolean haveInterestingFrame = false;
        for (i = 0; i < frames.length; ++i) {
            String className;
            frame = frames[i];
            if (RenderErrorPanel.isInterestingFrame(frame)) {
                haveInterestingFrame = true;
            }
            if (!(className = frame.getClassName()).equals(RENDER_SESSION_IMPL_FQCN)) continue;
            end = i;
            break;
        }
        if (end == -1 || !haveInterestingFrame) {
            if (hideIfIrrelevant) {
                if (RenderLogger.isLoggingAllErrors()) {
                    ShowExceptionFix detailsFix = new ShowExceptionFix(this.myResult.getModule().getProject(), throwable);
                    builder.addLink("Show Exception", this.myLinkManager.createRunnableLink(detailsFix));
                }
                return true;
            }
            block1: for (i = 0; i < frames.length; ++i) {
                frame = frames[i];
                if (RenderErrorPanel.isVisible(frame)) continue;
                end = i;
                if (end != 0) break;
                for (int j = 0; j < frames.length; ++j) {
                    frame = frames[j];
                    String className = frame.getClassName();
                    if (!className.equals(RENDER_SESSION_IMPL_FQCN)) continue;
                    end = j;
                    break block1;
                }
                break;
            }
        }
        builder.add(throwable.toString()).newline();
        boolean wasHidden = false;
        int indent = 2;
        File platformSource = null;
        boolean platformSourceExists = true;
        for (int i2 = 0; i2 < end; ++i2) {
            String url;
            StackTraceElement frame2 = frames[i2];
            if (RenderErrorPanel.isHiddenFrame(frame2)) {
                wasHidden = true;
                continue;
            }
            String className = frame2.getClassName();
            String methodName = frame2.getMethodName();
            builder.addNbsps(indent);
            builder.add("at ").add(className).add(".").add(methodName);
            String fileName = frame2.getFileName();
            if (fileName == null || fileName.isEmpty()) continue;
            int lineNumber = frame2.getLineNumber();
            String location = fileName + ':' + lineNumber;
            if (RenderErrorPanel.isInterestingFrame(frame2)) {
                if (wasHidden) {
                    builder.addNbsps(indent);
                    builder.add("    ...").newline();
                    wasHidden = false;
                }
                url = this.myLinkManager.createOpenStackUrl(className, methodName, fileName, lineNumber);
                builder.add("(").addLink(location, url).add(")");
            } else {
                url = null;
                if (RenderErrorPanel.isFramework(frame2) && platformSourceExists) {
                    if (platformSource == null) {
                        IAndroidTarget target = this.myResult.getRenderTask().getConfiguration().getTarget();
                        platformSource = AndroidSdkUtils.findPlatformSources(target);
                        boolean bl = platformSourceExists = platformSource != null;
                    }
                    if (platformSourceExists) {
                        File parentFile;
                        File classFile = new File(platformSource, frame2.getClassName().replace('.', File.separatorChar) + ".java");
                        if (!classFile.exists() && !(classFile = new File((parentFile = classFile.getParentFile()).getParentFile(), parentFile.getName() + ".java")).exists()) {
                            classFile = null;
                        }
                        if (classFile != null) {
                            url = HtmlLinkManager.createFilePositionUrl(classFile, lineNumber, 0);
                        }
                    }
                }
                if (url != null) {
                    builder.add("(").addLink(location, url).add(")");
                } else {
                    builder.add("(").add(location).add(")");
                }
            }
            builder.newline();
        }
        builder.addLink("Copy stack to clipboard", this.myLinkManager.createRunnableLink(new Runnable(){

            @Override
            public void run() {
                String text = Throwables.getStackTraceAsString((Throwable)throwable);
                try {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        return false;
    }

    private static boolean isHiddenFrame(StackTraceElement frame) {
        String className = frame.getClassName();
        return className.startsWith("sun.reflect.") || className.equals("android.view.BridgeInflater") || className.startsWith("com.android.tools.") || className.startsWith("org.jetbrains.");
    }

    private static boolean isInterestingFrame(StackTraceElement frame) {
        String className = frame.getClassName();
        return !className.startsWith("android.") && !className.startsWith("org.jetbrains.") && !className.startsWith("com.android.") && !className.startsWith("java.") && !className.startsWith("javax.") && !className.startsWith("sun.");
    }

    private static boolean isFramework(StackTraceElement frame) {
        String className = frame.getClassName();
        return className.startsWith("android.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.");
    }

    private static boolean isVisible(StackTraceElement frame) {
        String className = frame.getClassName();
        return !RenderErrorPanel.isFramework(frame) && !className.startsWith("sun.");
    }

    private void reportMissingSize(@NotNull HtmlBuilder builder, @NotNull RenderLogger logger, @NotNull String fill, @NotNull XmlTag tag, @NotNull String id, @NotNull String attribute) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSize"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSize"));
        }
        if (fill == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fill", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSize"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSize"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSize"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/rendering/RenderErrorPanel", "reportMissingSize"));
        }
        Module module = logger.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        String wrapUrl = this.myLinkManager.createCommandLink(new SetAttributeFix(project, tag, attribute, "http://schemas.android.com/apk/res/android", "wrap_content"));
        String fillUrl = this.myLinkManager.createCommandLink(new SetAttributeFix(project, tag, attribute, "http://schemas.android.com/apk/res/android", fill));
        builder.add(String.format("%1$s does not set the required %2$s attribute: ", id, attribute));
        builder.newline();
        builder.addNbsps(4);
        builder.addLink("Set to wrap_content", wrapUrl);
        builder.add(", ");
        builder.addLink("Set to " + fill, fillUrl);
        builder.newline();
    }

    private void showEmpty() {
        try {
            this.myHTMLViewer.read(new StringReader("<html><body></body></html>"), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void reportInstantiationProblems(@NotNull RenderLogger logger, @NotNull HtmlBuilder builder) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderErrorPanel", "reportInstantiationProblems"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/idea/rendering/RenderErrorPanel", "reportInstantiationProblems"));
        }
        Map<String, Throwable> classesWithIncorrectFormat = logger.getClassesWithIncorrectFormat();
        if (classesWithIncorrectFormat != null && !classesWithIncorrectFormat.isEmpty()) {
            AndroidFacet facet;
            builder.add("Preview might be incorrect: unsupported class version.").newline();
            builder.addIcon(HtmlBuilderHelper.getTipIconPath());
            builder.add("Tip: ");
            builder.add("You need to run the IDE with the highest JDK version that you are compiling custom views with. ");
            int highest = ClassConverter.findHighestMajorVersion(classesWithIncorrectFormat.values());
            if (highest > 0 && highest > ClassConverter.getCurrentClassVersion()) {
                builder.add("One or more views have been compiled with JDK ");
                String required = ClassConverter.classVersionToJdk(highest);
                builder.add(required);
                builder.add(", but you are running the IDE on JDK ");
                builder.add(ClassConverter.getCurrentJdkVersion());
                builder.add(". ");
            } else {
                builder.add("For example, if you are compiling with sourceCompatibility 1.7, you must run the IDE with JDK 1.7. ");
            }
            builder.add("Running on a higher JDK is necessary such that these classes can be run in the layout renderer. (Or, extract your custom views into a library which you compile with a lower JDK version.)");
            builder.newline().newline();
            builder.addLink("If you have just accidentally built your code with a later JDK, try to ", "build", " the project.", this.myLinkManager.createCompileModuleUrl());
            builder.newline().newline();
            builder.add("Classes with incompatible format:");
            builder.beginList();
            ArrayList names = Lists.newArrayList(classesWithIncorrectFormat.keySet());
            Collections.sort(names);
            for (String className : names) {
                builder.listItem();
                builder.add(className);
                Throwable throwable = classesWithIncorrectFormat.get(className);
                if (!(throwable instanceof InconvertibleClassError)) continue;
                InconvertibleClassError error = (InconvertibleClassError)throwable;
                builder.add(" (Compiled with ");
                builder.add(ClassConverter.classVersionToJdk(error.getMajor()));
                builder.add(")");
            }
            builder.endList();
            Module module = logger.getModule();
            if (module == null) {
                return;
            }
            List<Module> problemModules = RenderErrorPanel.getProblemModules(module);
            if (!problemModules.isEmpty()) {
                builder.add("The following modules are built with incompatible JDK:").newline();
                Iterator<Module> it = problemModules.iterator();
                while (it.hasNext()) {
                    Module problemModule = it.next();
                    builder.add(problemModule.getName());
                    if (!it.hasNext()) continue;
                    builder.add(", ");
                }
                builder.newline();
            }
            if ((facet = AndroidFacet.getInstance(logger.getModule())) != null && !facet.requiresAndroidModel()) {
                Project project = logger.getModule().getProject();
                builder.addLink("Rebuild project with '-target 1.6'", this.myLinkManager.createRunnableLink(new RebuildWith16Fix(project)));
                builder.newline();
                if (!problemModules.isEmpty()) {
                    builder.addLink("Change Java SDK to 1.6", this.myLinkManager.createRunnableLink(new SwitchTo16Fix(project, problemModules)));
                    builder.newline();
                }
            }
        }
    }

    private static void askAndRebuild(Project project) {
        int r = Messages.showYesNoDialog((Project)project, (String)"You have to rebuild project to see the fixed preview. Would you like to do it?", (String)"Rebuild Project", (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            CompilerManager.getInstance((Project)project).rebuild(null);
        }
    }

    @NotNull
    private static Set<String> getSdkNamesFromModules(@NotNull Collection<Module> modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/rendering/RenderErrorPanel", "getSdkNamesFromModules"));
        }
        com.intellij.util.containers.HashSet result = new com.intellij.util.containers.HashSet();
        for (Module module : modules) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null) continue;
            result.add(sdk.getName());
        }
        com.intellij.util.containers.HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "getSdkNamesFromModules"));
        }
        return hashSet;
    }

    @NotNull
    private static List<Module> getProblemModules(@NotNull Module root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/rendering/RenderErrorPanel", "getProblemModules"));
        }
        ArrayList<Module> result = new ArrayList<Module>();
        RenderErrorPanel.collectProblemModules(root, (Set<Module>)new com.intellij.util.containers.HashSet(), result);
        ArrayList<Module> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderErrorPanel", "getProblemModules"));
        }
        return arrayList;
    }

    private static void collectProblemModules(@NotNull Module module, @NotNull Set<Module> visited, @NotNull Collection<Module> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderErrorPanel", "collectProblemModules"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/android/tools/idea/rendering/RenderErrorPanel", "collectProblemModules"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/rendering/RenderErrorPanel", "collectProblemModules"));
        }
        if (!visited.add(module)) {
            return;
        }
        if (RenderErrorPanel.isBuiltByJdk7OrHigher(module)) {
            result.add(module);
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            RenderErrorPanel.collectProblemModules(depModule, visited, result);
        }
    }

    static boolean isBuiltByJdk7OrHigher(@NotNull Module module) {
        Sdk jdk;
        AndroidSdkAdditionalData data;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderErrorPanel", "isBuiltByJdk7OrHigher"));
        }
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            return false;
        }
        if (AndroidSdkUtils.isAndroidSdk(sdk) && (data = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk)) != null && (jdk = data.getJavaSdk()) != null) {
            sdk = jdk;
        }
        return sdk.getSdkType() instanceof JavaSdk && JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_7);
    }

    public static class HtmlBuilderHelper {
        @Nullable
        private static String getIconPath(String relative) {
            URL resource = AllIcons.class.getClassLoader().getResource(relative);
            try {
                return resource != null ? resource.toURI().toURL().toExternalForm() : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        @Nullable
        public static String getCloseIconPath() {
            return HtmlBuilderHelper.getIconPath("/actions/closeNew.png");
        }

        @Nullable
        public static String getTipIconPath() {
            return HtmlBuilderHelper.getIconPath("/actions/createFromUsage.png");
        }

        @Nullable
        public static String getWarningIconPath() {
            return HtmlBuilderHelper.getIconPath("/actions/warning.png");
        }

        @Nullable
        public static String getErrorIconPath() {
            return HtmlBuilderHelper.getIconPath("/actions/error.png");
        }

        public static String getHeaderFontColor() {
            return UIUtil.isUnderDarcula() ? "#A5C25C" : "#005555";
        }
    }

    private static class SwitchTo16Fix
    implements Runnable {
        private final Project myProject;
        final List<Module> myProblemModules;

        private SwitchTo16Fix(Project project, List<Module> problemModules) {
            this.myProject = project;
            this.myProblemModules = problemModules;
        }

        @Override
        public void run() {
            String moduleToSelect;
            Sdk sdk;
            Set sdkNames = RenderErrorPanel.getSdkNamesFromModules(this.myProblemModules);
            if (sdkNames.size() == 1 && (sdk = ProjectJdkTable.getInstance().findJdk((String)sdkNames.iterator().next())) != null && sdk.getSdkType() instanceof AndroidSdkType) {
                final ProjectStructureConfigurable config = ProjectStructureConfigurable.getInstance((Project)this.myProject);
                if (ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)config, new Runnable(){

                    @Override
                    public void run() {
                        config.select(sdk, true);
                    }
                })) {
                    RenderErrorPanel.askAndRebuild(this.myProject);
                }
                return;
            }
            String string = moduleToSelect = this.myProblemModules.size() > 0 ? this.myProblemModules.iterator().next().getName() : null;
            if (ModulesConfigurator.showDialog((Project)this.myProject, (String)moduleToSelect, (String)ClasspathEditor.NAME)) {
                RenderErrorPanel.askAndRebuild(this.myProject);
            }
        }
    }

    private static class RebuildWith16Fix
    implements Runnable {
        private final Project myProject;

        private RebuildWith16Fix(Project project) {
            this.myProject = project;
        }

        @Override
        public void run() {
            JpsJavaCompilerOptions settings = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
            if (settings.ADDITIONAL_OPTIONS_STRING.length() > 0) {
                settings.ADDITIONAL_OPTIONS_STRING = settings.ADDITIONAL_OPTIONS_STRING + ' ';
            }
            settings.ADDITIONAL_OPTIONS_STRING = settings.ADDITIONAL_OPTIONS_STRING + "-target 1.6";
            CompilerManager.getInstance((Project)this.myProject).rebuild(null);
        }
    }
}

