/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderService {
    public static final boolean NELE_ENABLED = Boolean.getBoolean("nele.enabled");
    private static final Object RENDERING_LOCK = new Object();
    @NotNull
    private final AndroidFacet myFacet;
    private final Object myCredential;
    private static boolean ourWarnAboutObsoleteLayoutLibVersions = true;
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;

    public RenderService(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/RenderService", "<init>"));
        }
        this.myCredential = new Object();
        this.myFacet = facet;
    }

    @NotNull
    public static RenderService get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/rendering/RenderService", "get"));
        }
        RenderService renderService = facet.getRenderService();
        if (renderService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "get"));
        }
        return renderService;
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module, @Nullable IAndroidTarget target) {
        if (module == null || target == null) {
            return null;
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            }
            catch (RenderingException renderingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean supportsCapability(@NotNull Module module, @NotNull IAndroidTarget target, int capability) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "supportsCapability"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/rendering/RenderService", "supportsCapability"));
        }
        Project project = module.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            try {
                LayoutLibrary library = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
                if (library != null) {
                    return library.supports(capability);
                }
            }
            catch (RenderingException renderingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean canRender(@Nullable PsiFile file) {
        return file != null && LayoutPullParserFactory.isSupported(file);
    }

    @NotNull
    public RenderLogger createLogger() {
        Module module = this.getModule();
        RenderLogger renderLogger = new RenderLogger(module.getName(), module, this.myCredential);
        if (renderLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "createLogger"));
        }
        return renderLogger;
    }

    @Nullable
    public RenderTask createTask(@Nullable PsiFile psiFile, @NotNull Configuration configuration, @NotNull RenderLogger logger, @Nullable RenderContext renderContext) {
        LayoutLibrary layoutLib;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/rendering/RenderService", "createTask"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderService", "createTask"));
        }
        Module module = this.myFacet.getModule();
        Project project = module.getProject();
        AndroidPlatform platform = RenderService.getPlatform(module, logger);
        if (platform == null) {
            return null;
        }
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
            return null;
        }
        RenderService.warnIfObsoleteLayoutLib(module, logger, renderContext, target);
        try {
            layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            if (layoutLib == null) {
                String message = AndroidBundle.message("android.layout.preview.cannot.load.library.error", new Object[0]);
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
                return null;
            }
        }
        catch (RenderingException e) {
            String message = e.getPresentableMessage();
            message = message != null ? message : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message, module.getProject(), logger.getLinkManager(), e));
            return null;
        }
        catch (IOException e) {
            String message = e.getMessage();
            logger.error(null, "I/O error: " + (message != null ? ": " + message : ""), e);
            return null;
        }
        if (psiFile != null && "PreferenceScreen".equals(AndroidPsiUtils.getRootTagName(psiFile)) && !layoutLib.supports(14)) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "This version of the rendering library does not support rendering Preferences. Update it using the SDK Manager"));
            return null;
        }
        Device device = configuration.getDevice();
        if (device == null) {
            logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
            return null;
        }
        RenderTask task = new RenderTask(this, configuration, logger, layoutLib, device, this.myCredential);
        if (psiFile != null) {
            task.setPsiFile(psiFile);
        }
        task.setRenderContext(renderContext);
        return task;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/RenderService", "getFacet"));
        }
        return androidFacet;
    }

    public Module getModule() {
        return this.myFacet.getModule();
    }

    public Project getProject() {
        return this.getModule().getProject();
    }

    @Nullable
    public AndroidPlatform getPlatform() {
        return AndroidPlatform.getInstance(this.getModule());
    }

    @Nullable
    private static AndroidPlatform getPlatform(final @NotNull Module module, @Nullable RenderLogger logger) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "getPlatform"));
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null && logger != null) {
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                RenderProblem.Html message = RenderProblem.create(HighlightSeverity.ERROR);
                logger.addMessage(message);
                message.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger.getLinkManager().createRunnableLink(new Runnable(){

                    @Override
                    public void run() {
                        Project project = module.getProject();
                        ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                        if (Projects.requiresAndroidModel(project) && service instanceof AndroidProjectSettingsService) {
                            ((AndroidProjectSettingsService)service).openSdkSettings();
                            return;
                        }
                        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                    }
                }));
            } else {
                String message = AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName());
                logger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message));
            }
        }
        return platform;
    }

    protected static void warnIfObsoleteLayoutLib(final @NotNull Module module, @NotNull RenderLogger logger, final @Nullable RenderContext renderContext, @NotNull IAndroidTarget target) {
        int revision;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/rendering/RenderService", "warnIfObsoleteLayoutLib"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/RenderService", "warnIfObsoleteLayoutLib"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/rendering/RenderService", "warnIfObsoleteLayoutLib"));
        }
        if (!ourWarnAboutObsoleteLayoutLibVersions) {
            return;
        }
        if (target instanceof CompatibilityRenderTarget) {
            target = ((CompatibilityRenderTarget)target).getRenderTarget();
        }
        final AndroidVersion version = target.getVersion();
        switch (version.getFeatureLevel()) {
            case 21: {
                if (version.isPreview()) {
                    revision = 4;
                    break;
                }
                revision = 2;
                break;
            }
            case 20: {
                revision = 2;
                break;
            }
            case 19: {
                revision = 4;
                break;
            }
            case 18: {
                revision = 3;
                break;
            }
            case 17: {
                revision = 3;
                break;
            }
            case 16: {
                revision = 5;
                break;
            }
            case 15: {
                revision = 5;
                break;
            }
            case 14: {
                revision = 4;
                break;
            }
            case 13: {
                revision = 1;
                break;
            }
            case 12: {
                revision = 3;
                break;
            }
            case 11: {
                revision = 2;
                break;
            }
            case 10: {
                revision = 2;
                break;
            }
            case 8: {
                revision = 3;
                break;
            }
            default: {
                revision = -1;
            }
        }
        if (revision >= 0 && target.getRevision() < revision) {
            RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
            problem.tag("obsoleteLayoutlib");
            HtmlBuilder builder = problem.getHtmlBuilder();
            builder.add("Using an obsolete version of the " + target.getVersionName() + " layout library which contains many known bugs: ");
            builder.addLink("Install Update", logger.getLinkManager().createRunnableLink(new Runnable(){

                @Override
                public void run() {
                    ourWarnAboutObsoleteLayoutLibVersions = false;
                    ArrayList requested = Lists.newArrayList();
                    requested.add(PkgDesc.Builder.newPlatform((AndroidVersion)version, (MajorRevision)new MajorRevision(revision), (FullRevision)FullRevision.NOT_SPECIFIED).create());
                    SdkQuickfixWizard wizard = new SdkQuickfixWizard(module.getProject(), null, requested);
                    wizard.init();
                    if (wizard.showAndGet() && renderContext != null) {
                        Configuration configuration = renderContext.getConfiguration();
                        if (configuration != null) {
                            configuration.getConfigurationManager().setTarget(null);
                        }
                        renderContext.requestRender();
                        Messages.showInfoMessage((Project)module.getProject(), (String)"Note: Due to a bug you may need to restart the IDE for the new layout library to fully take effect", (String)"Restart Recommended");
                    }
                }
            }));
            builder.addLink(", ", "Ignore For Now", null, logger.getLinkManager().createRunnableLink(new Runnable(){

                @Override
                public void run() {
                    ourWarnAboutObsoleteLayoutLibVersions = false;
                    if (renderContext != null) {
                        renderContext.requestRender();
                    }
                }
            }));
            logger.addMessage(problem);
        }
    }

    public static void runRenderAction(final @NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/rendering/RenderService", "runRenderAction"));
        }
        RenderService.runRenderAction(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runRenderAction(@NotNull Callable<T> callable) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/android/tools/idea/rendering/RenderService", "runRenderAction"));
        }
        Object object = RENDERING_LOCK;
        synchronized (object) {
            return callable.call();
        }
    }

    public static ViewInfo getSafeBounds(ViewInfo view) {
        int left = Math.abs(view.getLeft());
        int right = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom = Math.abs(view.getBottom());
        if (left < 0x2000000 && right < 0x2000000 && top < 0x2000000 && bottom < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }
}

