/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.builder.model.AndroidProject;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.lang.databinding.DbUtil;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.ResourceHelper");
    public static final String STATE_NAME_PREFIX = "state_";

    public static boolean isProjectStyle(@NotNull String style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/rendering/ResourceHelper", "isProjectStyle"));
        }
        assert (style.startsWith("@style/") || style.startsWith("@android:style/")) : style;
        return style.startsWith("@style/");
    }

    @NotNull
    public static String styleToTheme(@NotNull String style) {
        int index;
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/rendering/ResourceHelper", "styleToTheme"));
        }
        if (style.startsWith("@style/")) {
            style = style.substring("@style/".length());
        } else if (style.startsWith("@android:style/")) {
            style = style.substring("@android:style/".length());
        } else if (style.startsWith("@") && (index = style.indexOf(47)) != -1) {
            style = style.substring(index + 1);
        }
        String string = style;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "styleToTheme"));
        }
        return string;
    }

    public static boolean isValueBasedResourceType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/rendering/ResourceHelper", "isValueBasedResourceType"));
        }
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType != ResourceFolderType.VALUES) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getResourceName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        String string = LintUtils.getBaseName((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static String getResourceName(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        String string = LintUtils.getBaseName((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getResourceName"));
        }
        return string;
    }

    @NotNull
    public static String getResourceUrl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/ResourceHelper", "getResourceUrl"));
        }
        ResourceFolderType type = ResourceFolderType.getFolderType((String)file.getParent().getName());
        assert (type != null && type != ResourceFolderType.VALUES);
        String string = "@" + type.getName() + '/' + ResourceHelper.getResourceName(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "getResourceUrl"));
        }
        return string;
    }

    public static boolean isFileBasedResourceType(@NotNull ResourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/rendering/ResourceHelper", "isFileBasedResourceType"));
        }
        List folderTypes = FolderTypeRelationship.getRelatedFolders((ResourceType)type);
        for (ResourceFolderType folderType : folderTypes) {
            if (folderType == ResourceFolderType.VALUES) continue;
            return type != ResourceType.ID;
        }
        return false;
    }

    @Nullable
    public static ResourceFolderType getFolderType(final @Nullable PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

                    @Nullable
                    public ResourceFolderType compute() {
                        return ResourceHelper.getFolderType(file);
                    }
                });
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderType(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return ResourceFolderType.getFolderType((String)parent.getName());
            }
        }
        return null;
    }

    @Nullable
    public static ResourceFolderType getFolderType(@Nullable VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return ResourceFolderType.getFolderType((String)parent.getName());
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration getFolderConfiguration(final @Nullable PsiFile file) {
        if (file != null) {
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                return (FolderConfiguration)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FolderConfiguration>(){

                    @Nullable
                    public FolderConfiguration compute() {
                        return ResourceHelper.getFolderConfiguration(file);
                    }
                });
            }
            if (!file.isValid()) {
                return ResourceHelper.getFolderConfiguration(file.getVirtualFile());
            }
            PsiDirectory parent = file.getParent();
            if (parent != null) {
                return FolderConfiguration.getConfigForFolder((String)parent.getName());
            }
        }
        return null;
    }

    @Nullable
    public static FolderConfiguration getFolderConfiguration(@Nullable VirtualFile file) {
        VirtualFile parent;
        if (file != null && (parent = file.getParent()) != null) {
            return FolderConfiguration.getConfigForFolder((String)parent.getName());
        }
        return null;
    }

    public static List<VirtualFile> getResourceVariations(@Nullable VirtualFile file, boolean includeSelf) {
        VirtualFile resFolder;
        if (file == null) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> variations = new ArrayList<VirtualFile>();
        String name = file.getName();
        VirtualFile parent = file.getParent();
        if (parent != null && (resFolder = parent.getParent()) != null) {
            String parentName = parent.getName();
            String prefix = parentName;
            int qualifiers = prefix.indexOf(45);
            if (qualifiers != -1) {
                parentName = prefix.substring(0, qualifiers);
                prefix = prefix.substring(0, qualifiers + 1);
            } else {
                prefix = prefix + '-';
            }
            for (VirtualFile resource : resFolder.getChildren()) {
                VirtualFile variation;
                String n = resource.getName();
                if (!n.startsWith(prefix) && !n.equals(parentName) || !resource.isDirectory() || (variation = resource.findChild(name)) == null || !includeSelf && file.equals(variation)) continue;
                variations.add(variation);
            }
        }
        return variations;
    }

    public static boolean viewNeedsPackage(String fqcn) {
        return !fqcn.startsWith("android.widget.") && !fqcn.startsWith("android.view.") && !fqcn.startsWith("android.webkit.");
    }

    @Nullable
    public static Color resolveColor(@NotNull RenderResources resources, @Nullable ResourceValue colorValue, @NotNull Project project) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveColor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/ResourceHelper", "resolveColor"));
        }
        if (colorValue != null) {
            colorValue = resources.resolveResValue(colorValue);
        }
        if (colorValue == null) {
            return null;
        }
        StateList stateList = ResourceHelper.resolveStateList(resources, colorValue, project);
        if (stateList != null) {
            List<StateListState> states = stateList.getStates();
            StateListState state = states.get(states.size() - 1);
            Color stateColor = ResourceHelper.parseColor(state.getValue());
            if (stateColor == null) {
                stateColor = ResourceHelper.resolveColor(resources, resources.findResValue(state.getValue(), false), project);
            }
            if (stateColor == null) {
                return null;
            }
            try {
                return ResourceHelper.makeColorWithAlpha(resources, stateColor, state.getAlpha());
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("The alpha attribute in %s/%s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                return stateColor;
            }
        }
        return ResourceHelper.parseColor(colorValue.getValue());
    }

    @NotNull
    public static List<Color> resolveMultipleColors(@NotNull RenderResources resources, @Nullable ResourceValue value, @NotNull Project project) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
        }
        if (value != null) {
            value = resources.resolveResValue(value);
        }
        if (value == null) {
            List<Color> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
            }
            return list;
        }
        ArrayList<Color> result = new ArrayList<Color>();
        StateList stateList = ResourceHelper.resolveStateList(resources, value, project);
        if (stateList != null) {
            for (StateListState state : stateList.getStates()) {
                Color color;
                ResourceValue resolvedStateResource = resources.findResValue(state.getValue(), false);
                ImmutableList stateColors = resolvedStateResource != null ? ResourceHelper.resolveMultipleColors(resources, resolvedStateResource, project) : ((color = ResourceHelper.parseColor(state.getValue())) == null ? Collections.emptyList() : ImmutableList.of((Object)color));
                for (Color color2 : stateColors) {
                    try {
                        result.add(ResourceHelper.makeColorWithAlpha(resources, color2, state.getAlpha()));
                    }
                    catch (NumberFormatException e) {
                        result.add(color2);
                        LOG.warn(String.format("The alpha attribute in %s/%s does not resolve to a floating point number", stateList.getDirName(), stateList.getFileName()));
                    }
                }
            }
        } else {
            Color color = ResourceHelper.parseColor(value.getValue());
            if (color != null) {
                result.add(color);
            }
        }
        ArrayList<Color> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveMultipleColors"));
        }
        return arrayList;
    }

    @NotNull
    public static String resolveStringValue(@NotNull RenderResources resources, @NotNull String value) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveStringValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/rendering/ResourceHelper", "resolveStringValue"));
        }
        ResourceValue resValue = resources.findResValue(value, false);
        if (resValue == null) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveStringValue"));
            }
            return string;
        }
        ResourceValue finalValue = resources.resolveResValue(resValue);
        if (finalValue == null || finalValue.getValue() == null) {
            String string = value;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveStringValue"));
            }
            return string;
        }
        String string = finalValue.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "resolveStringValue"));
        }
        return string;
    }

    @NotNull
    private static Color makeColorWithAlpha(@NotNull RenderResources resources, @NotNull Color color, @Nullable String alphaValue) throws NumberFormatException {
        int combinedAlpha;
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "makeColorWithAlpha"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/rendering/ResourceHelper", "makeColorWithAlpha"));
        }
        float alpha = 1.0f;
        if (alphaValue != null) {
            alpha = Float.parseFloat(ResourceHelper.resolveStringValue(resources, alphaValue));
        }
        if ((combinedAlpha = (int)((float)color.getAlpha() * alpha)) < 0) {
            combinedAlpha = 0;
        }
        if (combinedAlpha > 255) {
            combinedAlpha = 255;
        }
        Color color2 = ColorUtil.toAlpha((Color)color, (int)combinedAlpha);
        if (color2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper", "makeColorWithAlpha"));
        }
        return color2;
    }

    @Nullable
    public static StateList resolveStateList(@NotNull RenderResources renderResources, @NotNull ResourceValue value, @NotNull Project project) {
        if (renderResources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderResources", "com/android/tools/idea/rendering/ResourceHelper", "resolveStateList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/rendering/ResourceHelper", "resolveStateList"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/ResourceHelper", "resolveStateList"));
        }
        if (value.getValue().startsWith("@")) {
            ResourceValue resValue = renderResources.findResValue(value.getValue(), value.isFramework());
            if (resValue != null) {
                return ResourceHelper.resolveStateList(renderResources, resValue, project);
            }
        } else {
            XmlTag rootTag;
            PsiFile psiFile;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(value.getValue());
            if (virtualFile != null && (psiFile = AndroidPsiUtils.getPsiFileSafely(project, virtualFile)) instanceof XmlFile && (rootTag = ((XmlFile)psiFile).getRootTag()) != null && "selector".equals(rootTag.getName())) {
                StateList stateList = new StateList(psiFile.getName(), psiFile.getContainingDirectory().getName());
                for (XmlTag subTag : rootTag.findSubTags("item")) {
                    StateListState stateListState = ResourceHelper.createStateListState(subTag, value.isFramework());
                    if (stateListState == null) {
                        return null;
                    }
                    stateList.addState(stateListState);
                }
                return stateList;
            }
        }
        return null;
    }

    @Nullable
    private static StateListState createStateListState(XmlTag tag, boolean isFramework) {
        XmlAttribute[] attributes;
        String stateValue = null;
        String alphaValue = null;
        HashMap<String, Boolean> stateAttributes = new HashMap<String, Boolean>();
        for (XmlAttribute attr : attributes = tag.getAttributes()) {
            ResourceUrl url;
            String name = attr.getLocalName();
            String value = attr.getValue();
            if (value == null) continue;
            if ("color".equals(name) || "drawable".equals(name)) {
                url = ResourceUrl.parse((String)value, (boolean)isFramework);
                stateValue = url != null ? url.toString() : value;
                continue;
            }
            if ("alpha".equals(name)) {
                url = ResourceUrl.parse((String)value, (boolean)isFramework);
                alphaValue = url != null ? url.toString() : value;
                continue;
            }
            if (!name.startsWith(STATE_NAME_PREFIX)) continue;
            stateAttributes.put(name, Boolean.valueOf(value));
        }
        if (stateValue == null) {
            return null;
        }
        return new StateListState(stateValue, stateAttributes, alphaValue);
    }

    @Nullable
    public static Color parseColor(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        if (s.charAt(0) == '#') {
            long longColor;
            try {
                longColor = Long.parseLong(s.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (s.length() == 4 || s.length() == 5) {
                long a = s.length() == 4 ? 255L : ResourceHelper.extend((longColor & 0xF000L) >> 12);
                long r = ResourceHelper.extend((longColor & 0xF00L) >> 8);
                long g = ResourceHelper.extend((longColor & 0xF0L) >> 4);
                long b = ResourceHelper.extend(longColor & 0xFL);
                longColor = a << 24 | r << 16 | g << 8 | b;
                return new Color((int)longColor, true);
            }
            if (s.length() == 7) {
                longColor |= 0xFFFFFFFFFF000000L;
            } else if (s.length() != 9) {
                return null;
            }
            return new Color((int)longColor, true);
        }
        return null;
    }

    public static String colorToString(Color color) {
        long longColor = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (color.getAlpha() != 255) {
            return String.format("#%08x", longColor |= (long)color.getAlpha() << 24);
        }
        return String.format("#%06x", longColor);
    }

    private static long extend(long nibble) {
        return nibble | nibble << 4;
    }

    @Nullable
    public static File resolveDrawable(@NotNull RenderResources resources, @Nullable ResourceValue drawable, @NotNull Project project) {
        File file;
        List<StateListState> states;
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveDrawable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/ResourceHelper", "resolveDrawable"));
        }
        if (drawable != null) {
            drawable = resources.resolveResValue(drawable);
        }
        if (drawable == null) {
            return null;
        }
        String result = drawable.getValue();
        StateList stateList = ResourceHelper.resolveStateList(resources, drawable, project);
        if (stateList != null && !(states = stateList.getStates()).isEmpty()) {
            StateListState state = states.get(states.size() - 1);
            result = state.getValue();
        }
        return (file = new File(result)).isFile() ? file : null;
    }

    @Nullable
    public static File resolveLayout(@NotNull RenderResources resources, @Nullable ResourceValue layout) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/rendering/ResourceHelper", "resolveLayout"));
        }
        if (layout != null) {
            layout = resources.resolveResValue(layout);
        }
        if (layout == null) {
            return null;
        }
        String value = layout.getValue();
        for (int depth = 0; value != null && depth < 50; ++depth) {
            if (value.startsWith("@{") && (value = DbUtil.getBindingExprDefault(value)) == null) {
                return null;
            }
            if (value.startsWith("@")) {
                boolean isFramework = layout.isFramework();
                if ((layout = resources.findResValue(value, isFramework)) == null) break;
            } else {
                File file = new File(value);
                if (file.exists()) {
                    return file;
                }
                return null;
            }
            value = layout.getValue();
        }
        return null;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public static String prependResourcePrefix(@Nullable Module module, @Nullable String name) {
        String resourcePrefix;
        AndroidGradleModel androidModel;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidGradleModel.get(facet)) != null && (resourcePrefix = LintUtils.computeResourcePrefix((AndroidProject)androidModel.getAndroidProject())) != null) {
            if (name != null) {
                return name.startsWith(resourcePrefix) ? name : LintUtils.computeResourceName((String)resourcePrefix, (String)name);
            }
            return resourcePrefix;
        }
        return name;
    }

    public static class StateListState {
        private String myValue;
        private String myAlpha;
        private final Map<String, Boolean> myAttributes;

        public StateListState(@NotNull String value, @NotNull Map<String, Boolean> attributes, @Nullable String alpha) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/rendering/ResourceHelper$StateListState", "<init>"));
            }
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/rendering/ResourceHelper$StateListState", "<init>"));
            }
            this.myValue = value;
            this.myAttributes = attributes;
            this.myAlpha = alpha;
        }

        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/rendering/ResourceHelper$StateListState", "setValue"));
            }
            this.myValue = value;
        }

        public void setAlpha(String alpha) {
            this.myAlpha = alpha;
        }

        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper$StateListState", "getValue"));
            }
            return string;
        }

        @Nullable
        public String getAlpha() {
            return this.myAlpha;
        }

        @NotNull
        public Map<String, Boolean> getAttributes() {
            Map<String, Boolean> map = this.myAttributes;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper$StateListState", "getAttributes"));
            }
            return map;
        }
    }

    public static class StateList {
        private final String myFileName;
        private final String myDirName;
        private final List<StateListState> myStates;

        public StateList(@NotNull String fileName, @NotNull String dirName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/rendering/ResourceHelper$StateList", "<init>"));
            }
            if (dirName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/android/tools/idea/rendering/ResourceHelper$StateList", "<init>"));
            }
            this.myFileName = fileName;
            this.myDirName = dirName;
            this.myStates = new ArrayList<StateListState>();
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper$StateList", "getFileName"));
            }
            return string;
        }

        @NotNull
        public String getDirName() {
            String string = this.myDirName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper$StateList", "getDirName"));
            }
            return string;
        }

        @NotNull
        public ResourceFolderType getType() {
            ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)this.myDirName);
            if (resourceFolderType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper$StateList", "getType"));
            }
            return resourceFolderType;
        }

        @NotNull
        public List<StateListState> getStates() {
            List<StateListState> list = this.myStates;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/ResourceHelper$StateList", "getStates"));
            }
            return list;
        }

        public void addState(@NotNull StateListState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/rendering/ResourceHelper$StateList", "addState"));
            }
            this.myStates.add(state);
        }
    }
}

